/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Collection;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEmbedded;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEntity;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;

public abstract class AbstractVisitor {
    private final EventSource session;

    AbstractVisitor(EventSource session) {
        this.session = session;
    }

    final void processValues(Object[] values, Collection<PersistentAttributeDescriptor> attributes) throws HibernateException {
        int i = 0;
        for (PersistentAttributeDescriptor attribute : attributes) {
            if (this.includeProperty(values, i)) {
                this.processValue(i, values, attribute);
            }
            ++i;
        }
    }

    void processValue(int i, Object[] values, PersistentAttributeDescriptor attribute) throws HibernateException {
        this.processValue(values[i], attribute);
    }

    public void processEntityPropertyValues(Object[] values, List<PersistentAttributeDescriptor> attributes) throws HibernateException {
        for (int i = 0; i < attributes.size(); ++i) {
            if (!this.includeEntityProperty(values, i)) continue;
            this.processValue(i, values, attributes.get(i));
        }
    }

    boolean includeEntityProperty(Object[] values, int i) {
        return this.includeProperty(values, i);
    }

    boolean includeProperty(Object[] values, int i) {
        return values[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY;
    }

    Object processComponent(Object component, EmbeddedTypeDescriptor descriptor) throws HibernateException {
        if (component != null) {
            this.processValues(descriptor.getPropertyValues(component), descriptor.getPersistentAttributes());
        }
        return null;
    }

    final Object processValue(Object value, PersistentAttributeDescriptor attribute) throws HibernateException {
        if (attribute instanceof PluralPersistentAttribute) {
            return this.processCollection(value, (PluralPersistentAttribute)attribute);
        }
        if (attribute instanceof SingularPersistentAttributeEntity) {
            return this.processEntity(value, ((SingularPersistentAttributeEntity)attribute).getEntityDescriptor());
        }
        if (attribute instanceof SingularPersistentAttributeEmbedded) {
            return this.processComponent(value, ((SingularPersistentAttributeEmbedded)attribute).getEmbeddedDescriptor());
        }
        return null;
    }

    void process(Object object, EntityTypeDescriptor entityDescriptor) throws HibernateException {
        this.processEntityPropertyValues(entityDescriptor.getPropertyValues(object), entityDescriptor.getPersistentAttributes());
    }

    Object processCollection(Object collection, PluralPersistentAttribute collectionAttribute) throws HibernateException {
        return null;
    }

    Object processEntity(Object value, EntityTypeDescriptor descriptor) throws HibernateException {
        return null;
    }

    final EventSource getSession() {
        return this.session;
    }
}

