/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.List;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransientObjectException;
import org.hibernate.action.internal.EntityDeleteAction;
import org.hibernate.action.internal.OrphanRemovalAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.Nullability;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.OnUpdateVisitor;
import org.hibernate.event.service.spi.JpaBootstrapSensitive;
import org.hibernate.event.spi.DeleteEvent;
import org.hibernate.event.spi.DeleteEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.internal.TypeHelper;

public class DefaultDeleteEventListener
implements DeleteEventListener,
CallbackRegistryConsumer,
JpaBootstrapSensitive {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultDeleteEventListener.class);
    private CallbackRegistry callbackRegistry;
    private boolean jpaBootstrap;

    @Override
    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    @Override
    public void wasJpaBootstrap(boolean wasJpaBootstrap) {
        this.jpaBootstrap = wasJpaBootstrap;
    }

    @Override
    public void onDelete(DeleteEvent event) throws HibernateException {
        this.onDelete(event, new IdentitySet());
    }

    @Override
    public void onDelete(DeleteEvent event, Set transientEntities) throws HibernateException {
        Object version;
        Object id;
        EntityTypeDescriptor descriptor;
        Object entity;
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContext();
        EntityEntry entityEntry = persistenceContext.getEntry(entity = persistenceContext.unproxyAndReassociate(event.getObject()));
        if (entityEntry == null) {
            LOG.trace("Entity was not persistent in delete processing");
            descriptor = source.getEntityDescriptor(event.getEntityName(), entity);
            if (ForeignKeys.isTransient(descriptor.getEntityName(), entity, null, source)) {
                this.deleteTransientEntity(source, entity, event.isCascadeDeleteEnabled(), descriptor, transientEntities);
                return;
            }
            this.performDetachedEntityDeletionCheck(event);
            id = descriptor.getIdentifier(entity);
            if (id == null) {
                throw new TransientObjectException("the detached instance passed to delete() had a null identifier");
            }
            EntityKey key = source.generateEntityKey(id, descriptor);
            persistenceContext.checkUniqueness(key, entity);
            new OnUpdateVisitor(source, id, entity).process(entity, descriptor);
            version = descriptor.getVersion(entity);
            entityEntry = persistenceContext.addEntity(entity, descriptor.getHierarchy().getMutabilityPlan().isMutable() ? Status.MANAGED : Status.READ_ONLY, descriptor.getPropertyValues(entity), key, version, LockMode.NONE, true, descriptor, false);
            descriptor.afterReassociate(entity, source);
        } else {
            LOG.trace("Deleting a persistent instance");
            if (entityEntry.getStatus() == Status.DELETED || entityEntry.getStatus() == Status.GONE) {
                LOG.trace("Object was already deleted");
                return;
            }
            descriptor = entityEntry.getDescriptor();
            id = entityEntry.getId();
            version = entityEntry.getVersion();
        }
        if (this.invokeDeleteLifecycle(source, entity, descriptor)) {
            return;
        }
        this.deleteEntity(source, entity, entityEntry, event.isCascadeDeleteEnabled(), event.isOrphanRemovalBeforeUpdates(), descriptor, transientEntities);
        if (source.getFactory().getSettings().isIdentifierRollbackEnabled()) {
            descriptor.resetIdentifier(entity, id, version, source);
        }
    }

    protected void performDetachedEntityDeletionCheck(DeleteEvent event) {
        if (this.jpaBootstrap) {
            this.disallowDeletionOfDetached(event);
        }
    }

    private void disallowDeletionOfDetached(DeleteEvent event) {
        EventSource source = event.getSession();
        String entityName = event.getEntityName();
        EntityTypeDescriptor descriptor = source.getEntityDescriptor(entityName, event.getObject());
        Object id = descriptor.getIdentifier(event.getObject());
        entityName = entityName == null ? source.guessEntityName(event.getObject()) : entityName;
        throw new IllegalArgumentException("Removing a detached instance " + entityName + "#" + id);
    }

    protected void deleteTransientEntity(EventSource session, Object entity, boolean cascadeDeleteEnabled, EntityTypeDescriptor descriptor, Set transientEntities) {
        LOG.handlingTransientEntity();
        if (transientEntities.contains(entity)) {
            LOG.trace("Already handled transient entity; skipping");
            return;
        }
        transientEntities.add(entity);
        this.cascadeBeforeDelete(session, descriptor, entity, null, transientEntities);
        this.cascadeAfterDelete(session, descriptor, entity, transientEntities);
    }

    protected final void deleteEntity(EventSource session, Object entity, EntityEntry entityEntry, boolean isCascadeDeleteEnabled, boolean isOrphanRemovalBeforeUpdates, EntityTypeDescriptor entityDescriptor, Set transientEntities) {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Deleting {0}", MessageHelper.infoString(entityDescriptor, entityEntry.getId(), session.getFactory()));
        }
        PersistenceContext persistenceContext = session.getPersistenceContext();
        Object version = entityEntry.getVersion();
        Object[] currentState = entityEntry.getLoadedState() == null ? entityDescriptor.getPropertyValues(entity) : entityEntry.getLoadedState();
        Object[] deletedState = this.createDeletedState(entityDescriptor, currentState, session);
        entityEntry.setDeletedState(deletedState);
        session.getInterceptor().onDelete(entity, entityEntry.getId(), deletedState, entityDescriptor.getPropertyNames(), entityDescriptor.getPropertyJavaTypeDescriptors());
        persistenceContext.setEntryStatus(entityEntry, Status.DELETED);
        EntityKey key = session.generateEntityKey(entityEntry.getId(), entityDescriptor);
        this.cascadeBeforeDelete(session, entityDescriptor, entity, entityEntry, transientEntities);
        List attributes = entityDescriptor.getPersistentAttributes();
        new ForeignKeys.Nullifier(entity, true, false, session).nullifyTransientReferences(entityEntry.getDeletedState(), attributes);
        new Nullability(session).checkNullability(entityEntry.getDeletedState(), entityDescriptor, Nullability.NullabilityCheckType.DELETE);
        persistenceContext.getNullifiableEntityKeys().add(key);
        if (isOrphanRemovalBeforeUpdates) {
            session.getActionQueue().addAction(new OrphanRemovalAction(entityEntry.getId(), deletedState, version, entity, entityDescriptor, isCascadeDeleteEnabled, session));
        } else {
            session.getActionQueue().addAction(new EntityDeleteAction(entityEntry.getId(), deletedState, version, entity, entityDescriptor, isCascadeDeleteEnabled, session));
        }
        this.cascadeAfterDelete(session, entityDescriptor, entity, transientEntities);
    }

    private Object[] createDeletedState(EntityTypeDescriptor entityDescriptor, Object[] currentState, EventSource session) {
        Object[] deletedState = new Object[currentState.length];
        TypeHelper.deepCopy(entityDescriptor, currentState, deletedState, navigable -> true);
        return deletedState;
    }

    protected boolean invokeDeleteLifecycle(EventSource session, Object entity, EntityTypeDescriptor descriptor) {
        this.callbackRegistry.preRemove(entity);
        if (descriptor.implementsLifecycle()) {
            LOG.debug("Calling onDelete()");
            if (((Lifecycle)entity).onDelete(session)) {
                LOG.debug("Deletion vetoed by onDelete()");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeDelete(EventSource session, EntityTypeDescriptor descriptor, Object entity, EntityEntry entityEntry, Set transientEntities) throws HibernateException {
        CacheMode cacheMode = session.getCacheMode();
        session.setCacheMode(CacheMode.GET);
        session.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascade.cascade(CascadingActions.DELETE, CascadePoint.AFTER_INSERT_BEFORE_DELETE, session, descriptor, entity, transientEntities);
        }
        finally {
            session.getPersistenceContext().decrementCascadeLevel();
            session.setCacheMode(cacheMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterDelete(EventSource session, EntityTypeDescriptor descriptor, Object entity, Set transientEntities) throws HibernateException {
        CacheMode cacheMode = session.getCacheMode();
        session.setCacheMode(CacheMode.GET);
        session.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascade.cascade(CascadingActions.DELETE, CascadePoint.BEFORE_INSERT_AFTER_DELETE, session, descriptor, entity, transientEntities);
        }
        finally {
            session.getPersistenceContext().decrementCascadeLevel();
            session.setCacheMode(cacheMode);
        }
    }
}

