/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Arrays;
import java.util.List;
import org.hibernate.AssertionFailure;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.HibernateException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.action.internal.EntityUpdateAction;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.internal.Nullability;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.DirtyCollectionSearchVisitor;
import org.hibernate.event.internal.FlushVisitor;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEntityEvent;
import org.hibernate.event.spi.FlushEntityEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NaturalIdDescriptor;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.pretty.MessageHelper;

public class DefaultFlushEntityEventListener
implements FlushEntityEventListener,
CallbackRegistryConsumer {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultFlushEntityEventListener.class);
    private CallbackRegistry callbackRegistry;

    @Override
    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public void checkId(Object object, EntityTypeDescriptor entityDescriptor, Object id, SessionImplementor session) throws HibernateException {
        if (id != null && id instanceof DelayedPostInsertIdentifier) {
            return;
        }
        Object oid = entityDescriptor.getIdentifier(object);
        if (id == null) {
            throw new AssertionFailure("null id in " + entityDescriptor.getEntityName() + " entry (don't flush the Session after an exception occurs)");
        }
        if (!entityDescriptor.getIdentifierDescriptor().getJavaTypeDescriptor().areEqual(id, oid)) {
            throw new HibernateException("identifier of an instance of " + entityDescriptor.getEntityName() + " was altered from " + id + " to " + oid);
        }
    }

    private void checkNaturalId(EntityTypeDescriptor entityDescriptor, EntityEntry entry, Object[] current, Object[] loaded, SessionImplementor session) {
        NaturalIdDescriptor naturalIdentifierDescriptor = entityDescriptor.getHierarchy().getNaturalIdDescriptor();
        if (naturalIdentifierDescriptor == null || entry.getStatus() == Status.READ_ONLY) {
            return;
        }
        if (naturalIdentifierDescriptor.isMutable()) {
            return;
        }
        Object[] snapshot = loaded == null ? session.getPersistenceContext().getNaturalIdSnapshot(entry.getId(), entityDescriptor) : session.getPersistenceContext().getNaturalIdHelper().extractNaturalIdValues(loaded, entityDescriptor);
        naturalIdentifierDescriptor.visitPersistentAttributes(naturalIdAttributeInfo -> {
            boolean changed;
            Object previousAttributeValue = snapshot[naturalIdAttributeInfo.getStateArrayPosition()];
            Object currentAttributeValue = current[naturalIdAttributeInfo.getStateArrayPosition()];
            boolean bl = changed = !naturalIdAttributeInfo.getUnderlyingAttributeDescriptor().getJavaTypeDescriptor().areEqual(previousAttributeValue, currentAttributeValue);
            if (changed) {
                throw new HibernateException(String.format("An immutable natural identifier of entity %s was altered from %s to %s", entityDescriptor.getEntityName(), naturalIdAttributeInfo.getUnderlyingAttributeDescriptor().getJavaTypeDescriptor().extractLoggableRepresentation(previousAttributeValue), naturalIdAttributeInfo.getUnderlyingAttributeDescriptor().getJavaTypeDescriptor().extractLoggableRepresentation(currentAttributeValue)));
            }
        });
    }

    @Override
    public void onFlushEntity(FlushEntityEvent event) throws HibernateException {
        Object entity = event.getEntity();
        EntityEntry entry = event.getEntityEntry();
        EventSource session = event.getSession();
        EntityTypeDescriptor entityDescriptor = entry.getDescriptor();
        Status status = entry.getStatus();
        List persistentAttributes = entityDescriptor.getPersistentAttributes();
        boolean mightBeDirty = entry.requiresDirtyCheck(entity);
        Object[] values = this.getValues(entity, entry, mightBeDirty, session);
        event.setPropertyValues(values);
        boolean substitute = this.wrapCollections(session, entityDescriptor, persistentAttributes, values);
        if (this.isUpdateNecessary(event, mightBeDirty)) {
            boolean bl = substitute = this.scheduleUpdate(event) || substitute;
        }
        if (status != Status.DELETED) {
            if (substitute) {
                entityDescriptor.setPropertyValues(entity, values);
            }
            if (entityDescriptor.hasCollections()) {
                new FlushVisitor(session, entity).processEntityPropertyValues(values, persistentAttributes);
            }
        }
    }

    private Object[] getValues(Object entity, EntityEntry entry, boolean mightBeDirty, SessionImplementor session) {
        Object[] values;
        Object[] loadedState = entry.getLoadedState();
        Status status = entry.getStatus();
        EntityTypeDescriptor descriptor = entry.getDescriptor();
        if (status == Status.DELETED) {
            values = entry.getDeletedState();
        } else if (!mightBeDirty && loadedState != null) {
            values = loadedState;
        } else {
            this.checkId(entity, descriptor, entry.getId(), session);
            values = descriptor.getPropertyValues(entity);
            this.checkNaturalId(descriptor, entry, values, loadedState, session);
        }
        return values;
    }

    private boolean wrapCollections(EventSource session, EntityTypeDescriptor entityDescriptor, List<PersistentAttributeDescriptor> persistentAttributes, Object[] values) {
        if (!entityDescriptor.hasCollections()) {
            return false;
        }
        WrapVisitor visitor = new WrapVisitor(session);
        visitor.processEntityPropertyValues(values, persistentAttributes);
        return visitor.isSubstitutionRequired();
    }

    private boolean isUpdateNecessary(FlushEntityEvent event, boolean mightBeDirty) {
        Status status = event.getEntityEntry().getStatus();
        if (mightBeDirty || status == Status.DELETED) {
            this.dirtyCheck(event);
            if (this.isUpdateNecessary(event)) {
                return true;
            }
            if (SelfDirtinessTracker.class.isInstance(event.getEntity())) {
                ((SelfDirtinessTracker)event.getEntity()).$$_hibernate_clearDirtyAttributes();
            }
            event.getSession().getFactory().getCustomEntityDirtinessStrategy().resetDirty(event.getEntity(), event.getEntityEntry().getDescriptor(), event.getSession());
            return false;
        }
        return this.hasDirtyCollections(event, event.getEntityEntry().getDescriptor(), status);
    }

    private boolean scheduleUpdate(FlushEntityEvent event) {
        EntityEntry entry = event.getEntityEntry();
        EventSource session = event.getSession();
        Object entity = event.getEntity();
        Status status = entry.getStatus();
        EntityTypeDescriptor entityDescriptor = entry.getDescriptor();
        Object[] values = event.getPropertyValues();
        if (LOG.isTraceEnabled()) {
            if (status == Status.DELETED) {
                if (!entityDescriptor.getHierarchy().getMutabilityPlan().isMutable()) {
                    LOG.tracev("Updating immutable, deleted entity: {0}", MessageHelper.infoString(entityDescriptor, entry.getId(), session.getFactory()));
                } else if (!entry.isModifiableEntity()) {
                    LOG.tracev("Updating non-modifiable, deleted entity: {0}", MessageHelper.infoString(entityDescriptor, entry.getId(), session.getFactory()));
                } else {
                    LOG.tracev("Updating deleted entity: ", MessageHelper.infoString(entityDescriptor, entry.getId(), session.getFactory()));
                }
            } else {
                LOG.tracev("Updating entity: {0}", MessageHelper.infoString(entityDescriptor, entry.getId(), session.getFactory()));
            }
        }
        boolean intercepted = !entry.isBeingReplicated() && this.handleInterception(event);
        Object nextVersion = this.getNextVersion(event);
        int[] dirtyProperties = event.getDirtyProperties();
        if (event.isDirtyCheckPossible() && dirtyProperties == null) {
            if (!intercepted && !event.hasDirtyCollection()) {
                throw new AssertionFailure("dirty, but no dirty properties");
            }
            dirtyProperties = ArrayHelper.EMPTY_INT_ARRAY;
        }
        new Nullability(session).checkNullability(values, entityDescriptor, true);
        session.getActionQueue().addAction(new EntityUpdateAction(entry.getId(), values, dirtyProperties, event.hasDirtyCollection(), status == Status.DELETED && !entry.isModifiableEntity() ? entityDescriptor.getPropertyValues(entity) : entry.getLoadedState(), entry.getVersion(), nextVersion, entity, entry.getRowId(), entityDescriptor, session));
        return intercepted;
    }

    protected boolean handleInterception(FlushEntityEvent event) {
        Object[] values;
        EventSource session = event.getSession();
        EntityEntry entry = event.getEntityEntry();
        EntityTypeDescriptor entityDescriptor = entry.getDescriptor();
        Object entity = event.getEntity();
        boolean intercepted = this.invokeInterceptor(session, entity, entry, values = event.getPropertyValues(), entityDescriptor);
        if (intercepted && event.isDirtyCheckPossible()) {
            this.dirtyCheck(event);
        }
        return intercepted;
    }

    protected boolean invokeInterceptor(SessionImplementor session, Object entity, EntityEntry entry, Object[] values, EntityTypeDescriptor entityDescriptor) {
        boolean isDirty = false;
        if (entry.getStatus() != Status.DELETED && this.callbackRegistry.preUpdate(entity)) {
            isDirty = this.copyState(entity, entityDescriptor, values, session.getFactory());
        }
        if (isDirty) {
            return true;
        }
        return session.getInterceptor().onFlushDirty(entity, entry.getId(), values, entry.getLoadedState(), entityDescriptor.getPropertyNames(), entityDescriptor.getPropertyJavaTypeDescriptors());
    }

    private <T> boolean copyState(Object entity, EntityTypeDescriptor<T> entityDescriptor, Object[] state, SessionFactoryImplementor sf) {
        List persistentAttributes = entityDescriptor.getPersistentAttributes();
        Object[] newState = entityDescriptor.getPropertyValues(entity);
        int size = newState.length;
        boolean isDirty = false;
        for (int index = 0; index < size; ++index) {
            if ((state[index] != LazyPropertyInitializer.UNFETCHED_PROPERTY || newState[index] == LazyPropertyInitializer.UNFETCHED_PROPERTY) && (state[index] == newState[index] || ((NonIdPersistentAttribute)persistentAttributes.get(index)).getJavaTypeDescriptor().areEqual(state[index], newState[index]))) continue;
            isDirty = true;
            state[index] = newState[index];
        }
        return isDirty;
    }

    private Object getNextVersion(FlushEntityEvent event) throws HibernateException {
        EntityEntry entry = event.getEntityEntry();
        EntityTypeDescriptor entityDescriptor = entry.getDescriptor();
        VersionDescriptor versionDescriptor = entityDescriptor.getHierarchy().getVersionDescriptor();
        if (versionDescriptor != null) {
            VersionSupport versionSupport = entityDescriptor.getHierarchy().getVersionDescriptor().getVersionSupport();
            Object[] values = event.getPropertyValues();
            if (entry.isBeingReplicated()) {
                return Versioning.getVersion(values, entityDescriptor);
            }
            int[] dirtyProperties = event.getDirtyProperties();
            boolean isVersionIncrementRequired = this.isVersionIncrementRequired(event, entry, entityDescriptor, dirtyProperties);
            Object nextVersion = isVersionIncrementRequired ? Versioning.increment(entry.getVersion(), versionSupport, event.getSession()) : entry.getVersion();
            Versioning.setVersion(values, nextVersion, entityDescriptor);
            return nextVersion;
        }
        return null;
    }

    private boolean isVersionIncrementRequired(FlushEntityEvent event, EntityEntry entry, EntityTypeDescriptor entityDescriptor, int[] dirtyProperties) {
        boolean isVersionIncrementRequired = entry.getStatus() != Status.DELETED && (dirtyProperties == null || Versioning.isVersionIncrementRequired(dirtyProperties, event.hasDirtyCollection(), entityDescriptor.getPropertyVersionability()));
        return isVersionIncrementRequired;
    }

    protected final boolean isUpdateNecessary(FlushEntityEvent event) throws HibernateException {
        EntityTypeDescriptor entityDescriptor = event.getEntityEntry().getDescriptor();
        Status status = event.getEntityEntry().getStatus();
        if (!event.isDirtyCheckPossible()) {
            return true;
        }
        int[] dirtyProperties = event.getDirtyProperties();
        if (dirtyProperties != null && dirtyProperties.length != 0) {
            return true;
        }
        return this.hasDirtyCollections(event, entityDescriptor, status);
    }

    private boolean hasDirtyCollections(FlushEntityEvent event, EntityTypeDescriptor entityDescriptor, Status status) {
        if (this.isCollectionDirtyCheckNecessary(entityDescriptor, status)) {
            DirtyCollectionSearchVisitor visitor = new DirtyCollectionSearchVisitor(event.getSession(), entityDescriptor.getPropertyVersionability());
            visitor.processEntityPropertyValues(event.getPropertyValues(), entityDescriptor.getPersistentAttributes());
            boolean hasDirtyCollections = visitor.wasDirtyCollectionFound();
            event.setHasDirtyCollection(hasDirtyCollections);
            return hasDirtyCollections;
        }
        return false;
    }

    private boolean isCollectionDirtyCheckNecessary(EntityTypeDescriptor descriptor, Status status) {
        if (status != Status.MANAGED && status != Status.READ_ONLY) {
            return false;
        }
        if (descriptor.getHierarchy().getVersionDescriptor() == null) {
            return false;
        }
        return descriptor.hasCollections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dirtyCheck(final FlushEntityEvent event) throws HibernateException {
        boolean interceptorHandledDirtyCheck;
        boolean dirtyCheckPossible;
        int[] dirtyProperties;
        Object id;
        EntityTypeDescriptor entityDescriptor;
        block13: {
            block12: {
                EventSource session;
                block11: {
                    Object entity = event.getEntity();
                    Object[] values = event.getPropertyValues();
                    session = event.getSession();
                    EntityEntry entry = event.getEntityEntry();
                    entityDescriptor = entry.getDescriptor();
                    id = entry.getId();
                    Object[] loadedState = entry.getLoadedState();
                    dirtyProperties = session.getInterceptor().findDirty(entity, id, values, loadedState, entityDescriptor.getPropertyNames(), entityDescriptor.getPropertyJavaTypeDescriptors());
                    if (dirtyProperties == null) {
                        if (entity instanceof SelfDirtinessTracker) {
                            if (((SelfDirtinessTracker)entity).$$_hibernate_hasDirtyAttributes()) {
                                int[] dirty = entityDescriptor.resolveAttributeIndexes(((SelfDirtinessTracker)entity).$$_hibernate_getDirtyAttributes());
                                int count = 0;
                                for (int i : dirty) {
                                    if (!entityDescriptor.getPropertyUpdateability()[i]) continue;
                                    dirty[count++] = i;
                                }
                                dirtyProperties = count == 0 ? ArrayHelper.EMPTY_INT_ARRAY : (count == dirty.length ? dirty : Arrays.copyOf(dirty, count));
                            } else {
                                dirtyProperties = ArrayHelper.EMPTY_INT_ARRAY;
                            }
                        } else {
                            class DirtyCheckContextImpl
                            implements CustomEntityDirtinessStrategy.DirtyCheckContext {
                                private int[] found;

                                DirtyCheckContextImpl() {
                                }

                                @Override
                                public void doDirtyChecking(CustomEntityDirtinessStrategy.AttributeChecker attributeChecker) {
                                    this.found = new DirtyCheckAttributeInfoImpl(event).visitAttributes(attributeChecker);
                                    if (this.found != null && this.found.length == 0) {
                                        this.found = null;
                                    }
                                }
                            }
                            DirtyCheckContextImpl context = new DirtyCheckContextImpl();
                            session.getFactory().getCustomEntityDirtinessStrategy().findDirty(entity, entityDescriptor, session, context);
                            dirtyProperties = context.found;
                        }
                    }
                    event.setDatabaseSnapshot(null);
                    dirtyCheckPossible = true;
                    if (dirtyProperties != null) break block12;
                    try {
                        session.getEventListenerManager().dirtyCalculationStart();
                        interceptorHandledDirtyCheck = false;
                        boolean bl = dirtyCheckPossible = loadedState != null;
                        if (dirtyCheckPossible) {
                            dirtyProperties = entityDescriptor.findDirty(values, loadedState, entity, session);
                            break block11;
                        }
                        if (entry.getStatus() == Status.DELETED && !event.getEntityEntry().isModifiableEntity()) {
                            if (values != entry.getDeletedState()) {
                                throw new IllegalStateException("Entity has status Status.DELETED but values != entry.getDeletedState");
                            }
                            Object[] currentState = entityDescriptor.getPropertyValues(event.getEntity());
                            dirtyProperties = entityDescriptor.findDirty(entry.getDeletedState(), currentState, entity, session);
                            dirtyCheckPossible = true;
                            break block11;
                        }
                        Object[] databaseSnapshot = this.getDatabaseSnapshot(session, entityDescriptor, id);
                        if (databaseSnapshot == null) break block11;
                        dirtyProperties = entityDescriptor.findModified(databaseSnapshot, values, entity, session);
                        dirtyCheckPossible = true;
                        event.setDatabaseSnapshot(databaseSnapshot);
                    }
                    catch (Throwable throwable) {
                        session.getEventListenerManager().dirtyCalculationEnd(dirtyProperties != null);
                        throw throwable;
                    }
                }
                session.getEventListenerManager().dirtyCalculationEnd(dirtyProperties != null);
                break block13;
            }
            interceptorHandledDirtyCheck = true;
        }
        this.logDirtyProperties(id, dirtyProperties, entityDescriptor);
        event.setDirtyProperties(dirtyProperties);
        event.setDirtyCheckHandledByInterceptor(interceptorHandledDirtyCheck);
        event.setDirtyCheckPossible(dirtyCheckPossible);
    }

    private void logDirtyProperties(Object id, int[] dirtyProperties, EntityTypeDescriptor entityDescriptor) {
        if (dirtyProperties != null && dirtyProperties.length > 0 && LOG.isTraceEnabled()) {
            List attributes = entityDescriptor.getPersistentAttributes();
            Object[] dirtyPropertyNames = new String[dirtyProperties.length];
            for (int i = 0; i < dirtyProperties.length && i < attributes.size(); ++i) {
                dirtyPropertyNames[i] = ((NonIdPersistentAttribute)attributes.get(dirtyProperties[i])).getAttributeName();
            }
            LOG.tracev("Found dirty properties [{0}] : {1}", MessageHelper.infoString(entityDescriptor.getEntityName(), id), Arrays.toString(dirtyPropertyNames));
        }
    }

    private Object[] getDatabaseSnapshot(SessionImplementor session, EntityTypeDescriptor entityDescriptor, Object id) {
        if (entityDescriptor.isSelectBeforeUpdateRequired()) {
            Object[] snapshot = session.getPersistenceContext().getDatabaseSnapshot(id, entityDescriptor);
            if (snapshot == null) {
                if (session.getFactory().getStatistics().isStatisticsEnabled()) {
                    session.getFactory().getStatistics().optimisticFailure(entityDescriptor.getEntityName());
                }
                throw new StaleObjectStateException(entityDescriptor.getEntityName(), id);
            }
            return snapshot;
        }
        EntityKey entityKey = session.generateEntityKey(id, entityDescriptor);
        return session.getPersistenceContext().getCachedDatabaseSnapshot(entityKey);
    }

    private class DirtyCheckAttributeInfoImpl<T>
    implements CustomEntityDirtinessStrategy.AttributeInformation {
        private final FlushEntityEvent event;
        private final EntityTypeDescriptor<T> descriptor;
        private final int numberOfAttributes;
        private int index;
        Object[] databaseSnapshot;

        private DirtyCheckAttributeInfoImpl(FlushEntityEvent event) {
            this.event = event;
            this.descriptor = event.getEntityEntry().getDescriptor();
            this.numberOfAttributes = this.descriptor.getPersistentAttributes().size();
        }

        @Override
        public EntityTypeDescriptor getContainingDescriptor() {
            return this.descriptor;
        }

        @Override
        public int getAttributeIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return ((NonIdPersistentAttribute)this.descriptor.getPersistentAttributes().get(this.index)).getAttributeName();
        }

        @Override
        public Object getCurrentValue() {
            return this.event.getPropertyValues()[this.index];
        }

        @Override
        public Object getLoadedValue() {
            if (this.databaseSnapshot == null) {
                this.databaseSnapshot = DefaultFlushEntityEventListener.this.getDatabaseSnapshot(this.event.getSession(), this.descriptor, this.event.getEntityEntry().getId());
            }
            return this.databaseSnapshot[this.index];
        }

        public int[] visitAttributes(CustomEntityDirtinessStrategy.AttributeChecker attributeChecker) {
            this.databaseSnapshot = null;
            this.index = 0;
            int[] indexes = new int[this.numberOfAttributes];
            int count = 0;
            while (this.index < this.numberOfAttributes) {
                if (attributeChecker.isDirty(this)) {
                    indexes[count++] = this.index;
                }
                ++this.index;
            }
            return Arrays.copyOf(indexes, count);
        }
    }
}

