/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.entry.CollectionCacheEntry;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.InitializeCollectionEvent;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.pretty.MessageHelper;

public class DefaultInitializeCollectionEventListener
implements InitializeCollectionEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultInitializeCollectionEventListener.class);

    @Override
    public void onInitializeCollection(InitializeCollectionEvent event) throws HibernateException {
        PersistentCollection collection = event.getCollection();
        EventSource source = event.getSession();
        CollectionEntry ce = source.getPersistenceContext().getCollectionEntry(collection);
        if (ce == null) {
            throw new HibernateException("collection was evicted");
        }
        if (!collection.wasInitialized()) {
            boolean foundInCache;
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Initializing collection {0}", MessageHelper.collectionInfoString(ce.getLoadedCollectionDescriptor(), collection, ce.getLoadedKey(), (SharedSessionContractImplementor)source));
                LOG.trace("Checking second-level cache");
            }
            if (foundInCache = this.initializeCollectionFromCache(ce.getLoadedKey(), ce.getLoadedCollectionDescriptor(), collection, source)) {
                if (traceEnabled) {
                    LOG.trace("Collection initialized from cache");
                }
            } else {
                if (traceEnabled) {
                    LOG.trace("Collection not cached");
                }
                ce.getLoadedCollectionDescriptor().initialize(ce.getLoadedKey(), source);
                if (traceEnabled) {
                    LOG.trace("Collection initialized");
                }
                if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                    source.getFactory().getStatistics().fetchCollection(ce.getLoadedCollectionDescriptor().getNavigableRole().getFullPath());
                }
            }
        }
    }

    private boolean initializeCollectionFromCache(Object collectionKey, PersistentCollectionDescriptor collectionDescriptor, PersistentCollection collection, SessionImplementor source) {
        boolean useCache;
        if (!source.getLoadQueryInfluencers().getEnabledFilters().isEmpty() && collectionDescriptor.isAffectedByEnabledFilters(source)) {
            LOG.trace("Disregarding cached version (if any) of collection due to enabled filters");
            return false;
        }
        if (!source.getCacheMode().isGetEnabled()) {
            return false;
        }
        boolean bl = useCache = collectionDescriptor.hasCache() && source.getCacheMode().isGetEnabled();
        if (!useCache) {
            return false;
        }
        CollectionDataAccess cacheAccess = collectionDescriptor.getCacheAccess();
        if (cacheAccess == null) {
            return false;
        }
        SessionFactoryImplementor factory = source.getFactory();
        Object ck = cacheAccess.generateCacheKey(collectionKey, collectionDescriptor, factory, source.getTenantIdentifier());
        Serializable ce = CacheHelper.fromSharedCache(source, ck, cacheAccess);
        if (factory.getStatistics().isStatisticsEnabled()) {
            if (ce == null) {
                factory.getStatistics().collectionCacheMiss(collectionDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
            } else {
                factory.getStatistics().collectionCacheHit(collectionDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
            }
        }
        if (ce == null) {
            return false;
        }
        CollectionCacheEntry cacheEntry = (CollectionCacheEntry)collectionDescriptor.getCacheEntryStructure().destructure(ce, factory);
        PersistenceContext persistenceContext = source.getPersistenceContext();
        cacheEntry.assemble(collection, collectionDescriptor, persistenceContext.getCollectionOwner(collectionKey, collectionDescriptor));
        persistenceContext.getCollectionEntry(collection).postInitialize(collection);
        return true;
    }
}

