/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.PersistentObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.entity.CacheEntityLoaderHelper;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifierComposite;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifierCompositeNonAggregated;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class DefaultLoadEventListener
implements LoadEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultLoadEventListener.class);
    private static final boolean traceEnabled = LOG.isTraceEnabled();

    @Override
    public void onLoad(LoadEvent event, LoadEventListener.LoadType loadType) {
        EntityTypeDescriptor entityDescriptor = this.getDescriptor(event);
        if (entityDescriptor == null) {
            throw new HibernateException("Unable to locate entityDescriptor: " + event.getEntityClassName());
        }
        Class idClass = entityDescriptor.getHierarchy().getIdentifierDescriptor().getJavaType();
        if (idClass != null && !idClass.isInstance(event.getEntityId()) && !DelayedPostInsertIdentifier.class.isInstance(event.getEntityId())) {
            this.checkIdClass(entityDescriptor, event, loadType, idClass);
        }
        this.doOnLoad(entityDescriptor, event, loadType);
    }

    protected EntityTypeDescriptor getDescriptor(LoadEvent event) {
        if (event.getInstanceToLoad() != null) {
            event.setEntityClassName(event.getInstanceToLoad().getClass().getName());
            return event.getSession().getEntityDescriptor(null, event.getInstanceToLoad());
        }
        return event.getSession().getFactory().getMetamodel().getEntityDescriptor(event.getEntityClassName());
    }

    private void doOnLoad(EntityTypeDescriptor entityDescriptor, LoadEvent event, LoadEventListener.LoadType loadType) {
        try {
            EntityKey keyToLoad = event.getSession().generateEntityKey(event.getEntityId(), entityDescriptor);
            if (loadType.isNakedEntityReturned()) {
                event.setResult(this.load(event, entityDescriptor, keyToLoad, loadType));
            } else if (event.getLockMode() == LockMode.NONE) {
                event.setResult(this.proxyOrLoad(event, entityDescriptor, keyToLoad, loadType));
            } else {
                event.setResult(this.lockAndLoad(event, entityDescriptor, keyToLoad, loadType, event.getSession()));
            }
        }
        catch (HibernateException e) {
            LOG.unableToLoadCommand(e);
            throw e;
        }
    }

    private void checkIdClass(EntityTypeDescriptor entityDescriptor, LoadEvent event, LoadEventListener.LoadType loadType, Class idClass) {
        PersistentAttributeDescriptor attribute;
        EntityIdentifierCompositeNonAggregated dependantIdDescriptor;
        Set attributes;
        if (entityDescriptor.getHierarchy().getIdentifierDescriptor() instanceof EntityIdentifierCompositeNonAggregated && (attributes = (dependantIdDescriptor = (EntityIdentifierCompositeNonAggregated)entityDescriptor.getHierarchy().getIdentifierDescriptor()).getEmbeddedDescriptor().getAttributes()).size() == 1 && (attribute = (PersistentAttributeDescriptor)attributes.iterator().next()) instanceof EntityValuedNavigable && attribute.getJavaTypeDescriptor().getJavaType().isInstance(event.getEntityId())) {
            this.loadByDerivedIdentitySimplePkValue(event, loadType, entityDescriptor, dependantIdDescriptor, ((EntityValuedNavigable)((Object)attribute)).getEntityDescriptor());
            return;
        }
        throw new TypeMismatchException("Provided id of the wrong type for class " + entityDescriptor.getEntityName() + ". Expected: " + idClass + ", got " + event.getEntityId().getClass());
    }

    private void loadByDerivedIdentitySimplePkValue(LoadEvent event, LoadEventListener.LoadType options, EntityTypeDescriptor dependentDescriptor, EntityIdentifierComposite dependentIdType, EntityTypeDescriptor parentDescriptor) {
        throw new NotYetImplementedFor6Exception();
    }

    private Object load(LoadEvent event, EntityTypeDescriptor entityDescriptor, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        boolean isOptionalInstance;
        if (event.getInstanceToLoad() != null) {
            if (event.getSession().getPersistenceContext().getEntry(event.getInstanceToLoad()) != null) {
                throw new PersistentObjectException("attempted to load into an instance that was already associated with the session: " + MessageHelper.infoString(entityDescriptor, event.getEntityId(), event.getSession().getFactory()));
            }
            entityDescriptor.getHierarchy().getIdentifierDescriptor().injectIdentifier(event.getInstanceToLoad(), event.getEntityId(), event.getSession());
        }
        Object entity = this.doLoad(event, entityDescriptor, keyToLoad, options);
        boolean bl = isOptionalInstance = event.getInstanceToLoad() != null;
        if (entity == null && (!options.isAllowNulls() || isOptionalInstance)) {
            event.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(event.getEntityClassName(), event.getEntityId());
        } else if (isOptionalInstance && entity != event.getInstanceToLoad()) {
            throw new NonUniqueObjectException(event.getEntityId(), event.getEntityClassName());
        }
        return entity;
    }

    private Object proxyOrLoad(LoadEvent event, EntityTypeDescriptor entityDescriptor, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        if (traceEnabled) {
            LOG.tracev("Loading entity: {0}", MessageHelper.infoString(entityDescriptor, event.getEntityId(), event.getSession().getFactory()));
        }
        if (!entityDescriptor.hasProxy()) {
            return this.load(event, entityDescriptor, keyToLoad, options);
        }
        PersistenceContext persistenceContext = event.getSession().getPersistenceContext();
        Object proxy = persistenceContext.getProxy(keyToLoad);
        if (proxy != null) {
            return this.returnNarrowedProxy(event, entityDescriptor, keyToLoad, options, persistenceContext, proxy);
        }
        if (options.isAllowProxyCreation()) {
            return this.createProxyIfNecessary(event, entityDescriptor, keyToLoad, options, persistenceContext);
        }
        return this.load(event, entityDescriptor, keyToLoad, options);
    }

    private Object returnNarrowedProxy(LoadEvent event, EntityTypeDescriptor entityDescriptor, EntityKey keyToLoad, LoadEventListener.LoadType options, PersistenceContext persistenceContext, Object proxy) {
        LazyInitializer li;
        if (traceEnabled) {
            LOG.trace("Entity proxy found in session cache");
        }
        if ((li = ((HibernateProxy)proxy).getHibernateLazyInitializer()).isUnwrap()) {
            return li.getImplementation();
        }
        Object impl = null;
        if (!options.isAllowProxyCreation() && (impl = this.load(event, entityDescriptor, keyToLoad, options)) == null) {
            event.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(entityDescriptor.getEntityName(), keyToLoad.getIdentifier());
        }
        return persistenceContext.narrowProxy(proxy, entityDescriptor, keyToLoad, impl);
    }

    private Object createProxyIfNecessary(LoadEvent event, EntityTypeDescriptor entityDescriptor, EntityKey keyToLoad, LoadEventListener.LoadType options, PersistenceContext persistenceContext) {
        Object existing = persistenceContext.getEntity(keyToLoad);
        if (existing != null) {
            EntityEntry entry;
            Status status;
            if (traceEnabled) {
                LOG.trace("Entity found in session cache");
            }
            if (options.isCheckDeleted() && ((status = (entry = persistenceContext.getEntry(existing)).getStatus()) == Status.DELETED || status == Status.GONE)) {
                return null;
            }
            return existing;
        }
        if (traceEnabled) {
            LOG.trace("Creating new proxy for entity");
        }
        Object proxy = entityDescriptor.createProxy(event.getEntityId(), event.getSession());
        persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(keyToLoad);
        persistenceContext.addProxy(keyToLoad, proxy);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object lockAndLoad(LoadEvent event, EntityTypeDescriptor entityDescriptor, EntityKey keyToLoad, LoadEventListener.LoadType options, SessionImplementor source) {
        Object entity;
        Object ck;
        SoftLock lock = null;
        EntityDataAccess cacheAccess = entityDescriptor.getHierarchy().getEntityCacheAccess();
        if (entityDescriptor.canWriteToCache()) {
            ck = cacheAccess.generateCacheKey(event.getEntityId(), entityDescriptor.getHierarchy(), source.getFactory(), source.getTenantIdentifier());
            lock = cacheAccess.lockItem(source, ck, null);
        } else {
            ck = null;
        }
        try {
            entity = this.load(event, entityDescriptor, keyToLoad, options);
            if (!entityDescriptor.canWriteToCache()) return event.getSession().getPersistenceContext().proxyFor(entityDescriptor, keyToLoad, entity);
        }
        catch (Throwable throwable) {
            if (!entityDescriptor.canWriteToCache()) throw throwable;
            cacheAccess.unlockItem(source, ck, lock);
            throw throwable;
        }
        cacheAccess.unlockItem(source, ck, lock);
        return event.getSession().getPersistenceContext().proxyFor(entityDescriptor, keyToLoad, entity);
    }

    private Object doLoad(LoadEvent event, EntityTypeDescriptor entityDescriptor, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry;
        Object entity;
        if (traceEnabled) {
            LOG.tracev("Attempting to resolve: {0}", MessageHelper.infoString(entityDescriptor, event.getEntityId(), event.getSession().getFactory()));
        }
        if ((entity = (persistenceContextEntry = CacheEntityLoaderHelper.INSTANCE.loadFromSessionCache(event, keyToLoad, options)).getEntity()) != null) {
            return persistenceContextEntry.isManaged() ? entity : null;
        }
        entity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(event, entityDescriptor, keyToLoad);
        if (entity != null) {
            if (traceEnabled) {
                LOG.tracev("Resolved object in second-level cache: {0}", MessageHelper.infoString(entityDescriptor, event.getEntityId(), event.getSession().getFactory()));
            }
        } else {
            if (traceEnabled) {
                LOG.tracev("Object not resolved in any cache: {0}", MessageHelper.infoString(entityDescriptor, event.getEntityId(), event.getSession().getFactory()));
            }
            entity = this.loadFromDatasource(event, entityDescriptor);
        }
        if (entity != null && entityDescriptor.getHierarchy().getNaturalIdDescriptor() != null) {
            event.getSession().getPersistenceContext().getNaturalIdHelper().cacheNaturalIdCrossReferenceFromLoad(entityDescriptor, event.getEntityId(), event.getSession().getPersistenceContext().getNaturalIdHelper().extractNaturalIdValues(entity, entityDescriptor));
        }
        return entity;
    }

    protected Object loadFromDatasource(LoadEvent event, EntityTypeDescriptor entityDescriptor) {
        Object entity = entityDescriptor.getSingleIdLoader().load(event.getEntityId(), event.getLockOptions(), event.getSession());
        if (event.isAssociationFetch() && event.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            event.getSession().getFactory().getStatistics().fetchEntity(event.getEntityClassName());
        }
        return entity;
    }
}

