/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.internal.MergeContext;
import org.hibernate.event.spi.EntityCopyObserver;
import org.hibernate.event.spi.EntityCopyObserverFactory;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifierSimple;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.internal.TypeHelper;

public class DefaultMergeEventListener
extends AbstractSaveEventListener
implements MergeEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultMergeEventListener.class);

    @Override
    protected Map getMergeMap(Object anything) {
        return ((MergeContext)anything).invertMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMerge(MergeEvent event) throws HibernateException {
        EntityCopyObserver entityCopyObserver = this.createEntityCopyObserver(event.getSession().getFactory());
        MergeContext mergeContext = new MergeContext(event.getSession(), entityCopyObserver);
        try {
            this.onMerge(event, mergeContext);
            entityCopyObserver.topLevelMergeComplete(event.getSession());
        }
        finally {
            entityCopyObserver.clear();
            mergeContext.clear();
        }
    }

    private EntityCopyObserver createEntityCopyObserver(SessionFactoryImplementor sessionFactory) {
        ServiceRegistryImplementor serviceRegistry = sessionFactory.getServiceRegistry();
        EntityCopyObserverFactory configurationService = serviceRegistry.getService(EntityCopyObserverFactory.class);
        return configurationService.createEntityCopyObserver();
    }

    @Override
    public void onMerge(MergeEvent event, Map copiedAlready) throws HibernateException {
        MergeContext copyCache = (MergeContext)copiedAlready;
        EventSource source = event.getSession();
        Object original = event.getOriginal();
        if (original != null) {
            Object entity;
            if (original instanceof HibernateProxy) {
                LazyInitializer li = ((HibernateProxy)original).getHibernateLazyInitializer();
                if (li.isUninitialized()) {
                    LOG.trace("Ignoring uninitialized proxy");
                    event.setResult(source.load(li.getEntityName(), li.getIdentifier()));
                    return;
                }
                entity = li.getImplementation();
            } else {
                entity = original;
            }
            if (copyCache.containsKey(entity) && copyCache.isOperatedOn(entity)) {
                LOG.trace("Already in merge process");
                event.setResult(entity);
            } else {
                EntityTypeDescriptor entityDescriptor;
                Object id;
                if (copyCache.containsKey(entity)) {
                    LOG.trace("Already in copyCache; setting in merge process");
                    copyCache.setOperatedOn(entity, true);
                }
                event.setEntity(entity);
                Enum entityState = null;
                EntityEntry entry = source.getPersistenceContext().getEntry(entity);
                if (entry == null && (id = (entityDescriptor = source.getEntityDescriptor(event.getEntityName(), entity)).getIdentifier(entity)) != null) {
                    EntityKey key = source.generateEntityKey(id, entityDescriptor);
                    Object managedEntity = source.getPersistenceContext().getEntity(key);
                    entry = source.getPersistenceContext().getEntry(managedEntity);
                    if (entry != null) {
                        entityState = AbstractSaveEventListener.EntityState.DETACHED;
                    }
                }
                if (entityState == null) {
                    entityState = this.getEntityState(entity, event.getEntityName(), entry, source);
                }
                switch (1.$SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState[entityState.ordinal()]) {
                    case 1: {
                        this.entityIsDetached(event, copyCache);
                        break;
                    }
                    case 2: {
                        this.entityIsTransient(event, copyCache);
                        break;
                    }
                    case 3: {
                        this.entityIsPersistent(event, copyCache);
                        break;
                    }
                    default: {
                        throw new ObjectDeletedException("deleted instance passed to merge", null, this.getLoggableName(event.getEntityName(), entity));
                    }
                }
            }
        }
    }

    protected void entityIsPersistent(MergeEvent event, Map copyCache) {
        LOG.trace("Ignoring persistent instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityTypeDescriptor entityDescriptor = source.getEntityDescriptor(event.getEntityName(), entity);
        ((MergeContext)copyCache).put(entity, entity, true);
        this.cascadeOnMerge(source, entityDescriptor, entity, copyCache);
        this.copyValues(entityDescriptor, entity, entity, source, copyCache);
        event.setResult(entity);
    }

    protected void entityIsTransient(MergeEvent event, Map copyCache) {
        Object id;
        LOG.trace("Merging transient instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        String entityName = event.getEntityName();
        EntityTypeDescriptor entityDescriptor = source.getEntityDescriptor(entityName, entity);
        Object object = id = EntityIdentifierSimple.class.isInstance(entityDescriptor.getHierarchy().getIdentifierDescriptor()) ? entityDescriptor.getIdentifier(entity) : null;
        if (copyCache.containsKey(entity)) {
            entityDescriptor.setIdentifier(copyCache.get(entity), id, source);
        } else {
            ((MergeContext)copyCache).put(entity, source.instantiate(entityDescriptor, id), true);
        }
        Object copy = copyCache.get(entity);
        super.cascadeBeforeSave(source, entityDescriptor, entity, copyCache);
        this.copyValues(entityDescriptor, entity, copy, source, copyCache, ForeignKeyDirection.FROM_PARENT);
        this.saveTransientEntity(copy, entityName, event.getRequestedId(), source, copyCache);
        super.cascadeAfterSave(source, entityDescriptor, entity, copyCache);
        this.copyValues(entityDescriptor, entity, copy, source, copyCache, ForeignKeyDirection.TO_PARENT);
        event.setResult(copy);
    }

    private void saveTransientEntity(Object entity, String entityName, Serializable requestedId, EventSource source, Map copyCache) {
        if (requestedId == null) {
            this.saveWithGeneratedId(entity, entityName, copyCache, source, false);
        } else {
            this.saveWithRequestedId(entity, requestedId, entityName, copyCache, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void entityIsDetached(MergeEvent event, Map copyCache) {
        Object result;
        LOG.trace("Merging detached instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityTypeDescriptor entityDescriptor = source.getEntityDescriptor(event.getEntityName(), entity);
        String entityName = entityDescriptor.getEntityName();
        Object id = event.getRequestedId();
        if (id == null) {
            id = entityDescriptor.getIdentifier(entity);
        } else {
            Object entityId = entityDescriptor.getIdentifier(entity);
            if (!entityDescriptor.getHierarchy().getIdentifierDescriptor().getJavaTypeDescriptor().areEqual(id, entityId)) {
                throw new HibernateException("merge requested with id not matching id of passed entity");
            }
        }
        LoadQueryInfluencers.InternalFetchProfileType previouslyEnabledInternalFetchProfileType = source.getLoadQueryInfluencers().getEnabledInternalFetchProfileType();
        try {
            source.getLoadQueryInfluencers().setEnabledInternalFetchProfileType(LoadQueryInfluencers.InternalFetchProfileType.MERGE);
            Serializable clonedIdentifier = (Serializable)entityDescriptor.getIdentifierDescriptor().getJavaTypeDescriptor().getMutabilityPlan().deepCopy(id);
            result = source.get(entityName, clonedIdentifier);
        }
        finally {
            source.getLoadQueryInfluencers().setEnabledInternalFetchProfileType(previouslyEnabledInternalFetchProfileType);
        }
        if (result == null) {
            this.entityIsTransient(event, copyCache);
        } else {
            ((MergeContext)copyCache).put(entity, result, true);
            Object target = source.getPersistenceContext().unproxy(result);
            if (target == entity) {
                throw new AssertionFailure("entity was not detached");
            }
            if (!source.getEntityName(target).equals(entityName)) {
                throw new WrongClassException("class of the given object did not match class of persistent copy", event.getRequestedId(), entityName);
            }
            if (this.isVersionChanged(entity, source, entityDescriptor, target)) {
                if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                    source.getFactory().getStatistics().optimisticFailure(entityName);
                }
                throw new StaleObjectStateException(entityName, id);
            }
            this.cascadeOnMerge(source, entityDescriptor, entity, copyCache);
            this.copyValues(entityDescriptor, entity, target, source, copyCache);
            this.markInterceptorDirty(entity, target, entityDescriptor);
            event.setResult(result);
        }
    }

    private void markInterceptorDirty(Object entity, Object target, EntityTypeDescriptor entityDescriptor) {
        if (entity instanceof SelfDirtinessTracker && target instanceof SelfDirtinessTracker) {
            ((SelfDirtinessTracker)target).$$_hibernate_clearDirtyAttributes();
            for (String fieldName : ((SelfDirtinessTracker)entity).$$_hibernate_getDirtyAttributes()) {
                ((SelfDirtinessTracker)target).$$_hibernate_trackChange(fieldName);
            }
        }
    }

    private boolean isVersionChanged(Object entity, EventSource source, EntityTypeDescriptor entityDescriptor, Object target) {
        if (entityDescriptor.getHierarchy().getVersionDescriptor() == null) {
            return false;
        }
        boolean changed = !Objects.equals(entityDescriptor.getVersion(target), entityDescriptor.getVersion(entity));
        return changed && this.existsInDatabase(target, source, entityDescriptor);
    }

    private boolean existsInDatabase(Object entity, EventSource source, EntityTypeDescriptor entityDescriptor) {
        Object id;
        EntityEntry entry = source.getPersistenceContext().getEntry(entity);
        if (entry == null && (id = entityDescriptor.getIdentifier(entity)) != null) {
            EntityKey key = source.generateEntityKey(id, entityDescriptor);
            Object managedEntity = source.getPersistenceContext().getEntity(key);
            entry = source.getPersistenceContext().getEntry(managedEntity);
        }
        return entry != null && entry.isExistsInDatabase();
    }

    protected void copyValues(EntityTypeDescriptor entityDescriptor, Object entity, Object target, SessionImplementor source, Map copyCache) {
        Object[] copiedValues = TypeHelper.replace(entityDescriptor, entity, target, copyCache, target, source);
        entityDescriptor.setPropertyValues(target, copiedValues);
    }

    protected void copyValues(EntityTypeDescriptor entityDescriptor, Object entity, Object target, SessionImplementor source, Map copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copiedValues = foreignKeyDirection == ForeignKeyDirection.TO_PARENT ? TypeHelper.replaceAssociations(entityDescriptor, entity, target, copyCache, target, foreignKeyDirection, source) : TypeHelper.replace(entityDescriptor, entity, target, copyCache, target, foreignKeyDirection, source);
        entityDescriptor.setPropertyValues(target, copiedValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeOnMerge(EventSource source, EntityTypeDescriptor entityDescriptor, Object entity, Map copyCache) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.BEFORE_MERGE, source, entityDescriptor, entity, copyCache);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    @Override
    protected CascadingAction getCascadeAction() {
        return CascadingActions.MERGE;
    }

    @Override
    protected Boolean getAssumedUnsaved() {
        return Boolean.FALSE;
    }

    @Override
    protected void cascadeAfterSave(EventSource source, EntityTypeDescriptor descriptor, Object entity, Object anything) throws HibernateException {
    }

    @Override
    protected void cascadeBeforeSave(EventSource source, EntityTypeDescriptor descriptor, Object entity, Object anything) throws HibernateException {
    }
}

