/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PersistentObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.event.internal.EvictVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.EmbeddedValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.pretty.MessageHelper;

public class DefaultRefreshEventListener
implements RefreshEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultRefreshEventListener.class);

    @Override
    public void onRefresh(RefreshEvent event) throws HibernateException {
        this.onRefresh(event, new IdentityHashMap(10));
    }

    @Override
    public void onRefresh(RefreshEvent event, Map refreshedAlready) {
        Object result;
        LockMode currentLockMode;
        EntityKey key;
        Object id;
        EntityTypeDescriptor entityDescriptor;
        boolean isTransient;
        EventSource source = event.getSession();
        if (event.getEntityName() != null) {
            isTransient = !source.contains(event.getEntityName(), event.getObject());
        } else {
            boolean bl = isTransient = !source.contains(event.getObject());
        }
        if (source.getPersistenceContext().reassociateIfUninitializedProxy(event.getObject())) {
            if (isTransient) {
                source.setReadOnly(event.getObject(), source.isDefaultReadOnly());
            }
            return;
        }
        Object object = source.getPersistenceContext().unproxyAndReassociate(event.getObject());
        if (refreshedAlready.containsKey(object)) {
            LOG.trace("Already refreshed");
            return;
        }
        EntityEntry e = source.getPersistenceContext().getEntry(object);
        if (e == null) {
            entityDescriptor = source.getEntityDescriptor(event.getEntityName(), object);
            id = entityDescriptor.getIdentifier(object);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Refreshing transient {0}", MessageHelper.infoString(entityDescriptor, id, source.getFactory()));
            }
            key = source.generateEntityKey(id, entityDescriptor);
            if (source.getPersistenceContext().getEntry(key) != null) {
                throw new PersistentObjectException("attempted to refresh transient instance when persistent instance was already associated with the Session: " + MessageHelper.infoString(entityDescriptor, id, source.getFactory()));
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Refreshing ", MessageHelper.infoString(e.getDescriptor(), e.getId(), source.getFactory()));
            }
            if (!e.isExistsInDatabase()) {
                throw new UnresolvableObjectException(e.getId(), "this instance does not yet exist as a row in the database");
            }
            entityDescriptor = e.getDescriptor();
            id = e.getId();
        }
        refreshedAlready.put(object, object);
        Cascade.cascade(CascadingActions.REFRESH, CascadePoint.BEFORE_REFRESH, source, entityDescriptor, object, refreshedAlready);
        if (e != null) {
            key = source.generateEntityKey(id, entityDescriptor);
            source.getPersistenceContext().removeEntity(key);
            if (entityDescriptor.getHierarchy().getMutabilityPlan().isMutable()) {
                new EvictVisitor(source, object).process(object, entityDescriptor);
            }
        }
        if (entityDescriptor.canWriteToCache()) {
            Object previousVersion = null;
            if (entityDescriptor.isVersionPropertyGenerated()) {
                previousVersion = entityDescriptor.getVersion(object);
            }
            EntityDataAccess cacheAccess = entityDescriptor.getHierarchy().getEntityCacheAccess();
            Object ck = cacheAccess.generateCacheKey(id, entityDescriptor.getHierarchy(), source.getFactory(), source.getTenantIdentifier());
            SoftLock lock = cacheAccess.lockItem(source, ck, previousVersion);
            source.getActionQueue().registerProcess((success, session) -> cacheAccess.unlockItem(session, ck, lock));
            cacheAccess.remove(source, ck);
        }
        this.evictCachedCollections(entityDescriptor, id, source);
        LoadQueryInfluencers.InternalFetchProfileType previouslyEnabledInternalFetchProfileType = source.getLoadQueryInfluencers().getEnabledInternalFetchProfileType();
        source.getLoadQueryInfluencers().setEnabledInternalFetchProfileType(LoadQueryInfluencers.InternalFetchProfileType.REFRESH);
        LockOptions lockOptionsToUse = event.getLockOptions();
        LockMode requestedLockMode = lockOptionsToUse.getLockMode();
        LockMode postRefreshLockMode = null;
        if (e != null && (currentLockMode = e.getLockMode()).greaterThan(requestedLockMode)) {
            lockOptionsToUse = LockOptions.copy(event.getLockOptions(), new LockOptions());
            if (currentLockMode == LockMode.WRITE || currentLockMode == LockMode.PESSIMISTIC_WRITE || currentLockMode == LockMode.PESSIMISTIC_READ) {
                lockOptionsToUse.setLockMode(LockMode.READ);
                postRefreshLockMode = currentLockMode;
            } else {
                lockOptionsToUse.setLockMode(currentLockMode);
            }
        }
        if ((result = entityDescriptor.getSingleIdLoader().load(id, lockOptionsToUse, source)) != null) {
            if (postRefreshLockMode != null) {
                source.getPersistenceContext().getEntry(result).setLockMode(postRefreshLockMode);
            }
            if (!entityDescriptor.getHierarchy().getMutabilityPlan().isMutable()) {
                source.setReadOnly(result, true);
            } else {
                source.setReadOnly(result, e == null ? source.isDefaultReadOnly() : e.isReadOnly());
            }
        }
        UnresolvableObjectException.throwIfNull(result, id, entityDescriptor.getEntityName());
    }

    private void evictCachedCollections(EntityTypeDescriptor entityDescriptor, Object id, EventSource source) {
        this.evictCachedCollections(entityDescriptor.getPersistentAttributes(), id, source);
    }

    private void evictCachedCollections(List<PersistentAttributeDescriptor> persistentAttributes, Object id, EventSource source) throws HibernateException {
        for (PersistentAttributeDescriptor attribute : persistentAttributes) {
            if (PluralPersistentAttribute.class.isInstance(attribute)) {
                PersistentCollectionDescriptor collectionDescriptor = ((PluralPersistentAttribute)attribute).getPersistentCollectionDescriptor();
                if (!collectionDescriptor.hasCache()) continue;
                CollectionDataAccess cache = collectionDescriptor.getCacheAccess();
                Object ck = cache.generateCacheKey(id, collectionDescriptor, source.getFactory(), source.getTenantIdentifier());
                SoftLock lock = cache.lockItem(source, ck, null);
                source.getActionQueue().registerProcess((success, session) -> cache.unlockItem(session, ck, lock));
                cache.remove(source, ck);
                continue;
            }
            if (!EmbeddedValuedNavigable.class.isInstance(attribute)) continue;
            EmbeddedValuedNavigable composite = (EmbeddedValuedNavigable)((Object)attribute);
            this.evictCachedCollections(composite.getEmbeddedDescriptor().getPersistentAttributes(), id, source);
        }
    }
}

