/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ReplicationMode;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.internal.OnReplicateVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.ReplicateEvent;
import org.hibernate.event.spi.ReplicateEventListener;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;
import org.hibernate.pretty.MessageHelper;

public class DefaultReplicateEventListener
extends AbstractSaveEventListener
implements ReplicateEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultReplicateEventListener.class);

    @Override
    public void onReplicate(ReplicateEvent event) {
        EventSource source = event.getSession();
        if (source.getPersistenceContext().reassociateIfUninitializedProxy(event.getObject())) {
            LOG.trace("Uninitialized proxy passed to replicate()");
            return;
        }
        Object entity = source.getPersistenceContext().unproxyAndReassociate(event.getObject());
        if (source.getPersistenceContext().isEntryFor(entity)) {
            LOG.trace("Ignoring persistent instance passed to replicate()");
            return;
        }
        EntityTypeDescriptor entityDescriptor = source.getEntityDescriptor(event.getEntityName(), entity);
        EntityIdentifier idDescriptor = entityDescriptor.getHierarchy().getIdentifierDescriptor();
        VersionDescriptor versionDescriptor = entityDescriptor.getHierarchy().getVersionDescriptor();
        Object id = entityDescriptor.getIdentifier(entity);
        if (id == null) {
            throw new TransientObjectException("instance with null id passed to replicate()");
        }
        ReplicationMode replicationMode = event.getReplicationMode();
        Object oldVersion = replicationMode == ReplicationMode.EXCEPTION ? null : entityDescriptor.getHierarchy().getVersionDescriptor().getPropertyAccess().getGetter().get(id);
        boolean traceEnabled = LOG.isTraceEnabled();
        if (oldVersion != null) {
            Object realOldVersion;
            boolean canReplicate;
            if (traceEnabled) {
                LOG.tracev("Found existing row for {0}", MessageHelper.infoString(entityDescriptor, id, source.getFactory()));
            }
            if (canReplicate = replicationMode.shouldOverwriteCurrentVersion(entity, realOldVersion = versionDescriptor != null ? oldVersion : null, entityDescriptor.getVersion(entity), versionDescriptor)) {
                this.performReplication(entity, id, realOldVersion, entityDescriptor, replicationMode, source);
            } else if (traceEnabled) {
                LOG.trace("No need to replicate");
            }
        } else {
            boolean regenerate;
            if (traceEnabled) {
                LOG.tracev("No existing row, replicating new instance {0}", MessageHelper.infoString(entityDescriptor, id, source.getFactory()));
            }
            EntityKey key = (regenerate = PostInsertIdentifierGenerator.class.isInstance(idDescriptor.getIdentifierValueGenerator())) ? null : source.generateEntityKey(id, entityDescriptor);
            this.performSaveOrReplicate(entity, key, entityDescriptor, regenerate, (Object)replicationMode, source, true);
        }
    }

    @Override
    protected boolean visitCollectionsBeforeSave(Object entity, Object id, Object[] values, List<PersistentAttributeDescriptor> navigables, EventSource source) {
        OnReplicateVisitor visitor = new OnReplicateVisitor(source, id, entity, false);
        visitor.processEntityPropertyValues(values, navigables);
        return super.visitCollectionsBeforeSave(entity, id, values, navigables, source);
    }

    @Override
    protected boolean substituteValuesIfNecessary(Object entity, Object id, Object[] values, EntityTypeDescriptor entityDescriptor, SessionImplementor source) {
        return false;
    }

    @Override
    protected boolean isVersionIncrementDisabled() {
        return true;
    }

    private void performReplication(Object entity, Object id, Object version, EntityTypeDescriptor entityDescriptor, ReplicationMode replicationMode, EventSource source) throws HibernateException {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Replicating changes to {0}", MessageHelper.infoString(entityDescriptor, id, source.getFactory()));
        }
        new OnReplicateVisitor(source, id, entity, true).process(entity, entityDescriptor);
        source.getPersistenceContext().addEntity(entity, entityDescriptor.getJavaTypeDescriptor().getMutabilityPlan().isMutable() ? Status.MANAGED : Status.READ_ONLY, null, source.generateEntityKey(id, entityDescriptor), version, LockMode.NONE, true, entityDescriptor, true);
        this.cascadeAfterReplicate(entity, entityDescriptor, replicationMode, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeAfterReplicate(Object entity, EntityTypeDescriptor entityDescriptor, ReplicationMode replicationMode, EventSource source) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascade.cascade(CascadingActions.REPLICATE, CascadePoint.AFTER_UPDATE, source, entityDescriptor, entity, (Object)replicationMode);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    @Override
    protected CascadingAction getCascadeAction() {
        return CascadingActions.REPLICATE;
    }
}

