/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.concurrent.TimeUnit;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.internal.AbstractLockUpgradeEventListener;
import org.hibernate.event.spi.ResolveNaturalIdEvent;
import org.hibernate.event.spi.ResolveNaturalIdEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.pretty.MessageHelper;

public class DefaultResolveNaturalIdEventListener
extends AbstractLockUpgradeEventListener
implements ResolveNaturalIdEventListener {
    public static final Object REMOVED_ENTITY_MARKER = new Object();
    public static final Object INCONSISTENT_RTN_CLASS_MARKER = new Object();
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultResolveNaturalIdEventListener.class);

    @Override
    public void onResolveNaturalId(ResolveNaturalIdEvent event) throws HibernateException {
        Object entityId = this.resolveNaturalId(event);
        event.setEntityId(entityId);
    }

    protected Object resolveNaturalId(ResolveNaturalIdEvent event) {
        Object entityId;
        EntityTypeDescriptor descriptor = event.getEntityDescriptor();
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.tracev("Attempting to resolve: {0}#{1}", MessageHelper.infoString(descriptor), event.getNaturalIdValues());
        }
        if ((entityId = this.resolveFromCache(event)) != null) {
            if (traceEnabled) {
                LOG.tracev("Resolved object in cache: {0}#{1}", MessageHelper.infoString(descriptor), event.getNaturalIdValues());
            }
            return entityId;
        }
        if (traceEnabled) {
            LOG.tracev("Object not resolved in any cache: {0}#{1}", MessageHelper.infoString(descriptor), event.getNaturalIdValues());
        }
        return this.loadFromDatasource(event);
    }

    protected Object resolveFromCache(ResolveNaturalIdEvent event) {
        return event.getSession().getPersistenceContext().getNaturalIdHelper().findCachedNaturalIdResolution(event.getEntityDescriptor(), event.getOrderedNaturalIdValues());
    }

    protected Object loadFromDatasource(ResolveNaturalIdEvent event) {
        SessionFactoryImplementor factory = event.getSession().getFactory();
        boolean stats = factory.getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.nanoTime();
        }
        Object pk = event.getEntityDescriptor().getNaturalIdLoader().resolveNaturalIdToEntity(event.getOrderedNaturalIdValues(), event.getLockOptions(), event.getSession());
        if (stats) {
            long endTime = System.nanoTime();
            long milliseconds = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
            factory.getStatistics().naturalIdQueryExecuted(event.getEntityDescriptor().getHierarchy().getRootEntityType().getEntityName(), milliseconds);
        }
        if (pk != null) {
            event.getSession().getPersistenceContext().getNaturalIdHelper().cacheNaturalIdCrossReferenceFromLoad(event.getEntityDescriptor(), pk, event.getOrderedNaturalIdValues());
        }
        return pk;
    }
}

