/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.PersistentObjectException;
import org.hibernate.TransientObjectException;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.internal.OnUpdateVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;

public class DefaultSaveOrUpdateEventListener
extends AbstractSaveEventListener
implements SaveOrUpdateEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultSaveOrUpdateEventListener.class);

    @Override
    public void onSaveOrUpdate(SaveOrUpdateEvent event) {
        EventSource source = event.getSession();
        Object object = event.getObject();
        Object requestedId = event.getRequestedId();
        if (requestedId != null && object instanceof HibernateProxy) {
            ((HibernateProxy)object).getHibernateLazyInitializer().setIdentifier(requestedId);
        }
        if (this.reassociateIfUninitializedProxy(object, source)) {
            LOG.trace("Reassociated uninitialized proxy");
        } else {
            Object entity = source.getPersistenceContext().unproxyAndReassociate(object);
            event.setEntity(entity);
            event.setEntry(source.getPersistenceContext().getEntry(entity));
            event.setResultId(this.performSaveOrUpdate(event));
        }
    }

    protected boolean reassociateIfUninitializedProxy(Object object, SessionImplementor source) {
        return source.getPersistenceContext().reassociateIfUninitializedProxy(object);
    }

    protected Object performSaveOrUpdate(SaveOrUpdateEvent event) {
        AbstractSaveEventListener.EntityState entityState = this.getEntityState(event.getEntity(), event.getEntityName(), event.getEntry(), event.getSession());
        switch (entityState) {
            case DETACHED: {
                this.entityIsDetached(event);
                return null;
            }
            case PERSISTENT: {
                return this.entityIsPersistent(event);
            }
        }
        return this.entityIsTransient(event);
    }

    protected Object entityIsPersistent(SaveOrUpdateEvent event) throws HibernateException {
        Object savedId;
        EntityEntry entityEntry;
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("Ignoring persistent instance");
        }
        if ((entityEntry = event.getEntry()) == null) {
            throw new AssertionFailure("entity was transient or detached");
        }
        if (entityEntry.getStatus() == Status.DELETED) {
            throw new AssertionFailure("entity was deleted");
        }
        SessionFactoryImplementor factory = event.getSession().getFactory();
        Object requestedId = event.getRequestedId();
        if (requestedId == null) {
            savedId = entityEntry.getId();
        } else {
            boolean isEqual;
            boolean bl = isEqual = !entityEntry.getDescriptor().getIdentifierDescriptor().getJavaTypeDescriptor().areEqual(requestedId, entityEntry.getId());
            if (isEqual) {
                throw new PersistentObjectException("object passed to save() was already persistent: " + MessageHelper.infoString(entityEntry.getDescriptor(), requestedId, factory));
            }
            savedId = requestedId;
        }
        if (traceEnabled) {
            LOG.tracev("Object already associated with session: {0}", MessageHelper.infoString(entityEntry.getDescriptor(), savedId, factory));
        }
        return savedId;
    }

    protected Object entityIsTransient(SaveOrUpdateEvent event) {
        LOG.trace("Saving transient instance");
        EventSource source = event.getSession();
        EntityEntry entityEntry = event.getEntry();
        if (entityEntry != null) {
            if (entityEntry.getStatus() == Status.DELETED) {
                source.forceFlush(entityEntry);
            } else {
                throw new AssertionFailure("entity was persistent");
            }
        }
        Object id = this.saveWithGeneratedOrRequestedId(event);
        source.getPersistenceContext().reassociateProxy(event.getObject(), id);
        return id;
    }

    protected Object saveWithGeneratedOrRequestedId(SaveOrUpdateEvent event) {
        return this.saveWithGeneratedId(event.getEntity(), event.getEntityName(), null, event.getSession(), true);
    }

    protected void entityIsDetached(SaveOrUpdateEvent event) {
        LOG.trace("Updating detached instance");
        if (event.getSession().getPersistenceContext().isEntryFor(event.getEntity())) {
            throw new AssertionFailure("entity was persistent");
        }
        Object entity = event.getEntity();
        EntityTypeDescriptor entityDescriptor = event.getSession().getEntityDescriptor(event.getEntityName(), entity);
        event.setRequestedId(this.getUpdateId(entity, entityDescriptor, event.getRequestedId(), event.getSession()));
        this.performUpdate(event, entity, entityDescriptor);
    }

    protected Object getUpdateId(Object entity, EntityTypeDescriptor descriptor, Object requestedId, SessionImplementor session) {
        Object id = descriptor.getIdentifier(entity);
        if (id == null) {
            throw new TransientObjectException("The given object has a null identifier: " + descriptor.getEntityName());
        }
        return id;
    }

    protected void performUpdate(SaveOrUpdateEvent event, Object entity, EntityTypeDescriptor entityDescriptor) throws HibernateException {
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled && !entityDescriptor.getJavaTypeDescriptor().getMutabilityPlan().isMutable()) {
            LOG.trace("Immutable instance passed to performUpdate()");
        }
        if (traceEnabled) {
            LOG.tracev("Updating {0}", MessageHelper.infoString(entityDescriptor, event.getRequestedId(), event.getSession().getFactory()));
        }
        EventSource source = event.getSession();
        EntityKey key = source.generateEntityKey(event.getRequestedId(), entityDescriptor);
        source.getPersistenceContext().checkUniqueness(key, entity);
        if (this.invokeUpdateLifecycle(entity, entityDescriptor, source)) {
            this.reassociate(event, event.getObject(), event.getRequestedId(), entityDescriptor);
            return;
        }
        new OnUpdateVisitor(source, event.getRequestedId(), entity).process(entity, entityDescriptor);
        source.getPersistenceContext().addEntity(entity, entityDescriptor.getJavaTypeDescriptor().getMutabilityPlan().isMutable() ? Status.MANAGED : Status.READ_ONLY, null, key, entityDescriptor.getVersion(entity), LockMode.NONE, true, entityDescriptor, false);
        entityDescriptor.afterReassociate(entity, source);
        if (traceEnabled) {
            LOG.tracev("Updating {0}", MessageHelper.infoString(entityDescriptor, event.getRequestedId(), source.getFactory()));
        }
        this.cascadeOnUpdate(event, entityDescriptor, entity);
    }

    protected boolean invokeUpdateLifecycle(Object entity, EntityTypeDescriptor entityDescriptor, EventSource source) {
        if (entityDescriptor.implementsLifecycle()) {
            LOG.debug("Calling onUpdate()");
            if (((Lifecycle)entity).onUpdate(source)) {
                LOG.debug("Update vetoed by onUpdate()");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnUpdate(SaveOrUpdateEvent event, EntityTypeDescriptor entityDescriptor, Object entity) {
        EventSource source = event.getSession();
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascade.cascade(CascadingActions.SAVE_UPDATE, CascadePoint.AFTER_UPDATE, source, entityDescriptor, entity);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    @Override
    protected CascadingAction getCascadeAction() {
        return CascadingActions.SAVE_UPDATE;
    }
}

