/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.collection.spi.CollectionClassification;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.internal.AbstractVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.pretty.MessageHelper;

public class EvictVisitor
extends AbstractVisitor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EvictVisitor.class);
    private Object owner;

    EvictVisitor(EventSource session, Object owner) {
        super(session);
        this.owner = owner;
    }

    @Override
    Object processCollection(Object collection, PluralPersistentAttribute collectionAttribute) throws HibernateException {
        if (collection != null) {
            this.evictCollection(collection, collectionAttribute);
        }
        return null;
    }

    public void evictCollection(Object value, PluralPersistentAttribute attributeCollection) {
        PersistentCollection collection;
        if (attributeCollection.getPersistentCollectionDescriptor().getCollectionClassification() == CollectionClassification.ARRAY) {
            collection = this.getSession().getPersistenceContext().removeCollectionHolder(value);
        } else if (value instanceof PersistentCollection) {
            collection = (PersistentCollection)value;
        } else {
            if (value == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                throw new NotYetImplementedFor6Exception("evictCollection + LazyPropertyInitializer.UNFETCHED_PROPERTY");
            }
            return;
        }
        if (collection != null && collection.unsetSession(this.getSession())) {
            this.evictCollection(collection);
        }
    }

    private void evictCollection(PersistentCollection collection) {
        CollectionEntry ce = (CollectionEntry)this.getSession().getPersistenceContext().getCollectionEntries().remove(collection);
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Evicting collection: %s", MessageHelper.collectionInfoString(ce.getLoadedCollectionDescriptor(), collection, ce.getLoadedKey(), (SharedSessionContractImplementor)this.getSession()));
        }
        if (ce.getLoadedCollectionDescriptor() != null && ce.getLoadedCollectionDescriptor().getBatchSize() > 1) {
            this.getSession().getPersistenceContext().getBatchFetchQueue().removeBatchLoadableCollection(ce);
        }
        if (ce.getLoadedCollectionDescriptor() != null && ce.getLoadedKey() != null) {
            this.getSession().getPersistenceContext().getCollectionsByKey().remove(new CollectionKey(ce.getLoadedCollectionDescriptor(), ce.getLoadedKey()));
        }
    }

    @Override
    boolean includeEntityProperty(Object[] values, int i) {
        return true;
    }
}

