/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.collection.spi.CollectionClassification;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.Collections;
import org.hibernate.event.internal.AbstractVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;

public class FlushVisitor
extends AbstractVisitor {
    private Object owner;

    @Override
    Object processCollection(Object collection, PluralPersistentAttribute collectionAttribute) throws HibernateException {
        if (collection == PersistentCollectionDescriptor.UNFETCHED_COLLECTION) {
            return null;
        }
        if (collection != null) {
            PersistentCollection coll;
            if (collectionAttribute.getPersistentCollectionDescriptor().getCollectionClassification() == CollectionClassification.ARRAY) {
                coll = this.getSession().getPersistenceContext().getCollectionHolder(collection);
            } else {
                if (collection == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                    throw new NotYetImplementedFor6Exception("processCollection + LazyPropertyInitializer.UNFETCHED_PROPERTY");
                }
                coll = (PersistentCollection)collection;
            }
            Collections.processReachableCollection(coll, collectionAttribute, this.owner, this.getSession());
        }
        return null;
    }

    @Override
    boolean includeEntityProperty(Object[] values, int i) {
        return true;
    }

    FlushVisitor(EventSource session, Object owner) {
        super(session);
        this.owner = owner;
    }
}

