/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.event.internal.ReattachVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;

public class OnLockVisitor
extends ReattachVisitor {
    public OnLockVisitor(EventSource session, Object key, Object owner) {
        super(session, key, owner);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object processCollection(Object collection, PluralPersistentAttribute collectionAttribute) throws HibernateException {
        if (collection == null) {
            return null;
        }
        EventSource session = this.getSession();
        if (!(collection instanceof PersistentCollection)) throw new HibernateException("reassociated object has dirty collection reference (or an array)");
        PersistentCollection persistentCollection = (PersistentCollection)collection;
        if (!persistentCollection.setCurrentSession(session)) throw new HibernateException("reassociated object has dirty collection reference");
        PersistentCollectionDescriptor descriptor = session.getFactory().getMetamodel().findCollectionDescriptor(collectionAttribute.getNavigableRole().getFullPath());
        if (!OnLockVisitor.isOwnerUnchanged(persistentCollection, descriptor, this.extractCollectionKeyFromOwner(descriptor))) throw new HibernateException("reassociated object has dirty collection reference");
        if (persistentCollection.isDirty()) {
            throw new HibernateException("reassociated object has dirty collection");
        }
        this.reattachCollection(persistentCollection, collectionAttribute.getNavigableRole());
        return null;
    }
}

