/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.event.internal.ReattachVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;

public class OnReplicateVisitor
extends ReattachVisitor {
    private boolean isUpdate;

    OnReplicateVisitor(EventSource session, Object key, Object owner, boolean isUpdate) {
        super(session, key, owner);
        this.isUpdate = isUpdate;
    }

    @Override
    public Object processCollection(Object collection, PluralPersistentAttribute collectionAttribute) throws HibernateException {
        if (collection == PersistentCollectionDescriptor.UNFETCHED_COLLECTION) {
            return null;
        }
        EventSource session = this.getSession();
        PersistentCollectionDescriptor descriptor = session.getFactory().getMetamodel().findCollectionDescriptor(collectionAttribute.getNavigableName());
        if (this.isUpdate) {
            this.removeCollection(descriptor, this.extractCollectionKeyFromOwner(descriptor), session);
        }
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection wrapper = (PersistentCollection)collection;
            wrapper.setCurrentSession(session);
            if (wrapper.wasInitialized()) {
                session.getPersistenceContext().addNewCollection(descriptor, wrapper);
            } else {
                this.reattachCollection(wrapper, descriptor.getNavigableRole());
            }
        }
        return null;
    }
}

