/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.event.internal.ReattachVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;

public class OnUpdateVisitor
extends ReattachVisitor {
    OnUpdateVisitor(EventSource session, Object key, Object owner) {
        super(session, key, owner);
    }

    @Override
    Object processCollection(Object collection, PluralPersistentAttribute collectionAttribute) throws HibernateException {
        if (collection == PersistentCollectionDescriptor.UNFETCHED_COLLECTION) {
            return null;
        }
        EventSource session = this.getSession();
        PersistentCollectionDescriptor descriptor = session.getFactory().getMetamodel().findCollectionDescriptor(collectionAttribute.getNavigableRole());
        Object collectionKey = this.extractCollectionKeyFromOwner(descriptor);
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection wrapper = (PersistentCollection)collection;
            if (wrapper.setCurrentSession(session)) {
                if (!OnUpdateVisitor.isOwnerUnchanged(wrapper, descriptor, collectionKey)) {
                    this.removeCollection(descriptor, collectionKey, session);
                }
                this.reattachCollection(wrapper, descriptor.getNavigableRole());
            } else {
                this.removeCollection(descriptor, collectionKey, session);
            }
        } else {
            this.removeCollection(descriptor, collectionKey, session);
        }
        return null;
    }
}

