/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.event.internal.AbstractVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public abstract class ProxyVisitor
extends AbstractVisitor {
    public ProxyVisitor(EventSource session) {
        super(session);
    }

    @Override
    Object processEntity(Object value, EntityTypeDescriptor descriptor) throws HibernateException {
        if (value != null) {
            this.getSession().getPersistenceContext().reassociateIfUninitializedProxy(value);
        }
        return null;
    }

    protected static boolean isOwnerUnchanged(PersistentCollection snapshot, PersistentCollectionDescriptor descriptor, Object id) {
        return ProxyVisitor.isCollectionSnapshotValid(snapshot) && descriptor.getNavigableRole().getFullPath().equals(snapshot.getRole()) && id.equals(snapshot.getKey());
    }

    private static boolean isCollectionSnapshotValid(PersistentCollection snapshot) {
        return snapshot != null && snapshot.getRole() != null && snapshot.getKey() != null;
    }

    protected void reattachCollection(PersistentCollection collection, NavigableRole role) throws HibernateException {
        if (collection.wasInitialized()) {
            PersistentCollectionDescriptor collectionDescriptor = this.getSession().getFactory().getMetamodel().findCollectionDescriptor(role.getFullPath());
            this.getSession().getPersistenceContext().addInitializedDetachedCollection(collectionDescriptor, collection);
        } else {
            if (!ProxyVisitor.isCollectionSnapshotValid(collection)) {
                throw new HibernateException("could not reassociate uninitialized transient collection");
            }
            PersistentCollectionDescriptor collectionDescriptor = this.getSession().getFactory().getMetamodel().findCollectionDescriptor(collection.getRole());
            this.getSession().getPersistenceContext().addUninitializedDetachedCollection(collectionDescriptor, collection);
        }
    }
}

