/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Collection;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionRemoveAction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.internal.ProxyVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.pretty.MessageHelper;

public abstract class ReattachVisitor
extends ProxyVisitor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ReattachVisitor.class);
    private final Object ownerIdentifier;
    private final Object owner;

    public ReattachVisitor(EventSource session, Object ownerIdentifier, Object owner) {
        super(session);
        this.ownerIdentifier = ownerIdentifier;
        this.owner = owner;
    }

    final Object getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    final Object getOwner() {
        return this.owner;
    }

    @Override
    Object processComponent(Object component, EmbeddedTypeDescriptor descriptor) throws HibernateException {
        Collection subclassTypes = descriptor.getSubclassTypes();
        if (subclassTypes == null) {
            this.processValues(new Object[subclassTypes.size()], subclassTypes);
        } else {
            super.processComponent(component, descriptor);
        }
        return null;
    }

    void removeCollection(PersistentCollectionDescriptor role, Object collectionKey, EventSource source) throws HibernateException {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Collection dereferenced while transient {0}", MessageHelper.collectionInfoString(role, this.ownerIdentifier, source.getFactory()));
        }
        source.getActionQueue().addAction(new CollectionRemoveAction(this.owner, role, collectionKey, false, (SharedSessionContractImplementor)source));
    }

    final Object extractCollectionKeyFromOwner(PersistentCollectionDescriptor collectionDescriptor) {
        if (collectionDescriptor.useOwnerIndetifier()) {
            return this.ownerIdentifier;
        }
        return collectionDescriptor.findEntityOwnerDescriptor().getPropertyValue(this.owner, collectionDescriptor.getForeignKeyTargetNavigable().getNavigableName());
    }
}

