/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.CollectionClassification;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.event.internal.ProxyVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;

public class WrapVisitor
extends ProxyVisitor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(WrapVisitor.class);
    boolean substitute;

    boolean isSubstitutionRequired() {
        return this.substitute;
    }

    WrapVisitor(EventSource session) {
        super(session);
    }

    @Override
    Object processCollection(Object collection, PluralPersistentAttribute collectionAttribute) throws HibernateException {
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection coll = (PersistentCollection)collection;
            EventSource session = this.getSession();
            if (coll.setCurrentSession(session)) {
                this.reattachCollection(coll, collectionAttribute.getNavigableRole());
            }
            return null;
        }
        return this.processArrayOrNewCollection(collection, collectionAttribute.getCollectionDescriptor());
    }

    final Object processArrayOrNewCollection(Object collection, PersistentCollectionDescriptor collectionDescriptor) throws HibernateException {
        EventSource session = this.getSession();
        if (collection == null) {
            return null;
        }
        PersistenceContext persistenceContext = session.getPersistenceContext();
        if (collectionDescriptor.getCollectionClassification() == CollectionClassification.ARRAY) {
            if (collection == PersistentCollectionDescriptor.UNFETCHED_COLLECTION) {
                return null;
            }
            PersistentCollection collectionHolder = persistenceContext.getCollectionHolder(collection);
            if (collectionHolder == null) {
                collectionHolder = collectionDescriptor.wrap(session, collection);
                persistenceContext.addNewCollection(collectionDescriptor, collectionHolder);
                persistenceContext.addCollectionHolder(collectionHolder);
            }
            return null;
        }
        PersistentCollection persistentCollection = collectionDescriptor.wrap(session, collection);
        persistenceContext.addNewCollection(collectionDescriptor, persistentCollection);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Wrapped collection in role: {0}", collectionDescriptor.getNavigableRole().getFullPath());
        }
        return persistentCollection;
    }

    @Override
    void processValue(int i, Object[] values, PersistentAttributeDescriptor attribute) throws HibernateException {
        Object result = this.processValue(values[i], attribute);
        if (result != null) {
            this.substitute = true;
            values[i] = result;
        }
    }

    @Override
    Object processComponent(Object component, EmbeddedTypeDescriptor descriptor) throws HibernateException {
        if (component != null) {
            Object[] values = descriptor.getPropertyValues(component);
            List<NonIdPersistentAttribute> persistentAttributes = descriptor.getPersistentAttributes();
            boolean substituteComponent = false;
            int i = 0;
            for (PersistentAttributeDescriptor persistentAttributeDescriptor : persistentAttributes) {
                Object result = this.processValue(values[i], persistentAttributeDescriptor);
                if (result != null) {
                    values[i] = result;
                    substituteComponent = true;
                }
                ++i;
            }
            if (substituteComponent) {
                descriptor.setPropertyValues(component, values);
            }
        }
        return null;
    }

    @Override
    void process(Object object, EntityTypeDescriptor descriptor) throws HibernateException {
        Object[] values = descriptor.getPropertyValues(object);
        List persistentAttributes = descriptor.getPersistentAttributes();
        this.processEntityPropertyValues(values, persistentAttributes);
        if (this.isSubstitutionRequired()) {
            descriptor.setPropertyValues(object, values);
        }
    }
}

