/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.spi;

import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public abstract class AbstractCollectionEvent
extends AbstractEvent {
    private final PersistentCollection collection;
    private final Object affectedOwner;
    private final Object affectedOwnerId;
    private final String affectedOwnerEntityName;

    public AbstractCollectionEvent(PersistentCollectionDescriptor collectionDescriptor, PersistentCollection collection, EventSource source, Object affectedOwner, Object affectedOwnerId) {
        super(source);
        this.collection = collection;
        this.affectedOwner = affectedOwner;
        this.affectedOwnerId = affectedOwnerId;
        this.affectedOwnerEntityName = AbstractCollectionEvent.getAffectedOwnerEntityName(collectionDescriptor, affectedOwner, source);
    }

    protected static PersistentCollectionDescriptor getLoadedCollectionDescriptor(PersistentCollection collection, EventSource source) {
        CollectionEntry ce = source.getPersistenceContext().getCollectionEntry(collection);
        return ce == null ? null : ce.getLoadedCollectionDescriptor();
    }

    protected static Object getLoadedOwnerOrNull(PersistentCollection collection, EventSource source) {
        return source.getPersistenceContext().getLoadedCollectionOwnerOrNull(collection);
    }

    protected static Object getLoadedOwnerIdOrNull(PersistentCollection collection, EventSource source) {
        return source.getPersistenceContext().getLoadedCollectionOwnerIdOrNull(collection);
    }

    protected static Object getOwnerIdOrNull(Object owner, EventSource source) {
        EntityEntry ownerEntry = source.getPersistenceContext().getEntry(owner);
        return ownerEntry == null ? null : ownerEntry.getId();
    }

    protected static String getAffectedOwnerEntityName(PersistentCollectionDescriptor collectionDescriptor, Object affectedOwner, EventSource source) {
        EntityEntry ee;
        String entityName;
        String string = entityName = collectionDescriptor == null ? null : collectionDescriptor.findEntityOwnerDescriptor().getEntityName();
        if (affectedOwner != null && (ee = source.getPersistenceContext().getEntry(affectedOwner)) != null && ee.getEntityName() != null) {
            entityName = ee.getEntityName();
        }
        return entityName;
    }

    public PersistentCollection getCollection() {
        return this.collection;
    }

    public Object getAffectedOwnerOrNull() {
        return this.affectedOwner;
    }

    public Object getAffectedOwnerIdOrNull() {
        return this.affectedOwnerId;
    }

    public String getAffectedOwnerEntityName() {
        return this.affectedOwnerEntityName;
    }
}

