/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.spi;

import java.util.Collections;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NaturalIdDescriptor;

public class ResolveNaturalIdEvent
extends AbstractEvent {
    public static final LockMode DEFAULT_LOCK_MODE = LockMode.NONE;
    private final EntityTypeDescriptor entityDescriptor;
    private final Map<String, Object> naturalIdValues;
    private final Object[] orderedNaturalIdValues;
    private final LockOptions lockOptions;
    private Object entityId;

    public ResolveNaturalIdEvent(Map<String, Object> naturalIdValues, EntityTypeDescriptor entityDescriptor, EventSource source) {
        this(naturalIdValues, entityDescriptor, new LockOptions(), source);
    }

    public ResolveNaturalIdEvent(Map<String, Object> naturalIdValues, EntityTypeDescriptor entityDescriptor, LockOptions lockOptions, EventSource source) {
        super(source);
        if (entityDescriptor == null) {
            throw new IllegalArgumentException("EntityPersister is required for loading");
        }
        if (!entityDescriptor.hasNaturalIdentifier()) {
            throw new HibernateException("Entity did not define a natural-id");
        }
        if (naturalIdValues == null || naturalIdValues.isEmpty()) {
            throw new IllegalArgumentException("natural-id to load is required");
        }
        NaturalIdDescriptor naturalIdDescriptor = entityDescriptor.getHierarchy().getNaturalIdDescriptor();
        if (naturalIdDescriptor.getAttributeInfos().size() != naturalIdValues.size()) {
            throw new HibernateException(String.format("Entity [%s] defines its natural-id with %d properties but only %d were specified", entityDescriptor.getEntityName(), naturalIdDescriptor.getAttributeInfos().size(), naturalIdValues.size()));
        }
        if (lockOptions.getLockMode() == LockMode.WRITE) {
            throw new IllegalArgumentException("Invalid lock mode for loading");
        }
        if (lockOptions.getLockMode() == null) {
            lockOptions.setLockMode(DEFAULT_LOCK_MODE);
        }
        this.entityDescriptor = entityDescriptor;
        this.naturalIdValues = naturalIdValues;
        this.lockOptions = lockOptions;
        this.orderedNaturalIdValues = new Object[naturalIdDescriptor.getAttributeInfos().size()];
        int i = 0;
        for (NaturalIdDescriptor.NaturalIdAttributeInfo naturalIdAttribute : naturalIdDescriptor.getAttributeInfos()) {
            String attributeName = naturalIdAttribute.getUnderlyingAttributeDescriptor().getName();
            if (!naturalIdValues.containsKey(attributeName)) {
                throw new HibernateException(String.format("No value specified for natural-id property %s#%s", this.getEntityName(), attributeName));
            }
            this.orderedNaturalIdValues[i++] = naturalIdValues.get(attributeName);
        }
    }

    public Map<String, Object> getNaturalIdValues() {
        return Collections.unmodifiableMap(this.naturalIdValues);
    }

    public Object[] getOrderedNaturalIdValues() {
        return this.orderedNaturalIdValues;
    }

    public EntityTypeDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public String getEntityName() {
        return this.getEntityDescriptor().getEntityName();
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    public Object getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Object entityId) {
        this.entityId = entityId;
    }
}

