/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graph.internal.parse;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.InvalidGraphException;
import org.hibernate.graph.internal.parse.GraphLanguageLexer;
import org.hibernate.graph.internal.parse.GraphLanguageParser;
import org.hibernate.graph.internal.parse.GraphLanguageParserBaseVisitor;
import org.hibernate.graph.internal.parse.PathQualifierType;
import org.hibernate.graph.internal.parse.SubGraphGenerator;
import org.hibernate.graph.spi.AttributeNodeImplementor;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.jboss.logging.Logger;

public class GraphParser
extends GraphLanguageParserBaseVisitor {
    public static final Logger PARSING_LOGGER = Logger.getLogger((String)"org.hibernate.orm.graph.parsing");
    private final SessionFactoryImplementor sessionFactory;
    private final Stack<GraphImplementor<?>> graphStack = new StandardStack();
    private final Stack<AttributeNodeImplementor<?>> attributeNodeStack = new StandardStack();
    private final Stack<SubGraphGenerator> graphSourceStack = new StandardStack<SubGraphGenerator>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseInto(GraphImplementor<?> targetGraph, String graphString, SessionFactoryImplementor sessionFactory) {
        GraphLanguageLexer lexer = new GraphLanguageLexer((CharStream)CharStreams.fromString((String)graphString));
        GraphLanguageParser parser = new GraphLanguageParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        GraphParser visitor = new GraphParser(sessionFactory);
        visitor.graphStack.push(targetGraph);
        try {
            visitor.visitGraph(parser.graph());
        }
        finally {
            visitor.graphStack.pop();
            assert (visitor.graphStack.isEmpty());
        }
    }

    public GraphParser(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeNodeImplementor visitAttributeNode(GraphLanguageParser.AttributeNodeContext ctx) {
        SubGraphGenerator subGraphCreator;
        String attributeName = ctx.attributePath().NAME().getText();
        if (ctx.attributePath().attributeQualifier() == null) {
            if (PARSING_LOGGER.isDebugEnabled()) {
                PARSING_LOGGER.debugf("%s Start attribute : %s", (Object)StringHelper.repeat(">>", this.attributeNodeStack.depth() + 1), (Object)attributeName);
            }
            subGraphCreator = PathQualifierType.VALUE.getSubGraphCreator();
        } else {
            String qualifierName = ctx.attributePath().attributeQualifier().NAME().getText();
            if (PARSING_LOGGER.isDebugEnabled()) {
                PARSING_LOGGER.debugf("%s Start qualified attribute : %s.%s", (Object)StringHelper.repeat(">>", this.attributeNodeStack.depth() + 1), (Object)attributeName, (Object)qualifierName);
            }
            PathQualifierType pathQualifierType = this.resolvePathQualifier(qualifierName);
            subGraphCreator = pathQualifierType.getSubGraphCreator();
        }
        AttributeNodeImplementor attributeNode = this.resolveAttributeNode(attributeName);
        if (ctx.subGraph() != null) {
            this.attributeNodeStack.push(attributeNode);
            this.graphSourceStack.push(subGraphCreator);
            try {
                this.visitSubGraph(ctx.subGraph());
            }
            finally {
                this.graphSourceStack.pop();
                this.attributeNodeStack.pop();
            }
        }
        if (PARSING_LOGGER.isDebugEnabled()) {
            PARSING_LOGGER.debugf("%s Finished attribute : %s", (Object)StringHelper.repeat("<<", this.attributeNodeStack.depth() + 1), (Object)attributeName);
        }
        return attributeNode;
    }

    private AttributeNodeImplementor resolveAttributeNode(String attributeName) {
        GraphImplementor<?> currentGraph = this.graphStack.getCurrent();
        assert (currentGraph != null);
        AttributeNode attributeNode = currentGraph.addAttributeNode(attributeName);
        assert (attributeNode != null);
        return attributeNode;
    }

    private PathQualifierType resolvePathQualifier(String qualifier) {
        if ("key".equalsIgnoreCase(qualifier)) {
            return PathQualifierType.KEY;
        }
        if ("value".equalsIgnoreCase(qualifier)) {
            return PathQualifierType.VALUE;
        }
        throw new InvalidGraphException("Invalid path qualifier [" + qualifier + "] - expecting `key` or `value`");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubGraphImplementor visitSubGraph(GraphLanguageParser.SubGraphContext ctx) {
        String subTypeName;
        String string = subTypeName = ctx.subType() == null ? null : ctx.subType().getText();
        if (PARSING_LOGGER.isDebugEnabled()) {
            PARSING_LOGGER.debugf("%s Starting graph : %s", (Object)StringHelper.repeat(">>", this.attributeNodeStack.depth() + 2), (Object)subTypeName);
        }
        AttributeNodeImplementor<?> attributeNode = this.attributeNodeStack.getCurrent();
        SubGraphGenerator subGraphCreator = this.graphSourceStack.getCurrent();
        SubGraphImplementor<?> subGraph = subGraphCreator.createSubGraph(attributeNode, subTypeName, this.sessionFactory);
        this.graphStack.push(subGraph);
        try {
            ctx.attributeList().accept(this);
        }
        finally {
            this.graphStack.pop();
        }
        if (PARSING_LOGGER.isDebugEnabled()) {
            PARSING_LOGGER.debugf("%s Finished graph : %s", (Object)StringHelper.repeat("<<", this.attributeNodeStack.depth() + 2), (Object)subGraph.getGraphedType().getDomainTypeName());
        }
        return subGraph;
    }
}

