/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.util.Properties;
import javax.persistence.metamodel.Type;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class ForeignGenerator
implements IdentifierGenerator,
Configurable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ForeignGenerator.class);
    private String entityName;
    private String propertyName;
    private JavaTypeDescriptor javaTypeDescriptor;

    public String getEntityName() {
        return this.entityName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getRole() {
        return this.getEntityName() + '.' + this.getPropertyName();
    }

    @Override
    public void configure(JavaTypeDescriptor javaTypeDescriptor, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.propertyName = params.getProperty("property");
        this.entityName = params.getProperty("entity_name");
        if (this.propertyName == null) {
            throw new MappingException("param named \"property\" is required for foreign id generation strategy");
        }
    }

    @Override
    public Object generate(SharedSessionContractImplementor sessionImplementor, Object object) {
        Object id;
        Session session = (Session)((Object)sessionImplementor);
        EntityTypeDescriptor descriptor = sessionImplementor.getFactory().getMetamodel().findEntityDescriptor(this.entityName);
        Object associatedObject = descriptor.getPropertyValue(object, this.propertyName);
        if (associatedObject == null) {
            throw new IdentifierGenerationException("attempted to assign id from null one-to-one property [" + this.getRole() + "]");
        }
        String entityName = this.retrieveEntityName(descriptor);
        try {
            id = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, associatedObject, sessionImplementor);
        }
        catch (TransientObjectException toe) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("ForeignGenerator detected a transient entity [%s]", entityName);
            }
            id = session.save(entityName, associatedObject);
        }
        if (session.contains(entityName, object)) {
            return IdentifierGeneratorHelper.SHORT_CIRCUIT_INDICATOR;
        }
        return id;
    }

    private String retrieveEntityName(EntityTypeDescriptor descriptor) {
        NonIdPersistentAttribute attribute = descriptor.findPersistentAttribute(this.propertyName);
        String entityName = attribute.getPersistenceType() == Type.PersistenceType.ENTITY ? attribute.getContainer().getNavigableName() : descriptor.findPersistentAttribute("_identifierMapper." + this.propertyName).getContainer().getNavigableName();
        return entityName;
    }
}

