/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.env.spi.QualifiedObjectNameFormatter;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.naming.Identifier;
import org.hibernate.naming.QualifiedTableName;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class IncrementGenerator
implements IdentifierGenerator,
Configurable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(IncrementGenerator.class);
    private Class returnClass;
    private String sql;
    private IntegralDataTypeHolder previousValueHolder;

    @Override
    public synchronized Object generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        if (this.sql != null) {
            this.initializePreviousValueHolder(session);
        }
        return this.previousValueHolder.makeValueThenIncrement();
    }

    @Override
    public void configure(JavaTypeDescriptor javaTypeDescriptor, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        this.returnClass = javaTypeDescriptor.getJavaType();
        JdbcEnvironment jdbcEnvironment = serviceRegistry.getService(JdbcEnvironment.class);
        QualifiedObjectNameFormatter qualifiedObjectNameFormatter = jdbcEnvironment.getQualifiedObjectNameFormatter();
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        String column = params.getProperty("column");
        if (column == null) {
            column = params.getProperty("target_column");
        }
        column = normalizer.normalizeIdentifierQuoting(column).render(jdbcEnvironment.getDialect());
        String tableList = params.getProperty("tables");
        if (tableList == null) {
            tableList = params.getProperty("identity_tables");
        }
        String[] tables = StringHelper.split(", ", tableList);
        Identifier schemaName = normalizer.normalizeIdentifierQuoting(params.getProperty("schema"));
        Identifier catalogName = normalizer.normalizeIdentifierQuoting(params.getProperty("catalog"));
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < tables.length; ++i) {
            Identifier tableName = normalizer.normalizeIdentifierQuoting(tables[i]);
            if (tables.length > 1) {
                buf.append("select max(").append(column).append(") as mx from ");
            }
            buf.append(qualifiedObjectNameFormatter.format(new QualifiedTableName(catalogName, schemaName, tableName), jdbcEnvironment.getDialect()));
            if (i >= tables.length - 1) continue;
            buf.append(" union ");
        }
        if (tables.length > 1) {
            buf.insert(0, "( ").append(" ) ids_");
            column = "ids_.mx";
        }
        this.sql = "select max(" + column + ") from " + buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePreviousValueHolder(SharedSessionContractImplementor session) {
        this.previousValueHolder = IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.returnClass);
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            LOG.debugf("Fetching initial value: %s", this.sql);
        }
        try {
            PreparedStatement st = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(this.sql);
            try {
                ResultSet rs = session.getJdbcCoordinator().getResultSetReturn().extract(st);
                try {
                    if (rs.next()) {
                        this.previousValueHolder.initialize(rs, 0L).increment();
                    } else {
                        this.previousValueHolder.initialize(1L);
                    }
                    this.sql = null;
                    if (debugEnabled) {
                        LOG.debugf("First free id: %s", this.previousValueHolder.makeValue());
                    }
                }
                finally {
                    session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(rs, st);
                }
            }
            finally {
                session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(st);
                session.getJdbcCoordinator().afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(sqle, "could not fetch initial value for increment generator", this.sql);
        }
    }
}

