/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.AbstractPostInsertGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.AbstractSelectingDelegate;
import org.hibernate.id.insert.IdentifierGeneratingInsert;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.metamodel.model.domain.spi.NaturalIdDescriptor;
import org.hibernate.metamodel.valuegen.ValueGenerationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tuple.GenerationTiming;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class SelectGenerator
extends AbstractPostInsertGenerator
implements Configurable {
    private String uniqueKeyPropertyName;

    @Override
    public void configure(JavaTypeDescriptor javaTypeDescriptor, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        this.uniqueKeyPropertyName = params.getProperty("key");
    }

    @Override
    public InsertGeneratedIdentifierDelegate getInsertGeneratedIdentifierDelegate(PostInsertIdentityPersister persister, Dialect dialect, boolean isGetGeneratedKeysEnabled) throws HibernateException {
        return new SelectGeneratorDelegate(persister, dialect, this.uniqueKeyPropertyName);
    }

    private static String determineNameOfPropertyToUse(PostInsertIdentityPersister persister, String supplied) {
        if (supplied != null) {
            return supplied;
        }
        NaturalIdDescriptor naturalIdDescriptor = persister.getHierarchy().getNaturalIdDescriptor();
        if (naturalIdDescriptor == null) {
            throw new IdentifierGenerationException("no natural-id property defined; need to specify [key] in generator parameters");
        }
        if (naturalIdDescriptor.getAttributeInfos().size() > 1) {
            throw new IdentifierGenerationException("select generator does not currently support composite natural-id properties; need to specify [key] in generator parameters");
        }
        ValueGenerationStrategy generationStrategy = naturalIdDescriptor.getAttributeInfos().get(0).getUnderlyingAttributeDescriptor().getValueGenerationStrategy();
        if (generationStrategy.getGenerationTiming() != GenerationTiming.NEVER) {
            throw new IdentifierGenerationException("natural-id also defined as insert-generated; need to specify [key] in generator parameters");
        }
        return naturalIdDescriptor.getAttributeInfos().get(0).getUnderlyingAttributeDescriptor().getAttributeName();
    }

    public static class SelectGeneratorDelegate
    extends AbstractSelectingDelegate
    implements InsertGeneratedIdentifierDelegate {
        private final PostInsertIdentityPersister persister;
        private final Dialect dialect;
        private final String uniqueKeyPropertyName;
        private final String idSelectString;

        private SelectGeneratorDelegate(PostInsertIdentityPersister persister, Dialect dialect, String suppliedUniqueKeyPropertyName) {
            super(persister);
            this.persister = persister;
            this.dialect = dialect;
            this.uniqueKeyPropertyName = SelectGenerator.determineNameOfPropertyToUse(persister, suppliedUniqueKeyPropertyName);
            this.idSelectString = persister.getSelectByUniqueKeyString(this.uniqueKeyPropertyName);
        }

        @Override
        public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert() {
            return new IdentifierGeneratingInsert(this.dialect);
        }

        @Override
        protected String getSelectSQL() {
            return this.idSelectString;
        }

        @Override
        protected void bindParameters(SharedSessionContractImplementor session, PreparedStatement ps, Object entity) throws SQLException {
            throw new NotYetImplementedFor6Exception();
        }

        @Override
        protected Serializable getResult(SharedSessionContractImplementor session, ResultSet rs, Object entity) throws SQLException {
            throw new NotYetImplementedFor6Exception();
        }
    }
}

