/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.util.Properties;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerationStrategy;
import org.hibernate.id.uuid.StandardRandomStrategy;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.internal.UUIDJavaDescriptor;

public class UUIDGenerator
implements IdentifierGenerator,
Configurable {
    public static final String UUID_GEN_STRATEGY = "uuid_gen_strategy";
    public static final String UUID_GEN_STRATEGY_CLASS = "uuid_gen_strategy_class";
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(UUIDGenerator.class);
    private UUIDGenerationStrategy strategy;
    private UUIDJavaDescriptor.ValueTransformer valueTransformer;

    @Override
    public void configure(JavaTypeDescriptor javaTypeDescriptor, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        String strategyClassName;
        this.strategy = (UUIDGenerationStrategy)params.get(UUID_GEN_STRATEGY);
        if (this.strategy == null && (strategyClassName = params.getProperty(UUID_GEN_STRATEGY_CLASS)) != null) {
            try {
                ClassLoaderService cls = serviceRegistry.getService(ClassLoaderService.class);
                Class strategyClass = cls.classForName(strategyClassName);
                try {
                    this.strategy = (UUIDGenerationStrategy)strategyClass.newInstance();
                }
                catch (Exception ignore) {
                    LOG.unableToInstantiateUuidGenerationStrategy(ignore);
                }
            }
            catch (ClassLoadingException ignore) {
                LOG.unableToLocateUuidGenerationStrategy(strategyClassName);
            }
        }
        if (this.strategy == null) {
            this.strategy = StandardRandomStrategy.INSTANCE;
        }
        if (UUID.class.isAssignableFrom(javaTypeDescriptor.getJavaType())) {
            this.valueTransformer = UUIDJavaDescriptor.PassThroughTransformer.INSTANCE;
        } else if (String.class.isAssignableFrom(javaTypeDescriptor.getJavaType())) {
            this.valueTransformer = UUIDJavaDescriptor.ToStringTransformer.INSTANCE;
        } else if (byte[].class.isAssignableFrom(javaTypeDescriptor.getJavaType())) {
            this.valueTransformer = UUIDJavaDescriptor.ToBytesTransformer.INSTANCE;
        } else {
            throw new HibernateException("Unanticipated return type [" + javaTypeDescriptor.getJavaType().getName() + "] for UUID conversion");
        }
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        return this.valueTransformer.transform(this.strategy.generateUUID(session));
    }
}

