/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.AbstractScrollableResults;
import org.hibernate.sql.results.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.values.JdbcValues;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowReader;

public class FetchingScrollableResultsImpl<R>
extends AbstractScrollableResults<R> {
    private R currentRow;
    private int currentPosition;
    private Integer maxPosition;

    public FetchingScrollableResultsImpl(JdbcValues jdbcValues, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader, SharedSessionContractImplementor persistenceContext) {
        super(jdbcValues, processingOptions, jdbcValuesSourceProcessingState, rowProcessingState, rowReader, persistenceContext);
        this.maxPosition = jdbcValuesSourceProcessingState.getQueryOptions().getEffectiveLimit().getMaxRows();
    }

    @Override
    protected R getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public boolean scroll(int i) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean next() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean previous() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean last() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean first() {
        this.beforeFirst();
        boolean more = this.next();
        this.afterScrollOperation();
        return more;
    }

    @Override
    public void beforeFirst() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public void afterLast() {
        this.last();
        this.next();
        this.afterScrollOperation();
    }

    @Override
    public boolean isFirst() {
        return this.currentPosition == 1;
    }

    @Override
    public boolean isLast() {
        return this.maxPosition != null && this.currentPosition == this.maxPosition;
    }

    @Override
    public int getRowNumber() {
        return this.currentPosition;
    }

    @Override
    public boolean setRowNumber(int rowNumber) {
        if (rowNumber == 1) {
            return this.first();
        }
        if (rowNumber == -1) {
            return this.last();
        }
        if (this.maxPosition != null && rowNumber == this.maxPosition) {
            return this.last();
        }
        return this.scroll(rowNumber - this.currentPosition);
    }
}

