/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.SynchronizationType;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EmptyInterceptor;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.Metamodel;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.Settings;
import org.hibernate.context.internal.JTASessionContext;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.context.internal.ThreadLocalSessionContext;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionOwner;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.internal.reader.AuditReaderImpl;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryObserverChain;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.internal.SessionImpl;
import org.hibernate.internal.SessionOwnerBehavior;
import org.hibernate.internal.StatelessSessionImpl;
import org.hibernate.internal.util.config.ConfigurationException;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.internal.AfterCompletionActionLegacyJpaImpl;
import org.hibernate.jpa.internal.ExceptionMapperLegacyJpaImpl;
import org.hibernate.jpa.internal.ManagedFlushCheckerLegacyJpaImpl;
import org.hibernate.jpa.internal.PersistenceUnitUtilImpl;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.RootClass;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.spi.HqlQueryImplementor;
import org.hibernate.query.spi.NativeQueryImplementor;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.AfterCompletionAction;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.ExceptionMapper;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.ManagedFlushChecker;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.secure.spi.GrantedPermission;
import org.hibernate.secure.spi.JaccPermissionDeclarations;
import org.hibernate.secure.spi.JaccService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistryFactory;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.tool.schema.spi.DelayedDropAction;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public final class SessionFactoryImpl
implements SessionFactoryImplementor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(SessionFactoryImpl.class);
    private final String name;
    private final String uuid;
    private volatile transient boolean isClosed;
    private final transient SessionFactoryObserverChain observer = new SessionFactoryObserverChain();
    private final transient SessionFactoryOptions sessionFactoryOptions;
    private final transient Settings settings;
    private final transient Map<String, Object> properties;
    private final transient SessionFactoryServiceRegistry serviceRegistry;
    private final transient JdbcServices jdbcServices;
    private final transient SqmFunctionRegistry sqmFunctionRegistry;
    private final transient TypeConfiguration typeConfiguration;
    private final transient MetamodelImplementor metamodel;
    private final transient PersistenceUnitUtil jpaPersistenceUnitUtil;
    private final transient CacheImplementor cacheEngine;
    private final transient QueryEngine queryEngine;
    private final transient CurrentSessionContext currentSessionContext;
    private volatile DelayedDropAction delayedDropAction;
    private final transient Map<String, IdentifierGenerator> identifierGenerators;
    private final transient Map<String, FilterDefinition> filters;
    private final transient Map<String, FetchProfile> fetchProfiles;
    private transient StatisticsImplementor statistics;
    private transient SynchronizationType synchronizationType;
    private transient PersistenceContextType persistenceContextType;

    public SessionFactoryImpl(BootstrapContext bootstrapContext, MetadataImplementor metadata, SessionFactoryOptions options) {
        LOG.debug("Building session factory");
        this.sessionFactoryOptions = options;
        this.settings = new Settings(options, metadata);
        this.serviceRegistry = options.getServiceRegistry().getService(SessionFactoryServiceRegistryFactory.class).buildServiceRegistry(this, bootstrapContext, options);
        CfgXmlAccessService cfgXmlAccessService = this.serviceRegistry.getService(CfgXmlAccessService.class);
        String sfName = this.settings.getSessionFactoryName();
        if (cfgXmlAccessService.getAggregatedConfig() != null) {
            if (sfName == null) {
                sfName = cfgXmlAccessService.getAggregatedConfig().getSessionFactoryName();
            }
            this.applyCfgXmlValues(cfgXmlAccessService.getAggregatedConfig(), this.serviceRegistry);
        }
        this.name = sfName;
        this.uuid = options.getUuid();
        this.jdbcServices = this.serviceRegistry.getService(JdbcServices.class);
        this.properties = new HashMap<String, Object>();
        this.properties.putAll(this.serviceRegistry.getService(ConfigurationService.class).getSettings());
        if (!this.properties.containsKey("javax.persistence.validation.factory") && this.getSessionFactoryOptions().getValidatorFactoryReference() != null) {
            this.properties.put("javax.persistence.validation.factory", this.getSessionFactoryOptions().getValidatorFactoryReference());
        }
        this.maskOutSensitiveInformation(this.properties);
        this.logIfEmptyCompositesEnabled(this.properties);
        this.cacheEngine = this.serviceRegistry.getService(CacheImplementor.class);
        this.jpaPersistenceUnitUtil = new PersistenceUnitUtilImpl(this);
        for (SessionFactoryObserver sessionFactoryObserver : options.getSessionFactoryObservers()) {
            this.observer.addObserver(sessionFactoryObserver);
        }
        this.filters = new HashMap<String, FilterDefinition>();
        this.filters.putAll(metadata.getFilterDefinitions());
        LOG.debugf("Session factory constructed with filter configurations : %s", this.filters);
        LOG.debugf("Instantiating session factory with properties: %s", this.properties);
        class IntegratorObserver
        implements SessionFactoryObserver {
            private ArrayList<Integrator> integrators = new ArrayList();

            IntegratorObserver() {
            }

            @Override
            public void sessionFactoryCreated(SessionFactory factory) {
            }

            @Override
            public void sessionFactoryClosed(SessionFactory factory) {
                for (Integrator integrator : this.integrators) {
                    integrator.disintegrate(SessionFactoryImpl.this, SessionFactoryImpl.this.serviceRegistry);
                }
                this.integrators.clear();
            }
        }
        IntegratorObserver integratorObserver = new IntegratorObserver();
        this.observer.addObserver(integratorObserver);
        try {
            for (Integrator integrator : this.serviceRegistry.getService(IntegratorService.class).getIntegrators()) {
                integrator.integrate(metadata, this, this.serviceRegistry);
                integratorObserver.integrators.add(integrator);
            }
            IdentifierGeneratorFactory identifierGeneratorFactory = this.serviceRegistry.getService(MutableIdentifierGeneratorFactory.class);
            this.identifierGenerators = new HashMap<String, IdentifierGenerator>();
            metadata.getEntityMappings().stream().filter(entityMapping -> entityMapping.getEntityMappingHierarchy().getRootType().equals(entityMapping)).map(RootClass.class::cast).forEach(rootClass -> {
                IdentifierGenerator generator = rootClass.getIdentifier().createIdentifierGenerator(identifierGeneratorFactory, this.jdbcServices.getJdbcEnvironment().getDialect(), this.settings.getDefaultCatalogName(), this.settings.getDefaultSchemaName(), (RootClass)rootClass);
                this.identifierGenerators.put(rootClass.getEntityName(), generator);
            });
            LOG.debug("Instantiated session factory");
            this.typeConfiguration = metadata.getTypeConfiguration();
            this.metamodel = this.typeConfiguration.scope(this, bootstrapContext);
            this.prepareEventListeners(this.metamodel);
            this.sqmFunctionRegistry = new SqmFunctionRegistry();
            this.jdbcServices.getDialect().initializeFunctionRegistry(this.sqmFunctionRegistry);
            this.sessionFactoryOptions.getSqmFunctionRegistry().overlay(this.sqmFunctionRegistry);
            this.queryEngine = new QueryEngine(this, metadata.buildNamedQueryRepository(this), this.sqmFunctionRegistry);
            JdbcConnectionAccess jdbcConnectionAccess = this.buildLocalConnectionAccess();
            this.metamodel.visitEntityHierarchies(hierarchy -> hierarchy.getSqmMutationStrategy().prepare(this.metamodel, this.sessionFactoryOptions, jdbcConnectionAccess));
            this.currentSessionContext = this.buildCurrentSessionContext();
            this.fetchProfiles = new HashMap<String, FetchProfile>();
            for (org.hibernate.mapping.FetchProfile mappingProfile : metadata.getFetchProfiles()) {
                FetchProfile fetchProfile = new FetchProfile(mappingProfile.getName());
                for (FetchProfile.Fetch mappingFetch : mappingProfile.getFetches()) {
                    EntityTypeDescriptor owner = this.metamodel.findEntityDescriptor(mappingFetch.getEntity());
                    if (owner == null) {
                        throw new HibernateException("Unable to resolve entity reference [" + mappingFetch.getEntity() + "] in fetch profile [" + fetchProfile.getName() + "]");
                    }
                    PersistentAttributeDescriptor attribute = owner.getAttribute(mappingFetch.getAssociation());
                    if (!Fetchable.class.isInstance(attribute)) {
                        throw new HibernateException("Fetch profile [" + fetchProfile.getName() + "] specified an invalid association");
                    }
                    Fetch.Style fetchStyle = Fetch.Style.parse(mappingFetch.getStyle());
                    fetchProfile.addFetch(new Association(owner, mappingFetch.getAssociation()), fetchStyle);
                    owner.registerAffectingFetchProfile(fetchProfile.getName());
                }
                this.fetchProfiles.put(fetchProfile.getName(), fetchProfile);
            }
            this.observer.sessionFactoryCreated(this);
            SessionFactoryRegistry.INSTANCE.addSessionFactory(this.getUuid(), this.name, this.settings.isSessionFactoryNameAlsoJndiName(), this, this.serviceRegistry.getService(JndiService.class));
        }
        catch (Exception e) {
            for (Integrator integrator : this.serviceRegistry.getService(IntegratorService.class).getIntegrators()) {
                integrator.disintegrate(this, this.serviceRegistry);
                integratorObserver.integrators.remove(integrator);
            }
            this.close();
            throw e;
        }
    }

    private void prepareEventListeners(Metamodel metamodel) {
        EventListenerRegistry eventListenerRegistry = this.serviceRegistry.getService(EventListenerRegistry.class);
        ConfigurationService cfgService = this.serviceRegistry.getService(ConfigurationService.class);
        ClassLoaderService classLoaderService = this.serviceRegistry.getService(ClassLoaderService.class);
        eventListenerRegistry.prepare(metamodel);
        for (Map.Entry entry : cfgService.getSettings().entrySet()) {
            String propertyName;
            if (!String.class.isInstance(entry.getKey()) || !(propertyName = (String)entry.getKey()).startsWith("hibernate.ejb.event")) continue;
            String eventTypeName = propertyName.substring("hibernate.ejb.event".length() + 1);
            EventType eventType = EventType.resolveEventTypeByName(eventTypeName);
            EventListenerGroup<Object> eventListenerGroup = eventListenerRegistry.getEventListenerGroup(eventType);
            for (String listenerImpl : ((String)entry.getValue()).split(" ,")) {
                eventListenerGroup.appendListener(this.instantiate(listenerImpl, classLoaderService));
            }
        }
    }

    private Object instantiate(String listenerImpl, ClassLoaderService classLoaderService) {
        try {
            return classLoaderService.classForName(listenerImpl).newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate requested listener [" + listenerImpl + "]", e);
        }
    }

    private void applyCfgXmlValues(LoadedConfig aggregatedConfig, SessionFactoryServiceRegistry serviceRegistry) {
        JaccPermissionDeclarations permissions;
        JaccService jaccService = serviceRegistry.getService(JaccService.class);
        if (jaccService.getContextId() != null && (permissions = aggregatedConfig.getJaccPermissions(jaccService.getContextId())) != null) {
            for (GrantedPermission grantedPermission : permissions.getPermissionDeclarations()) {
                jaccService.addPermission(grantedPermission);
            }
        }
        if (aggregatedConfig.getEventListenerMap() != null) {
            ClassLoaderService cls = serviceRegistry.getService(ClassLoaderService.class);
            EventListenerRegistry eventListenerRegistry = serviceRegistry.getService(EventListenerRegistry.class);
            for (Map.Entry<EventType, Set<String>> entry : aggregatedConfig.getEventListenerMap().entrySet()) {
                EventListenerGroup group = eventListenerRegistry.getEventListenerGroup(entry.getKey());
                for (String listenerClassName : entry.getValue()) {
                    try {
                        group.appendListener(cls.classForName(listenerClassName).newInstance());
                    }
                    catch (Exception e) {
                        throw new ConfigurationException("Unable to instantiate event listener class : " + listenerClassName, e);
                    }
                }
            }
        }
    }

    private JdbcConnectionAccess buildLocalConnectionAccess() {
        return new JdbcConnectionAccess(){

            @Override
            public Connection obtainConnection() throws SQLException {
                return !SessionFactoryImpl.this.settings.getMultiTenancyStrategy().requiresMultiTenantConnectionProvider() ? SessionFactoryImpl.this.serviceRegistry.getService(ConnectionProvider.class).getConnection() : SessionFactoryImpl.this.serviceRegistry.getService(MultiTenantConnectionProvider.class).getAnyConnection();
            }

            @Override
            public void releaseConnection(Connection connection) throws SQLException {
                if (!SessionFactoryImpl.this.settings.getMultiTenancyStrategy().requiresMultiTenantConnectionProvider()) {
                    SessionFactoryImpl.this.serviceRegistry.getService(ConnectionProvider.class).closeConnection(connection);
                } else {
                    SessionFactoryImpl.this.serviceRegistry.getService(MultiTenantConnectionProvider.class).releaseAnyConnection(connection);
                }
            }

            @Override
            public boolean supportsAggressiveRelease() {
                return false;
            }
        };
    }

    @Override
    public QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    @Override
    public Session openSession() throws HibernateException {
        return this.withOptions().openSession();
    }

    @Override
    public Session openTemporarySession() throws HibernateException {
        return this.withOptions().autoClose(false).flushMode(FlushMode.MANUAL).connectionHandlingMode(PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_RELEASE_AFTER_STATEMENT).openSession();
    }

    @Override
    public Session getCurrentSession() throws HibernateException {
        if (this.currentSessionContext == null) {
            throw new HibernateException("No CurrentSessionContext configured!");
        }
        return this.currentSessionContext.currentSession();
    }

    @Override
    public SessionBuilderImplementor withOptions() {
        return new SessionBuilderImpl(this);
    }

    @Override
    public StatelessSessionBuilder withStatelessOptions() {
        return new StatelessSessionBuilderImpl(this);
    }

    @Override
    public StatelessSession openStatelessSession() {
        return this.withStatelessOptions().openStatelessSession();
    }

    @Override
    public StatelessSession openStatelessSession(Connection connection) {
        return this.withStatelessOptions().connection(connection).openStatelessSession();
    }

    @Override
    public void addObserver(SessionFactoryObserver observer) {
        this.observer.addObserver(observer);
    }

    public Map<String, Object> getProperties() {
        this.validateNotClosed();
        return this.properties;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    protected void validateNotClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("EntityManagerFactory is closed");
        }
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.jdbcServices;
    }

    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return null;
    }

    @Override
    public SessionFactoryImplementor.DeserializationResolver getDeserializationResolver() {
        return new SessionFactoryImplementor.DeserializationResolver(){

            public SessionFactoryImplementor resolve() {
                return (SessionFactoryImplementor)SessionFactoryRegistry.INSTANCE.findSessionFactory(SessionFactoryImpl.this.uuid, SessionFactoryImpl.this.name);
            }
        };
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public <T> List<RootGraphImplementor<? super T>> findEntityGraphsByJavaType(Class<T> entityClass) {
        return this.getMetamodel().findEntityGraphsByJavaType(entityClass);
    }

    public Session createEntityManager() {
        this.validateNotClosed();
        return this.buildEntityManager(SynchronizationType.SYNCHRONIZED, Collections.emptyMap());
    }

    private Session buildEntityManager(SynchronizationType synchronizationType, Map map) {
        assert (!this.isClosed);
        SessionBuilderImplementor builder = this.withOptions();
        if (synchronizationType == SynchronizationType.SYNCHRONIZED) {
            builder.autoJoinTransactions(true);
        } else {
            builder.autoJoinTransactions(false);
        }
        Session session = builder.openSession();
        if (map != null) {
            map.keySet().forEach(key -> {
                if (key instanceof String) {
                    session.setProperty((String)key, map.get(key));
                }
            });
        }
        return session;
    }

    public Session createEntityManager(Map map) {
        this.validateNotClosed();
        return this.buildEntityManager(SynchronizationType.SYNCHRONIZED, map);
    }

    public Session createEntityManager(SynchronizationType synchronizationType) {
        this.validateNotClosed();
        this.errorIfResourceLocalDueToExplicitSynchronizationType();
        return this.buildEntityManager(synchronizationType, Collections.emptyMap());
    }

    private void errorIfResourceLocalDueToExplicitSynchronizationType() {
        if (!this.getServiceRegistry().getService(TransactionCoordinatorBuilder.class).isJta()) {
            throw new IllegalStateException("Illegal attempt to specify a SynchronizationType when building an EntityManager from a EntityManagerFactory defined as RESOURCE_LOCAL (as opposed to JTA)");
        }
    }

    public Session createEntityManager(SynchronizationType synchronizationType, Map map) {
        this.validateNotClosed();
        this.errorIfResourceLocalDueToExplicitSynchronizationType();
        return this.buildEntityManager(synchronizationType, map);
    }

    @Override
    public HibernateCriteriaBuilder getCriteriaBuilder() {
        this.validateNotClosed();
        return this.queryEngine.getCriteriaBuilder();
    }

    @Override
    public MetamodelImplementor getMetamodel() {
        this.validateNotClosed();
        return this.metamodel;
    }

    public boolean isOpen() {
        return !this.isClosed;
    }

    public RootGraphImplementor findEntityGraphByName(String name) {
        return this.getMetamodel().findEntityGraphByName(name);
    }

    @Override
    public SessionFactoryOptions getSessionFactoryOptions() {
        return this.sessionFactoryOptions;
    }

    @Override
    public Interceptor getInterceptor() {
        return this.sessionFactoryOptions.getInterceptor();
    }

    @Override
    public Reference getReference() {
        LOG.debug("Returning a Reference to the SessionFactory");
        return new Reference(SessionFactoryImpl.class.getName(), new StringRefAddr("uuid", this.getUuid()), SessionFactoryRegistry.ObjectFactoryImpl.class.getName(), null);
    }

    public Type getIdentifierType(String className) throws MappingException {
        return this.getMetamodel().findEntityDescriptor(className).getIdentifierType();
    }

    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.getMetamodel().findEntityDescriptor(className).getIdentifierPropertyName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HibernateException {
        Environment.getBytecodeProvider().resetCaches();
        SessionFactoryImpl sessionFactoryImpl = this;
        synchronized (sessionFactoryImpl) {
            if (this.isClosed) {
                if (this.getSessionFactoryOptions().getJpaCompliance().isJpaClosedComplianceEnabled()) {
                    throw new IllegalStateException("EntityManagerFactory is already closed");
                }
                LOG.trace("Already closed");
                return;
            }
            this.isClosed = true;
        }
        LOG.closing();
        this.observer.sessionFactoryClosing(this);
        if (this.queryEngine != null) {
            this.queryEngine.close();
        }
        if (this.cacheEngine != null) {
            this.cacheEngine.close();
        }
        if (this.metamodel != null) {
            JdbcConnectionAccess jdbcConnectionAccess = this.buildLocalConnectionAccess();
            this.metamodel.visitEntityHierarchies(hierarchy -> hierarchy.getSqmMutationStrategy().release(this.metamodel, jdbcConnectionAccess));
            this.metamodel.close();
        }
        if (this.delayedDropAction != null) {
            this.delayedDropAction.perform(this.serviceRegistry);
        }
        SessionFactoryRegistry.INSTANCE.removeSessionFactory(this.getUuid(), this.name, this.settings.isSessionFactoryNameAlsoJndiName(), this.serviceRegistry.getService(JndiService.class));
        this.isClosed = true;
        this.observer.sessionFactoryClosed(this);
        this.serviceRegistry.destroy();
    }

    @Override
    public CacheImplementor getCache() {
        this.validateNotClosed();
        return this.cacheEngine;
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        this.validateNotClosed();
        return this.jpaPersistenceUnitUtil;
    }

    public void addNamedQuery(String name, Query query) {
        this.validateNotClosed();
        try {
            ProcedureCallImplementor unwrapped = (ProcedureCallImplementor)query.unwrap(ProcedureCallImplementor.class);
            if (unwrapped != null) {
                this.getQueryEngine().getNamedQueryRepository().registerCallableQueryMemento(name, unwrapped.toMemento(name, this));
                return;
            }
        }
        catch (PersistenceException unwrapped) {
            // empty catch block
        }
        try {
            HqlQueryImplementor hqlQuery = (HqlQueryImplementor)query.unwrap(HqlQueryImplementor.class);
            if (hqlQuery != null) {
                this.getQueryEngine().getNamedQueryRepository().registerHqlQueryMemento(name, hqlQuery.toMemento(name, this));
                return;
            }
        }
        catch (PersistenceException hqlQuery) {
            // empty catch block
        }
        try {
            NativeQueryImplementor nativeQuery = (NativeQueryImplementor)query.unwrap(NativeQueryImplementor.class);
            if (nativeQuery != null) {
                this.getQueryEngine().getNamedQueryRepository().registerNativeQueryMemento(name, nativeQuery.toMemento(name, this));
                return;
            }
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        throw new PersistenceException(String.format("Unsure how to how to properly unwrap given Query [%s] as basis for named query", query));
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(SessionFactory.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(SessionFactoryImplementor.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(SessionFactoryImpl.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(EntityManagerFactory.class)) {
            return type.cast(this);
        }
        throw new PersistenceException("Hibernate cannot unwrap EntityManagerFactory as '" + type.getName() + "'");
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.getMetamodel().addNamedEntityGraph(graphName, (RootGraphImplementor)entityGraph);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public StatisticsImplementor getStatistics() {
        if (this.statistics == null) {
            this.statistics = this.serviceRegistry.getService(StatisticsImplementor.class);
        }
        return this.statistics;
    }

    @Override
    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        FilterDefinition def = this.filters.get(filterName);
        if (def == null) {
            throw new HibernateException("No such filter configured [" + filterName + "]");
        }
        return def;
    }

    @Override
    public boolean containsFetchProfileDefinition(String name) {
        return this.fetchProfiles.containsKey(name);
    }

    @Override
    public Set getDefinedFilterNames() {
        return this.filters.keySet();
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator(String rootEntityName) {
        return this.identifierGenerators.get(rootEntityName);
    }

    private boolean canAccessTransactionManager() {
        try {
            return this.serviceRegistry.getService(JtaPlatform.class).retrieveTransactionManager() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private CurrentSessionContext buildCurrentSessionContext() {
        String impl = (String)this.properties.get("hibernate.current_session_context_class");
        if (impl == null) {
            if (this.canAccessTransactionManager()) {
                impl = "jta";
            } else {
                return null;
            }
        }
        if ("jta".equals(impl)) {
            return new JTASessionContext(this);
        }
        if ("thread".equals(impl)) {
            return new ThreadLocalSessionContext(this);
        }
        if ("managed".equals(impl)) {
            return new ManagedSessionContext(this);
        }
        try {
            Class implClass = this.serviceRegistry.getService(ClassLoaderService.class).classForName(impl);
            return (CurrentSessionContext)implClass.getConstructor(SessionFactoryImplementor.class).newInstance(this);
        }
        catch (Throwable t) {
            LOG.unableToConstructCurrentSessionContext(impl, t);
            return null;
        }
    }

    @Override
    public ServiceRegistryImplementor getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.sessionFactoryOptions.getEntityNotFoundDelegate();
    }

    @Override
    public SqmFunctionRegistry getSqmFunctionRegistry() {
        return this.sqmFunctionRegistry;
    }

    @Override
    public FetchProfile getFetchProfile(String name) {
        return this.fetchProfiles.get(name);
    }

    @Override
    public AllowableParameterType resolveParameterBindType(Object bindValue) {
        if (bindValue == null) {
            return null;
        }
        return this.resolveParameterBindType(HibernateProxyHelper.getClassWithoutInitializingProxy(bindValue));
    }

    @Override
    public AllowableParameterType resolveParameterBindType(Class clazz) {
        return this.getMetamodel().resolveAllowableParamterType(clazz);
    }

    @Override
    public AuditReader openAuditReader() {
        return new AuditReaderImpl(this.openSession(), true);
    }

    public static Interceptor configuredInterceptor(Interceptor interceptor, SessionFactoryOptions options) {
        if (interceptor != null && interceptor != EmptyInterceptor.INSTANCE) {
            return interceptor;
        }
        if (options.getInterceptor() != null && options.getInterceptor() != EmptyInterceptor.INSTANCE) {
            return options.getInterceptor();
        }
        if (options.getStatelessInterceptorImplementor() != null && options.getStatelessInterceptorImplementorSupplier() != null) {
            throw new HibernateException("A session scoped interceptor class or supplier are allowed, but not both!");
        }
        if (options.getStatelessInterceptorImplementor() != null) {
            try {
                return options.getStatelessInterceptorImplementor().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new HibernateException("Could not supply session-scoped SessionFactory Interceptor", e);
            }
        }
        if (options.getStatelessInterceptorImplementorSupplier() != null) {
            return options.getStatelessInterceptorImplementorSupplier().get();
        }
        return null;
    }

    @Override
    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.getSessionFactoryOptions().getCustomEntityDirtinessStrategy();
    }

    @Override
    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.getSessionFactoryOptions().getCurrentTenantIdentifierResolver();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        LOG.debugf("Serializing: %s", this.getUuid());
        out.defaultWriteObject();
        LOG.trace("Serialized");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing");
        in.defaultReadObject();
        LOG.debugf("Deserialized: %s", this.getUuid());
    }

    private Object readResolve() throws InvalidObjectException {
        LOG.trace("Resolving serialized SessionFactory");
        return SessionFactoryImpl.locateSessionFactoryOnDeserialization(this.getUuid(), this.name);
    }

    private static SessionFactory locateSessionFactoryOnDeserialization(String uuid, String name) throws InvalidObjectException {
        SessionFactory namedResult;
        SessionFactory uuidResult = SessionFactoryRegistry.INSTANCE.getSessionFactory(uuid);
        if (uuidResult != null) {
            LOG.debugf("Resolved SessionFactory by UUID [%s]", uuid);
            return uuidResult;
        }
        if (name != null && (namedResult = SessionFactoryRegistry.INSTANCE.getNamedSessionFactory(name)) != null) {
            LOG.debugf("Resolved SessionFactory by name [%s]", name);
            return namedResult;
        }
        throw new InvalidObjectException("Could not find a SessionFactory [uuid=" + uuid + ",name=" + name + "]");
    }

    void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.getUuid());
        oos.writeBoolean(this.name != null);
        if (this.name != null) {
            oos.writeUTF(this.name);
        }
    }

    static SessionFactoryImpl deserialize(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing SessionFactory from Session");
        String uuid = ois.readUTF();
        boolean isNamed = ois.readBoolean();
        String name = isNamed ? ois.readUTF() : null;
        return (SessionFactoryImpl)SessionFactoryImpl.locateSessionFactoryOnDeserialization(uuid, name);
    }

    private void maskOutSensitiveInformation(Map<String, Object> props) {
        this.maskOutIfSet(props, "javax.persistence.jdbc.user");
        this.maskOutIfSet(props, "javax.persistence.jdbc.password");
        this.maskOutIfSet(props, "hibernate.connection.username");
        this.maskOutIfSet(props, "hibernate.connection.password");
    }

    private void maskOutIfSet(Map<String, Object> props, String setting) {
        if (props.containsKey(setting)) {
            props.put(setting, "****");
        }
    }

    private void logIfEmptyCompositesEnabled(Map<String, Object> props) {
        boolean isEmptyCompositesEnabled = ConfigurationHelper.getBoolean("hibernate.create_empty_composites.enabled", props, false);
        if (isEmptyCompositesEnabled) {
            LOG.emptyCompositesEnabled();
        }
    }

    public static class StatelessSessionBuilderImpl
    implements StatelessSessionBuilder,
    SessionCreationOptions {
        private final SessionFactoryImpl sessionFactory;
        private Connection connection;
        private String tenantIdentifier;
        private boolean queryParametersValidationEnabled;

        public StatelessSessionBuilderImpl(SessionFactoryImpl sessionFactory) {
            this.sessionFactory = sessionFactory;
            if (sessionFactory.getCurrentTenantIdentifierResolver() != null) {
                this.tenantIdentifier = sessionFactory.getCurrentTenantIdentifierResolver().resolveCurrentTenantIdentifier();
            }
            this.queryParametersValidationEnabled = sessionFactory.getSessionFactoryOptions().isQueryParametersValidationEnabled();
        }

        @Override
        public StatelessSession openStatelessSession() {
            return new StatelessSessionImpl(this.sessionFactory, this);
        }

        public StatelessSessionBuilder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        public StatelessSessionBuilder tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }

        @Override
        public boolean shouldAutoJoinTransactions() {
            return true;
        }

        @Override
        public FlushMode getInitialSessionFlushMode() {
            return FlushMode.ALWAYS;
        }

        @Override
        public boolean shouldAutoClose() {
            return false;
        }

        @Override
        public boolean shouldAutoClear() {
            return false;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public Interceptor getInterceptor() {
            return SessionFactoryImpl.configuredInterceptor(EmptyInterceptor.INSTANCE, this.sessionFactory.getSessionFactoryOptions());
        }

        @Override
        public StatementInspector getStatementInspector() {
            return null;
        }

        @Override
        public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
            return null;
        }

        @Override
        public String getTenantIdentifier() {
            return this.tenantIdentifier;
        }

        @Override
        public TimeZone getJdbcTimeZone() {
            return this.sessionFactory.getSessionFactoryOptions().getJdbcTimeZone();
        }

        @Override
        public SessionOwner getSessionOwner() {
            return null;
        }

        @Override
        public ExceptionMapper getExceptionMapper() {
            return null;
        }

        @Override
        public AfterCompletionAction getAfterCompletionAction() {
            return null;
        }

        @Override
        public ManagedFlushChecker getManagedFlushChecker() {
            return null;
        }

        @Override
        public boolean isQueryParametersValidationEnabled() {
            return this.queryParametersValidationEnabled;
        }

        public StatelessSessionBuilder setQueryParameterValidation(boolean enabled) {
            this.queryParametersValidationEnabled = enabled;
            return this;
        }
    }

    static class SessionBuilderImpl<T extends SessionBuilder>
    implements SessionBuilderImplementor<T>,
    SessionCreationOptions {
        private static final Logger log = CoreLogging.logger(SessionBuilderImpl.class);
        private final SessionFactoryImpl sessionFactory;
        private SessionOwner sessionOwner;
        private Interceptor interceptor;
        private StatementInspector statementInspector;
        private Connection connection;
        private PhysicalConnectionHandlingMode connectionHandlingMode;
        private boolean autoJoinTransactions = true;
        private FlushMode flushMode;
        private boolean autoClose;
        private boolean autoClear;
        private String tenantIdentifier;
        private TimeZone jdbcTimeZone;
        private boolean queryParametersValidationEnabled;
        private List<SessionEventListener> listeners;
        private SessionOwnerBehavior sessionOwnerBehavior = SessionOwnerBehavior.LEGACY_NATIVE;
        private PersistenceUnitTransactionType persistenceUnitTransactionType;

        SessionBuilderImpl(SessionFactoryImpl sessionFactory) {
            this.sessionFactory = sessionFactory;
            this.sessionOwner = null;
            this.statementInspector = sessionFactory.getSessionFactoryOptions().getStatementInspector();
            this.connectionHandlingMode = sessionFactory.getSessionFactoryOptions().getPhysicalConnectionHandlingMode();
            this.autoClose = sessionFactory.getSessionFactoryOptions().isAutoCloseSessionEnabled();
            FlushMode flushMode = this.flushMode = sessionFactory.getSessionFactoryOptions().isFlushBeforeCompletionEnabled() ? FlushMode.AUTO : FlushMode.MANUAL;
            if (sessionFactory.getCurrentTenantIdentifierResolver() != null) {
                this.tenantIdentifier = sessionFactory.getCurrentTenantIdentifierResolver().resolveCurrentTenantIdentifier();
            }
            this.jdbcTimeZone = sessionFactory.getSessionFactoryOptions().getJdbcTimeZone();
            this.listeners = sessionFactory.getSessionFactoryOptions().getBaselineSessionEventsListenerBuilder().buildBaselineList();
            this.queryParametersValidationEnabled = sessionFactory.getSessionFactoryOptions().isQueryParametersValidationEnabled();
        }

        @Override
        public SessionOwner getSessionOwner() {
            return this.sessionOwner;
        }

        @Override
        public ExceptionMapper getExceptionMapper() {
            if (this.sessionOwner != null) {
                return this.sessionOwner.getExceptionMapper();
            }
            return this.sessionOwnerBehavior == SessionOwnerBehavior.LEGACY_JPA ? ExceptionMapperLegacyJpaImpl.INSTANCE : null;
        }

        @Override
        public AfterCompletionAction getAfterCompletionAction() {
            if (this.sessionOwner != null) {
                return this.sessionOwner.getAfterCompletionAction();
            }
            return this.sessionOwnerBehavior == SessionOwnerBehavior.LEGACY_JPA ? AfterCompletionActionLegacyJpaImpl.INSTANCE : null;
        }

        @Override
        public ManagedFlushChecker getManagedFlushChecker() {
            if (this.sessionOwner != null) {
                return this.sessionOwner.getManagedFlushChecker();
            }
            return this.sessionOwnerBehavior == SessionOwnerBehavior.LEGACY_JPA ? ManagedFlushCheckerLegacyJpaImpl.INSTANCE : null;
        }

        @Override
        public boolean isQueryParametersValidationEnabled() {
            return this.queryParametersValidationEnabled;
        }

        @Override
        public boolean shouldAutoJoinTransactions() {
            return this.autoJoinTransactions;
        }

        @Override
        public FlushMode getInitialSessionFlushMode() {
            return this.flushMode;
        }

        @Override
        public boolean shouldAutoClose() {
            return this.autoClose;
        }

        @Override
        public boolean shouldAutoClear() {
            return this.autoClear;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public Interceptor getInterceptor() {
            return SessionFactoryImpl.configuredInterceptor(this.interceptor, this.sessionFactory.getSessionFactoryOptions());
        }

        @Override
        public StatementInspector getStatementInspector() {
            return this.statementInspector;
        }

        @Override
        public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
            return this.connectionHandlingMode;
        }

        @Override
        public String getTenantIdentifier() {
            return this.tenantIdentifier;
        }

        @Override
        public TimeZone getJdbcTimeZone() {
            return this.jdbcTimeZone;
        }

        @Override
        public Session openSession() {
            log.tracef("Opening Hibernate Session.  tenant=%s, owner=%s", (Object)this.tenantIdentifier, (Object)this.sessionOwner);
            SessionImpl session = new SessionImpl(this.sessionFactory, this);
            for (SessionEventListener listener : this.listeners) {
                session.getEventListenerManager().addListener(listener);
            }
            return session;
        }

        @Override
        public T owner(SessionOwner sessionOwner) {
            this.sessionOwner = sessionOwner;
            return (T)this;
        }

        @Override
        public T interceptor(Interceptor interceptor) {
            this.interceptor = interceptor;
            return (T)this;
        }

        @Override
        public T noInterceptor() {
            this.interceptor = EmptyInterceptor.INSTANCE;
            return (T)this;
        }

        @Override
        public T statementInspector(StatementInspector statementInspector) {
            this.statementInspector = statementInspector;
            return (T)this;
        }

        @Override
        public T connection(Connection connection) {
            this.connection = connection;
            return (T)this;
        }

        @Override
        public T connectionReleaseMode(ConnectionReleaseMode connectionReleaseMode) {
            PhysicalConnectionHandlingMode handlingMode = PhysicalConnectionHandlingMode.interpret(ConnectionAcquisitionMode.AS_NEEDED, connectionReleaseMode);
            this.connectionHandlingMode(handlingMode);
            return (T)this;
        }

        @Override
        public T connectionHandlingMode(PhysicalConnectionHandlingMode connectionHandlingMode) {
            this.connectionHandlingMode = connectionHandlingMode;
            return (T)this;
        }

        @Override
        public T autoJoinTransactions(boolean autoJoinTransactions) {
            this.autoJoinTransactions = autoJoinTransactions;
            return (T)this;
        }

        @Override
        public T autoClose(boolean autoClose) {
            this.autoClose = autoClose;
            return (T)this;
        }

        @Override
        public T autoClear(boolean autoClear) {
            this.autoClear = autoClear;
            return (T)this;
        }

        @Override
        public T flushMode(FlushMode flushMode) {
            this.flushMode = flushMode;
            return (T)this;
        }

        @Override
        public T tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return (T)this;
        }

        @Override
        public T eventListeners(SessionEventListener ... listeners) {
            Collections.addAll(this.listeners, listeners);
            return (T)this;
        }

        @Override
        public T clearEventListeners() {
            this.listeners.clear();
            return (T)this;
        }

        @Override
        public T jdbcTimeZone(TimeZone timeZone) {
            this.jdbcTimeZone = timeZone;
            return (T)this;
        }

        @Override
        public T setQueryParameterValidation(boolean enabled) {
            this.queryParametersValidationEnabled = enabled;
            return (T)this;
        }
    }
}

