/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.sql.Connection;
import javax.transaction.SystemException;
import org.hibernate.CacheMode;
import org.hibernate.EntityMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.SessionException;
import org.hibernate.StatelessSession;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;
import org.hibernate.metamodel.model.domain.spi.VersionSupport;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;

public class StatelessSessionImpl
extends AbstractSharedSessionContract
implements StatelessSession {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(StatelessSessionImpl.class);
    private static LoadQueryInfluencers NO_INFLUENCERS = new LoadQueryInfluencers(null){

        @Override
        public String getInternalFetchProfile() {
            return null;
        }

        @Override
        public void setInternalFetchProfile(String internalFetchProfile) {
        }
    };
    private PersistenceContext temporaryPersistenceContext = new StatefulPersistenceContext(this);
    private boolean connectionProvided;

    StatelessSessionImpl(SessionFactoryImpl factory, SessionCreationOptions options) {
        super(factory, options);
        this.connectionProvided = options.getConnection() != null;
    }

    @Override
    public boolean shouldAutoJoinTransaction() {
        return true;
    }

    @Override
    public Object insert(Object entity) {
        this.checkOpen();
        return this.insert(null, entity);
    }

    @Override
    public Object insert(String entityName, Object entity) {
        boolean substitute;
        this.checkOpen();
        EntityTypeDescriptor descriptor = this.getEntityDescriptor(entityName, entity);
        Object id = descriptor.getIdentifierDescriptor().getIdentifierValueGenerator().generate(this, entity);
        Object[] state = descriptor.getPropertyValues(entity);
        VersionDescriptor versionDescriptor = descriptor.getHierarchy().getVersionDescriptor();
        if (versionDescriptor != null && (substitute = Versioning.seedVersion(state, versionDescriptor, this))) {
            descriptor.setPropertyValues(entity, state);
        }
        if (id == IdentifierGeneratorHelper.POST_INSERT_INDICATOR) {
            id = descriptor.insert(state, entity, this);
        } else {
            descriptor.insert(id, state, entity, this);
        }
        descriptor.setIdentifier(entity, id, this);
        return id;
    }

    @Override
    public void delete(Object entity) {
        this.checkOpen();
        this.delete(null, entity);
    }

    @Override
    public void delete(String entityName, Object entity) {
        this.checkOpen();
        EntityTypeDescriptor descriptor = this.getEntityDescriptor(entityName, entity);
        Object id = descriptor.getIdentifier(entity);
        Object version = descriptor.getVersion(entity);
        descriptor.delete(id, version, entity, this);
    }

    @Override
    public void update(Object entity) {
        this.checkOpen();
        this.update(null, entity);
    }

    @Override
    public void update(String entityName, Object entity) {
        Object oldVersion;
        this.checkOpen();
        EntityTypeDescriptor entityDescriptor = this.getEntityDescriptor(entityName, entity);
        Object id = entityDescriptor.getHierarchy().getIdentifierDescriptor().extractIdentifier(entity);
        Object[] state = entityDescriptor.getPropertyValues(entity);
        VersionDescriptor versionDescriptor = entityDescriptor.getHierarchy().getVersionDescriptor();
        if (versionDescriptor != null) {
            oldVersion = entityDescriptor.getVersion(entity);
            VersionSupport versionSupport = versionDescriptor.getVersionSupport();
            Object newVersion = Versioning.increment(oldVersion, versionSupport, this);
            Versioning.setVersion(state, newVersion, entityDescriptor);
            entityDescriptor.setPropertyValues(entity, state);
        } else {
            oldVersion = null;
        }
        entityDescriptor.update(id, state, null, false, null, oldVersion, entity, null, this);
    }

    @Override
    public Object get(Class entityClass, Object id) {
        return this.get(entityClass.getName(), id);
    }

    @Override
    public Object get(Class entityClass, Object id, LockMode lockMode) {
        return this.get(entityClass.getName(), id, lockMode);
    }

    @Override
    public Object get(String entityName, Object id) {
        return this.get(entityName, id, LockMode.NONE);
    }

    @Override
    public Object get(String entityName, Object id, LockMode lockMode) {
        this.checkOpen();
        LockOptions lockOptions = new LockOptions(this.getNullSafeLockMode(lockMode));
        Object result = this.getFactory().getMetamodel().findEntityDescriptor(entityName).getSingleIdLoader().load(id, lockOptions, this);
        if (this.temporaryPersistenceContext.isLoadFinished()) {
            this.temporaryPersistenceContext.clear();
        }
        return result;
    }

    @Override
    public void refresh(Object entity) {
        this.refresh(this.bestGuessEntityName(entity), entity, LockMode.NONE);
    }

    @Override
    public void refresh(String entityName, Object entity) {
        this.refresh(entityName, entity, LockMode.NONE);
    }

    @Override
    public void refresh(Object entity, LockMode lockMode) {
        this.refresh(this.bestGuessEntityName(entity), entity, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(String entityName, Object entity, LockMode lockMode) {
        Object result;
        EntityDataAccess cacheAccess;
        EntityTypeDescriptor entityDescriptor = this.getEntityDescriptor(entityName, entity);
        Object id = entityDescriptor.getIdentifier(entity);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Refreshing transient {0}", MessageHelper.infoString(entityDescriptor, id, this.getFactory()));
        }
        if (entityDescriptor.canWriteToCache() && (cacheAccess = entityDescriptor.getHierarchy().getEntityCacheAccess()) != null) {
            Object ck = cacheAccess.generateCacheKey(id, entityDescriptor.getHierarchy(), this.getFactory(), this.getTenantIdentifier());
            cacheAccess.evict(ck);
        }
        LoadQueryInfluencers.InternalFetchProfileType previouslyEnabledInternalFetchProfileType = this.getLoadQueryInfluencers().getEnabledInternalFetchProfileType();
        this.getLoadQueryInfluencers().setEnabledInternalFetchProfileType(LoadQueryInfluencers.InternalFetchProfileType.REFRESH);
        try {
            LockOptions lockOptions = new LockOptions(this.getNullSafeLockMode(lockMode));
            result = entityDescriptor.getSingleIdLoader().load(id, lockOptions, this);
        }
        finally {
            this.getLoadQueryInfluencers().setEnabledInternalFetchProfileType(previouslyEnabledInternalFetchProfileType);
        }
        UnresolvableObjectException.throwIfNull(result, id, entityDescriptor.getEntityName());
    }

    @Override
    public Object immediateLoad(String entityName, Object id) throws HibernateException {
        throw new SessionException("proxies cannot be fetched by a stateless session");
    }

    @Override
    public void initializeCollection(PersistentCollection collection, boolean writing) throws HibernateException {
        throw new SessionException("collections cannot be fetched by a stateless session");
    }

    @Override
    public Object instantiate(String entityName, Object id) throws HibernateException {
        this.checkOpen();
        return this.getFactory().getMetamodel().findEntityDescriptor(entityName).instantiate(id, this);
    }

    @Override
    public Object internalLoad(String entityName, Object id, boolean eager, boolean nullable) throws HibernateException {
        this.checkOpen();
        EntityTypeDescriptor descriptor = this.getFactory().getMetamodel().findEntityDescriptor(entityName);
        Object loaded = this.temporaryPersistenceContext.getEntity(this.generateEntityKey(id, descriptor));
        if (loaded != null) {
            return loaded;
        }
        if (!eager && descriptor.hasProxy()) {
            return descriptor.createProxy(id, this);
        }
        return this.get(entityName, id);
    }

    @Override
    protected Object load(String entityName, Object identifier) {
        return this.internalLoad(entityName, identifier, false, false);
    }

    @Override
    public boolean isAutoCloseSessionEnabled() {
        return this.getFactory().getSessionFactoryOptions().isAutoCloseSessionEnabled();
    }

    @Override
    public boolean shouldAutoClose() {
        return this.isAutoCloseSessionEnabled() && !this.isClosed();
    }

    private boolean isFlushModeNever() {
        return false;
    }

    private void managedClose() {
        if (this.isClosed()) {
            throw new SessionException("Session was already closed!");
        }
        this.close();
    }

    private void managedFlush() {
        this.checkOpen();
        this.getJdbcCoordinator().executeBatch();
    }

    @Override
    public String bestGuessEntityName(Object object) {
        if (object instanceof HibernateProxy) {
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        return this.guessEntityName(object);
    }

    @Override
    public Connection connection() {
        this.checkOpen();
        return this.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
    }

    @Override
    public CacheMode getCacheMode() {
        return CacheMode.IGNORE;
    }

    @Override
    public void setCacheMode(CacheMode cm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFlushMode(FlushMode fm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHibernateFlushMode(FlushMode flushMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDontFlushFromFind() {
        return 0;
    }

    @Override
    public Object getContextEntityIdentifier(Object object) {
        this.checkOpen();
        return null;
    }

    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    @Override
    public String guessEntityName(Object entity) throws HibernateException {
        this.checkOpen();
        return entity.getClass().getName();
    }

    @Override
    public EntityTypeDescriptor getEntityDescriptor(String entityName, Object object) throws HibernateException {
        this.checkOpen();
        if (entityName == null) {
            return this.getFactory().getMetamodel().findEntityDescriptor(this.guessEntityName(object));
        }
        return this.getFactory().getMetamodel().findEntityDescriptor(entityName).getSubclassEntityDescriptor(object, this.getFactory());
    }

    @Override
    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        this.checkOpen();
        return null;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.temporaryPersistenceContext;
    }

    @Override
    public void setAutoClear(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEventSource() {
        return false;
    }

    @Override
    public boolean isDefaultReadOnly() {
        return false;
    }

    public void setDefaultReadOnly(boolean readOnly) throws HibernateException {
        if (readOnly) {
            throw new UnsupportedOperationException();
        }
    }

    public void afterOperation(boolean success) {
        if (!this.isTransactionInProgress()) {
            this.getJdbcCoordinator().afterTransaction();
        }
    }

    @Override
    public void afterScrollOperation() {
        this.temporaryPersistenceContext.clear();
    }

    @Override
    public void flush() {
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return NO_INFLUENCERS;
    }

    @Override
    public void afterTransactionBegin() {
    }

    @Override
    public void beforeTransactionCompletion() {
        this.flushBeforeTransactionCompletion();
    }

    @Override
    public void afterTransactionCompletion(boolean successful, boolean delayed) {
        if (this.shouldAutoClose() && !this.isClosed()) {
            this.managedClose();
        }
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.connectionProvided || super.isTransactionInProgress();
    }

    @Override
    public void flushBeforeTransactionCompletion() {
        boolean flush = false;
        try {
            flush = !this.isClosed() && !this.isFlushModeNever() && !JtaStatusHelper.isRollback(this.getJtaPlatform().getCurrentStatus());
        }
        catch (SystemException se) {
            throw new HibernateException("could not determine transaction status in beforeCompletion()", se);
        }
        if (flush) {
            this.managedFlush();
        }
    }

    private JtaPlatform getJtaPlatform() {
        return this.getFactory().getServiceRegistry().getService(JtaPlatform.class);
    }

    private LockMode getNullSafeLockMode(LockMode lockMode) {
        return lockMode == null ? LockMode.NONE : lockMode;
    }
}

