/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public final class EntityPrinter {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EntityPrinter.class);
    private SessionFactoryImplementor factory;

    public String toString(String entityName, Object entity, SharedSessionContractImplementor session) throws HibernateException {
        EntityTypeDescriptor entityDescriptor = this.factory.getEntityPersister(entityName);
        if (entityDescriptor == null || !entityDescriptor.isInstance(entity)) {
            return entity.getClass().getName();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (entityDescriptor.getIdentifierDescriptor() != null) {
            result.put(entityDescriptor.getIdentifierPropertyName(), entityDescriptor.getIdentifierDescriptor().getJavaTypeDescriptor().extractLoggableRepresentation(entityDescriptor.getIdentifierDescriptor().extractIdentifier(entity)));
        }
        entityDescriptor.visitStateArrayContributors(attributeDescriptor -> {
            String name = attributeDescriptor.getNavigableRole().getNavigableName();
            if (!name.startsWith("_")) {
                Object value = attributeDescriptor.getPropertyAccess().getGetter().get(entity);
                JavaTypeDescriptor javaTypeDescriptor = entityDescriptor.getJavaTypeDescriptor();
                String strValue = value == LazyPropertyInitializer.UNFETCHED_PROPERTY ? value.toString() : javaTypeDescriptor.extractLoggableRepresentation(value);
                result.put(name, strValue);
            }
        });
        return entityName + ((Object)result).toString();
    }

    public String toString(Type[] types, Object[] values) throws HibernateException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == null) continue;
            buffer.append(types[i].toLoggableString(values[i])).append(", ");
        }
        return buffer.toString();
    }

    public void toString(Iterable<Map.Entry<EntityKey, Object>> entitiesByEntityKey, SharedSessionContractImplementor session) throws HibernateException {
        if (!LOG.isDebugEnabled() || !entitiesByEntityKey.iterator().hasNext()) {
            return;
        }
        LOG.debug("Listing entities:");
        int i = 0;
        for (Map.Entry<EntityKey, Object> entityKeyAndEntity : entitiesByEntityKey) {
            if (i++ > 20) {
                LOG.debug("More......");
                break;
            }
            LOG.debug(this.toString(entityKeyAndEntity.getKey().getEntityName(), entityKeyAndEntity.getValue(), session));
        }
    }

    public EntityPrinter(SessionFactoryImplementor factory) {
        this.factory = factory;
    }
}

