/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.internal.util.collections.Stack;

public class SingleDepthStack<T>
implements Stack<T> {
    private T entry;

    @Override
    public void push(T newCurrent) {
        if (this.entry != null) {
            throw new IllegalStateException("Attempt to push new entry to single-depth stack when an entry already set");
        }
        this.entry = newCurrent;
    }

    @Override
    public T pop() {
        if (this.entry == null) {
            throw new IllegalStateException("Cannot pop from single-depth stack with no entry currently set");
        }
        T rtn = this.entry;
        this.entry = null;
        return rtn;
    }

    @Override
    public T getCurrent() {
        return this.entry;
    }

    @Override
    public T getPrevious() {
        return null;
    }

    @Override
    public int depth() {
        return this.entry == null ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.entry == null;
    }

    @Override
    public void clear() {
        this.entry = null;
    }

    @Override
    public void visitCurrentFirst(Consumer<T> action) {
    }

    @Override
    public <X> X findCurrentFirst(Function<T, X> action) {
        return null;
    }
}

