/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.internal.util.collections.Stack;

public class StandardStack<T>
implements Stack<T> {
    private final T nullMarker = new Object();
    private T current;
    private LinkedList<T> internalStack;

    public StandardStack() {
    }

    public StandardStack(T initial) {
        this.current = initial;
    }

    @Override
    public void push(T newCurrent) {
        if (newCurrent == null) {
            newCurrent = this.nullMarker;
        }
        if (this.current != null) {
            if (this.internalStack == null) {
                this.internalStack = new LinkedList();
            }
            this.internalStack.addFirst(this.current);
        }
        this.current = newCurrent;
    }

    @Override
    public T pop() {
        T popped = this.current;
        this.current = this.internalStack == null || this.internalStack.isEmpty() ? null : this.internalStack.removeFirst();
        return popped == this.nullMarker ? null : (T)popped;
    }

    @Override
    public T getCurrent() {
        return this.current == this.nullMarker ? null : (T)this.current;
    }

    @Override
    public T getPrevious() {
        if (this.current != null && this.internalStack != null) {
            T previous = this.internalStack.getFirst();
            return previous == this.nullMarker ? null : (T)previous;
        }
        return null;
    }

    @Override
    public int depth() {
        if (this.current == null) {
            return 0;
        }
        if (this.internalStack == null || this.internalStack.isEmpty()) {
            return 1;
        }
        return this.internalStack.size() + 1;
    }

    @Override
    public boolean isEmpty() {
        return this.current == null;
    }

    @Override
    public void clear() {
        this.current = null;
        if (this.internalStack != null) {
            this.internalStack.clear();
        }
    }

    @Override
    public void visitCurrentFirst(Consumer<T> action) {
        if (this.current != null) {
            action.accept(this.current);
            if (this.internalStack != null) {
                this.internalStack.forEach(action);
            }
        }
    }

    @Override
    public <X> X findCurrentFirst(Function<T, X> function) {
        if (this.current != null) {
            X result = function.apply(this.current);
            if (result != null) {
                return result;
            }
            if (this.internalStack != null) {
                for (Object t : this.internalStack) {
                    X result2 = function.apply(t);
                    if (result2 == null) continue;
                    return result2;
                }
            }
        }
        return null;
    }
}

