/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import org.hibernate.internal.util.collections.CollectionHelper;

public class UniqueList<E>
extends AbstractList<E>
implements Set<E>,
List<E> {
    private final List<E> elements;

    public UniqueList() {
        this(new ArrayList());
    }

    public UniqueList(List<E> elements) {
        this.elements = elements;
    }

    public UniqueList(int size) {
        this.elements = CollectionHelper.arrayList(size);
    }

    @Override
    public E get(int index) {
        return this.elements.get(index);
    }

    @Override
    public void add(int index, E element) {
        if (this.elements.contains(element)) {
            return;
        }
        this.elements.add(index, element);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.elements.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.elements.listIterator(index);
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elements.toArray(a);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 16);
    }
}

