/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections.streams;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class GenericArrayCollector<T>
implements Collector<T, List<T>, T[]> {
    private final Class<T> collectedType;

    public static <T> GenericArrayCollector<T> forType(Class<T> type) {
        return new GenericArrayCollector<T>(type);
    }

    public GenericArrayCollector(Class<T> collectedType) {
        this.collectedType = collectedType;
    }

    @Override
    public Supplier<List<T>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<T>, T> accumulator() {
        return List::add;
    }

    @Override
    public BinaryOperator<List<T>> combiner() {
        return (ts, ts2) -> {
            ts.addAll(ts2);
            return ts;
        };
    }

    @Override
    public Function<List<T>, T[]> finisher() {
        return ts -> ts.toArray((Object[])Array.newInstance(this.collectedType, ts.size()));
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.CONCURRENT);
    }
}

