/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.WrongClassException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.cache.spi.entry.ReferenceCacheEntryImpl;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.internal.TwoPhaseLoad;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractLockUpgradeEventListener;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;

public class CacheEntityLoaderHelper
extends AbstractLockUpgradeEventListener {
    public static final CacheEntityLoaderHelper INSTANCE = new CacheEntityLoaderHelper();
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(CacheEntityLoaderHelper.class);
    private static final boolean traceEnabled = LOG.isTraceEnabled();

    private CacheEntityLoaderHelper() {
    }

    public PersistenceContextEntry loadFromSessionCache(LoadEvent event, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        EventSource session = event.getSession();
        Object old = session.getEntityUsingInterceptor(keyToLoad);
        if (old != null) {
            EntityTypeDescriptor descriptor;
            Status status;
            EntityEntry oldEntry = session.getPersistenceContext().getEntry(old);
            if (options.isCheckDeleted() && ((status = oldEntry.getStatus()) == Status.DELETED || status == Status.GONE)) {
                LOG.debug("Load request found matching entity in context, but it is scheduled for removal; returning null");
                return new PersistenceContextEntry(old, EntityStatus.REMOVED_ENTITY_MARKER);
            }
            if (options.isAllowNulls() && !(descriptor = event.getSession().getFactory().getMetamodel().getEntityDescriptor(keyToLoad.getEntityName())).isInstance(old)) {
                LOG.debug("Load request found matching entity in context, but the matched entity was of an inconsistent return type; returning null");
                return new PersistenceContextEntry(old, EntityStatus.INCONSISTENT_RTN_CLASS_MARKER);
            }
            this.upgradeLock(old, oldEntry, event.getLockOptions(), event.getSession());
        }
        return new PersistenceContextEntry(old, EntityStatus.MANAGED);
    }

    public Object loadFromSecondLevelCache(LoadEvent event, EntityTypeDescriptor entityDescriptor, EntityKey entityKey) {
        boolean useCache;
        EventSource source = event.getSession();
        boolean bl = useCache = entityDescriptor.canReadFromCache() && source.getCacheMode().isGetEnabled() && event.getLockMode().lessThan(LockMode.READ);
        if (!useCache) {
            return null;
        }
        Object ce = this.getFromSharedCache(event, entityDescriptor, source);
        if (ce == null) {
            return null;
        }
        return this.processCachedEntry(event, entityDescriptor, ce, source, entityKey);
    }

    private Object processCachedEntry(LoadEvent event, EntityTypeDescriptor entityDescriptor, Object ce, SessionImplementor source, EntityKey entityKey) {
        CacheEntry entry = (CacheEntry)entityDescriptor.getCacheEntryStructure().destructure(ce, source.getFactory());
        if (entry.isReferenceEntry()) {
            if (event.getInstanceToLoad() != null) {
                throw new HibernateException("Attempt to load entity [%s] from cache using provided object instance, but cache is storing references: " + event.getEntityId());
            }
            return this.convertCacheReferenceEntryToEntity((ReferenceCacheEntryImpl)entry, event.getSession(), entityKey);
        }
        Object entity = this.convertCacheEntryToEntity(entry, event.getEntityId(), entityDescriptor, event, entityKey);
        if (!entityDescriptor.isInstance(entity)) {
            throw new WrongClassException("loaded object was of wrong class " + entity.getClass(), event.getEntityId(), entityDescriptor.getEntityName());
        }
        return entity;
    }

    private Object getFromSharedCache(LoadEvent event, EntityTypeDescriptor entityDescriptor, SessionImplementor source) {
        EntityDataAccess cacheAccess = entityDescriptor.getHierarchy().getEntityCacheAccess();
        Object ck = cacheAccess.generateCacheKey(event.getEntityId(), entityDescriptor.getHierarchy(), source.getFactory(), source.getTenantIdentifier());
        Serializable ce = CacheHelper.fromSharedCache(source, ck, cacheAccess);
        if (source.getFactory().getStatistics().isStatisticsEnabled()) {
            if (ce == null) {
                source.getFactory().getStatistics().entityCacheMiss(entityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
            } else {
                source.getFactory().getStatistics().entityCacheHit(entityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
            }
        }
        return ce;
    }

    private Object convertCacheReferenceEntryToEntity(ReferenceCacheEntryImpl referenceCacheEntry, EventSource session, EntityKey entityKey) {
        Object entity = referenceCacheEntry.getReference();
        if (entity == null) {
            throw new IllegalStateException("Reference cache entry contained null : " + referenceCacheEntry.toString());
        }
        this.makeEntityCircularReferenceSafe(referenceCacheEntry, session, entity, entityKey);
        return entity;
    }

    private void makeEntityCircularReferenceSafe(ReferenceCacheEntryImpl referenceCacheEntry, EventSource session, Object entity, EntityKey entityKey) {
        StatefulPersistenceContext statefulPersistenceContext = (StatefulPersistenceContext)session.getPersistenceContext();
        if (entity instanceof ManagedEntity) {
            statefulPersistenceContext.addReferenceEntry(entity, Status.READ_ONLY);
        } else {
            TwoPhaseLoad.addUninitializedCachedEntity(entityKey, entity, referenceCacheEntry.getSubclassDescriptor(), LockMode.NONE, referenceCacheEntry.getVersion(), session);
        }
        statefulPersistenceContext.initializeNonLazyCollections();
    }

    private Object convertCacheEntryToEntity(CacheEntry entry, Object entityId, EntityTypeDescriptor entityDescriptor, LoadEvent event, EntityKey entityKey) {
        throw new NotYetImplementedFor6Exception();
    }

    private Iterable<PostLoadEventListener> postLoadEventListeners(EventSource session) {
        return session.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.POST_LOAD).listeners();
    }

    public static class PersistenceContextEntry {
        private final Object entity;
        private EntityStatus status;

        public PersistenceContextEntry(Object entity, EntityStatus status) {
            this.entity = entity;
            this.status = status;
        }

        public Object getEntity() {
            return this.entity;
        }

        public EntityStatus getStatus() {
            return this.status;
        }

        public boolean isManaged() {
            return EntityStatus.MANAGED == this.status;
        }
    }

    public static enum EntityStatus {
        MANAGED,
        REMOVED_ENTITY_MARKER,
        INCONSISTENT_RTN_CLASS_MARKER;

    }
}

