/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.EnumMap;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.spi.CollectionLoader;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.SqlAstSelectToJdbcSelectConverter;
import org.hibernate.sql.ast.produce.metamodel.internal.SelectByCollectionKeyBuilder;
import org.hibernate.sql.ast.produce.spi.SqlAstSelectDescriptor;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.internal.LoadParameterBindingContext;
import org.hibernate.sql.exec.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.exec.internal.StandardJdbcParameterImpl;
import org.hibernate.sql.exec.spi.DomainParameterBindingContext;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcSelect;

public class CollectionLoaderImpl
implements CollectionLoader {
    private final PluralPersistentAttribute pluralAttribute;
    private final SelectByCollectionKeyBuilder selectionBuilder;
    private EnumMap<LockMode, JdbcSelect> selectByLockMode = new EnumMap(LockMode.class);
    private EnumMap<LoadQueryInfluencers.InternalFetchProfileType, JdbcSelect> selectByInternalCascadeProfile;

    public CollectionLoaderImpl(PluralPersistentAttribute pluralAttribute, SessionFactoryImplementor sessionFactory) {
        this.pluralAttribute = pluralAttribute;
        this.selectionBuilder = new SelectByCollectionKeyBuilder(pluralAttribute.getPersistentCollectionDescriptor(), sessionFactory);
    }

    public Navigable getLoadedNavigable() {
        return this.pluralAttribute;
    }

    @Override
    public PersistentCollection load(Object key, LockOptions lockOptions, final SharedSessionContractImplementor session) {
        final LoadParameterBindingContext parameterBindingContext = new LoadParameterBindingContext(session.getFactory(), key);
        JdbcSelect jdbcSelect = this.resolveJdbcSelect(lockOptions, session);
        final JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        org.hibernate.metamodel.model.domain.spi.CollectionKey collectionKeyDescriptor = this.pluralAttribute.getPersistentCollectionDescriptor().getCollectionKeyDescriptor();
        collectionKeyDescriptor.dehydrate(collectionKeyDescriptor.unresolve(key, session), new Writeable.JdbcValueCollector(){
            private int count = 0;

            @Override
            public void collect(final Object jdbcValue, final SqlExpressableType type, Column boundColumn) {
                jdbcParameterBindings.addBinding(new StandardJdbcParameterImpl(this.count++, type, Clause.WHERE, session.getFactory().getTypeConfiguration()), new JdbcParameterBinding(){

                    @Override
                    public SqlExpressableType getBindType() {
                        return type;
                    }

                    @Override
                    public Object getBindValue() {
                        return jdbcValue;
                    }
                });
            }
        }, Clause.WHERE, session);
        final CollectionKey collectionKey = new CollectionKey(this.pluralAttribute.getPersistentCollectionDescriptor(), key);
        JdbcSelectExecutorStandardImpl.INSTANCE.list(jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public DomainParameterBindingContext getDomainParameterBindingContext() {
                return parameterBindingContext;
            }

            @Override
            public Callback getCallback() {
                return null;
            }

            @Override
            public CollectionKey getCollectionKey() {
                return collectionKey;
            }
        }, RowTransformerSingularReturnImpl.instance());
        return session.getPersistenceContext().getCollection(collectionKey);
    }

    private JdbcSelect resolveJdbcSelect(LockOptions lockOptions, SharedSessionContractImplementor session) {
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        if (this.pluralAttribute.getPersistentCollectionDescriptor().isAffectedByEnabledFilters(session)) {
            return this.createJdbcSelect(lockOptions, loadQueryInfluencers, (SessionFactoryImplementor)session.getSessionFactory());
        }
        if (loadQueryInfluencers.getEnabledInternalFetchProfileType() != null && LockMode.UPGRADE.greaterThan(lockOptions.getLockMode())) {
            if (this.selectByInternalCascadeProfile == null) {
                this.selectByInternalCascadeProfile = new EnumMap(LoadQueryInfluencers.InternalFetchProfileType.class);
            }
            return this.selectByInternalCascadeProfile.computeIfAbsent(loadQueryInfluencers.getEnabledInternalFetchProfileType(), internalFetchProfileType -> this.createJdbcSelect(lockOptions, loadQueryInfluencers, (SessionFactoryImplementor)session.getSessionFactory()));
        }
        boolean cacheable = this.determineIfCacheable(lockOptions, session);
        if (cacheable) {
            return this.selectByLockMode.computeIfAbsent(lockOptions.getLockMode(), lockMode -> this.createJdbcSelect(lockOptions, loadQueryInfluencers, (SessionFactoryImplementor)session.getSessionFactory()));
        }
        return this.createJdbcSelect(lockOptions, loadQueryInfluencers, (SessionFactoryImplementor)session.getSessionFactory());
    }

    private JdbcSelect createJdbcSelect(LockOptions lockOptions, LoadQueryInfluencers queryInfluencers, SessionFactoryImplementor sessionFactory) {
        SqlAstSelectDescriptor selectDescriptor = this.selectionBuilder.generateSelectStatement(1, queryInfluencers, lockOptions);
        return SqlAstSelectToJdbcSelectConverter.interpret(selectDescriptor, sessionFactory);
    }

    private boolean determineIfCacheable(LockOptions lockOptions, SharedSessionContractImplementor session) {
        if (this.pluralAttribute.getPersistentCollectionDescriptor().isAffectedByEnabledFilters(session)) {
            return false;
        }
        return lockOptions.getTimeOut() != -1;
    }
}

