/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.spi.NaturalIdLoader;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NaturalIdDescriptor;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.SqlAstSelectToJdbcSelectConverter;
import org.hibernate.sql.ast.consume.spi.StandardParameterBindingContext;
import org.hibernate.sql.ast.produce.metamodel.internal.SelectByNaturalIdBuilder;
import org.hibernate.sql.ast.produce.spi.SqlAstSelectDescriptor;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.exec.internal.StandardJdbcParameterImpl;
import org.hibernate.sql.exec.spi.DomainParameterBindingContext;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.jboss.logging.Logger;

public class StandardNaturalIdLoader
implements NaturalIdLoader {
    private static final Logger log = Logger.getLogger(StandardNaturalIdLoader.class);
    private final EntityTypeDescriptor entityDescriptor;
    private Boolean simple;
    private JdbcSelect xrefSelect;

    public StandardNaturalIdLoader(EntityTypeDescriptor entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
    }

    @Override
    public Object resolveNaturalIdToEntity(Object naturalIdToLoad, LockOptions lockOptions, final SharedSessionContractImplementor session) {
        if (naturalIdToLoad == null) {
            throw new HibernateException("Natural-id to load cannot be null");
        }
        if (this.xrefSelect == null) {
            this.xrefSelect = this.generatePkByNaturalIdSelect();
        }
        final JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        List<NaturalIdDescriptor.NaturalIdAttributeInfo> naturalIdAttributeInfoList = this.entityDescriptor.getHierarchy().getNaturalIdDescriptor().getAttributeInfos();
        this.simple = naturalIdAttributeInfoList.size() == 1;
        if (this.simple.booleanValue()) {
            if (naturalIdToLoad instanceof Object[]) {
                naturalIdToLoad = ((Object[])naturalIdToLoad)[0];
            }
            naturalIdAttributeInfoList.get(0).getUnderlyingAttributeDescriptor().dehydrate(naturalIdToLoad, (jdbcValue, type, boundColumn) -> jdbcParameterBindings.addBinding(new StandardJdbcParameterImpl(jdbcParameterBindings.getBindings().size(), type, Clause.WHERE, session.getFactory().getTypeConfiguration()), new JdbcParameterBinding(){

                @Override
                public SqlExpressableType getBindType() {
                    return type;
                }

                @Override
                public Object getBindValue() {
                    return jdbcValue;
                }
            }), Clause.WHERE, session);
        } else {
            assert (naturalIdToLoad instanceof Object[]);
            final Object[] naturalIdValues = (Object[])naturalIdToLoad;
            this.entityDescriptor.getHierarchy().getNaturalIdDescriptor().visitPersistentAttributes(new Consumer<NaturalIdDescriptor.NaturalIdAttributeInfo>(){

                @Override
                public void accept(NaturalIdDescriptor.NaturalIdAttributeInfo naturalIdAttributeInfo) {
                    Object idValue = naturalIdValues[naturalIdAttributeInfo.getStateArrayPosition()];
                    naturalIdAttributeInfo.getUnderlyingAttributeDescriptor().dehydrate(idValue, (jdbcValue, type, boundColumn) -> jdbcParameterBindings.addBinding(new StandardJdbcParameterImpl(jdbcParameterBindings.getBindings().size(), type, Clause.WHERE, session.getFactory().getTypeConfiguration()), new JdbcParameterBinding(){

                        @Override
                        public SqlExpressableType getBindType() {
                            return type;
                        }

                        @Override
                        public Object getBindValue() {
                            return jdbcValue;
                        }
                    }), Clause.WHERE, session);
                }
            });
        }
        final StandardParameterBindingContext parameterBindingContext = new StandardParameterBindingContext(session.getFactory(), QueryParameterBindings.NO_PARAM_BINDINGS, Collections.emptyList());
        ExecutionContext executionContext = new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public DomainParameterBindingContext getDomainParameterBindingContext() {
                return parameterBindingContext;
            }

            @Override
            public Callback getCallback() {
                return afterLoadAction -> {};
            }
        };
        List list = JdbcSelectExecutorStandardImpl.INSTANCE.list(this.xrefSelect, jdbcParameterBindings, executionContext, RowTransformerSingularReturnImpl.instance());
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private JdbcSelect generatePkByNaturalIdSelect() {
        SelectByNaturalIdBuilder selectBuilder = new SelectByNaturalIdBuilder(this.entityDescriptor.getFactory(), this.entityDescriptor);
        SqlAstSelectDescriptor selectDescriptor = selectBuilder.generateSelectStatement(1, LoadQueryInfluencers.NONE, LockOptions.NONE);
        return SqlAstSelectToJdbcSelectConverter.interpret(selectDescriptor, this.entityDescriptor.getFactory());
    }

    @Override
    public Object load(Object naturalIdToLoad, NaturalIdLoader.LoadOptions options, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception();
    }

    public EntityTypeDescriptor getLoadedNavigable() {
        return this.entityDescriptor;
    }
}

