/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.spi.SingleIdEntityLoader;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.SqlAstSelectToJdbcSelectConverter;
import org.hibernate.sql.ast.produce.internal.SqlAstQuerySpecProcessingStateImpl;
import org.hibernate.sql.ast.produce.internal.SqlAstSelectDescriptorImpl;
import org.hibernate.sql.ast.produce.metamodel.internal.LoadIdParameter;
import org.hibernate.sql.ast.produce.metamodel.internal.SelectByEntityIdentifierBuilder;
import org.hibernate.sql.ast.produce.metamodel.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.produce.spi.FromClauseAccess;
import org.hibernate.sql.ast.produce.spi.FromClauseIndex;
import org.hibernate.sql.ast.produce.spi.QualifiableSqlExpressable;
import org.hibernate.sql.ast.produce.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.produce.spi.SqlAstSelectDescriptor;
import org.hibernate.sql.ast.produce.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.produce.spi.SqlSelectionExpression;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.internal.LoadParameterBindingContext;
import org.hibernate.sql.exec.internal.RowTransformerPassThruImpl;
import org.hibernate.sql.exec.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.exec.internal.StandardJdbcParameterImpl;
import org.hibernate.sql.exec.spi.DomainParameterBindingContext;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.domain.basic.BasicResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;

public class StandardSingleIdEntityLoader<T>
implements SingleIdEntityLoader<T> {
    private final EntityTypeDescriptor<T> entityDescriptor;
    private final SqlAstSelectDescriptor databaseSnapshotSelectAst;
    private LoadIdParameter idParameter;
    private EnumMap<LockMode, JdbcSelect> selectByLockMode = new EnumMap(LockMode.class);
    private EnumMap<LoadQueryInfluencers.InternalFetchProfileType, JdbcSelect> selectByInternalCascadeProfile;

    public StandardSingleIdEntityLoader(EntityTypeDescriptor<T> entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
        this.databaseSnapshotSelectAst = this.generateDatabaseSnapshotSelect(entityDescriptor);
    }

    @Override
    public EntityTypeDescriptor<T> getLoadedNavigable() {
        return this.entityDescriptor;
    }

    @Override
    public T load(Object id, LockOptions lockOptions, final SharedSessionContractImplementor session) {
        final LoadParameterBindingContext parameterBindingContext = new LoadParameterBindingContext(session.getFactory(), id);
        JdbcSelect jdbcSelect = this.resolveJdbcSelect(lockOptions, session);
        final JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        this.entityDescriptor.getHierarchy().getIdentifierDescriptor().dehydrate(this.entityDescriptor.getHierarchy().getIdentifierDescriptor().unresolve(id, session), new Writeable.JdbcValueCollector(){
            private int count = 0;

            @Override
            public void collect(final Object jdbcValue, final SqlExpressableType type, Column boundColumn) {
                jdbcParameterBindings.addBinding(new StandardJdbcParameterImpl(this.count++, type, Clause.WHERE, session.getFactory().getTypeConfiguration()), new JdbcParameterBinding(){

                    @Override
                    public SqlExpressableType getBindType() {
                        return type;
                    }

                    @Override
                    public Object getBindValue() {
                        return jdbcValue;
                    }
                });
            }
        }, Clause.WHERE, session);
        List list = JdbcSelectExecutorStandardImpl.INSTANCE.list(jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public DomainParameterBindingContext getDomainParameterBindingContext() {
                return parameterBindingContext;
            }

            @Override
            public Callback getCallback() {
                return null;
            }
        }, RowTransformerSingularReturnImpl.instance());
        if (list.isEmpty()) {
            return null;
        }
        Object entityInstance = list.get(0);
        return (T)entityInstance;
    }

    private JdbcSelect resolveJdbcSelect(LockOptions lockOptions, SharedSessionContractImplementor session) {
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        if (this.entityDescriptor.isAffectedByEnabledFilters(session)) {
            return this.createJdbcSelect(lockOptions, loadQueryInfluencers, (SessionFactoryImplementor)session.getSessionFactory());
        }
        if (loadQueryInfluencers.getEnabledInternalFetchProfileType() != null && LockMode.UPGRADE.greaterThan(lockOptions.getLockMode())) {
            if (this.selectByInternalCascadeProfile == null) {
                this.selectByInternalCascadeProfile = new EnumMap(LoadQueryInfluencers.InternalFetchProfileType.class);
            }
            return this.selectByInternalCascadeProfile.computeIfAbsent(loadQueryInfluencers.getEnabledInternalFetchProfileType(), internalFetchProfileType -> this.createJdbcSelect(lockOptions, loadQueryInfluencers, (SessionFactoryImplementor)session.getSessionFactory()));
        }
        boolean cacheable = this.determineIfCacheable(lockOptions, loadQueryInfluencers);
        if (cacheable) {
            return this.selectByLockMode.computeIfAbsent(lockOptions.getLockMode(), lockMode -> this.createJdbcSelect(lockOptions, loadQueryInfluencers, (SessionFactoryImplementor)session.getSessionFactory()));
        }
        return this.createJdbcSelect(lockOptions, loadQueryInfluencers, (SessionFactoryImplementor)session.getSessionFactory());
    }

    private JdbcSelect createJdbcSelect(LockOptions lockOptions, LoadQueryInfluencers queryInfluencers, SessionFactoryImplementor sessionFactory) {
        SelectByEntityIdentifierBuilder selectBuilder = new SelectByEntityIdentifierBuilder(this.entityDescriptor.getFactory(), this.entityDescriptor);
        SqlAstSelectDescriptor selectDescriptor = selectBuilder.generateSelectStatement(1, queryInfluencers, lockOptions);
        return SqlAstSelectToJdbcSelectConverter.interpret(selectDescriptor, sessionFactory);
    }

    private boolean determineIfCacheable(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers) {
        if (this.entityDescriptor.isAffectedByEntityGraph(loadQueryInfluencers)) {
            return false;
        }
        return lockOptions.getTimeOut() == -1;
    }

    @Override
    public Object[] loadDatabaseSnapshot(Object id, SharedSessionContractImplementor session) {
        JdbcSelect jdbcSelect = SqlAstSelectToJdbcSelectConverter.interpret(this.databaseSnapshotSelectAst, (SessionFactoryImplementor)session.getSessionFactory());
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        this.entityDescriptor.getHierarchy().getIdentifierDescriptor().dehydrate(id, (jdbcValue, type, boundColumn) -> jdbcParameterBindings.addBinding(this.idParameter, new JdbcParameterBinding(){

            @Override
            public SqlExpressableType getBindType() {
                return type;
            }

            @Override
            public Object getBindValue() {
                return jdbcValue;
            }
        }), Clause.WHERE, session);
        List list = JdbcSelectExecutorStandardImpl.INSTANCE.list(jdbcSelect, jdbcParameterBindings, this.getExecutionContext(session), RowTransformerPassThruImpl.instance());
        if (list.isEmpty()) {
            return null;
        }
        int size = list.size();
        Object[] values = new Object[size];
        for (int i = 0; i < size; ++i) {
            values[i] = list.get(i);
        }
        return values;
    }

    private ExecutionContext getExecutionContext(final SharedSessionContractImplementor session) {
        final DomainParameterBindingContext parameterBindingContext = new DomainParameterBindingContext(){

            public <X> List<X> getLoadIdentifiers() {
                return Collections.emptyList();
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public SessionFactoryImplementor getSessionFactory() {
                return session.getSessionFactory();
            }
        };
        return new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public DomainParameterBindingContext getDomainParameterBindingContext() {
                return parameterBindingContext;
            }

            @Override
            public Callback getCallback() {
                return afterLoadAction -> {};
            }
        };
    }

    private SqlAstSelectDescriptor generateDatabaseSnapshotSelect(final EntityTypeDescriptor<?> entityDescriptor) {
        final QuerySpec rootQuerySpec = new QuerySpec(true);
        SelectStatement selectStatement = new SelectStatement(rootQuerySpec);
        SelectClause selectClause = selectStatement.getQuerySpec().getSelectClause();
        final SqlAliasBaseManager aliasBaseGenerator = new SqlAliasBaseManager();
        final FromClauseIndex fromClauseIndex = new FromClauseIndex();
        SqlAstCreationState creationState = new SqlAstCreationState(){
            final SqlAstQuerySpecProcessingStateImpl processingState;
            {
                this.processingState = new SqlAstQuerySpecProcessingStateImpl(rootQuerySpec, null, this, () -> null, () -> expression -> {}, () -> sqlSelection -> {});
            }

            @Override
            public SqlAstCreationContext getCreationContext() {
                return entityDescriptor.getFactory();
            }

            @Override
            public SqlExpressionResolver getSqlExpressionResolver() {
                return this.processingState;
            }

            @Override
            public SqlAstProcessingState getCurrentProcessingState() {
                return this.processingState;
            }

            @Override
            public FromClauseAccess getFromClauseAccess() {
                return fromClauseIndex;
            }

            @Override
            public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
                return aliasBaseGenerator;
            }

            @Override
            public LockMode determineLockMode(String identificationVariable) {
                return null;
            }

            @Override
            public List<Fetch> visitFetches(FetchParent fetchParent) {
                return Collections.emptyList();
            }
        };
        NavigablePath path = new NavigablePath(entityDescriptor.getEntityName());
        TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(path, null, null, LockMode.NONE, creationState);
        selectStatement.getQuerySpec().getFromClause().addRoot(rootTableGroup);
        ArrayList<DomainResult> domainResults = new ArrayList<DomainResult>();
        EntityIdentifier identifierDescriptor = entityDescriptor.getHierarchy().getIdentifierDescriptor();
        ArrayList columnReferences = new ArrayList();
        Position position = new Position();
        identifierDescriptor.visitColumns((sqlExpressableType, column) -> {
            Expression expression = rootTableGroup.qualify((QualifiableSqlExpressable)column);
            ColumnReference columnReference = !ColumnReference.class.isInstance(expression) ? (ColumnReference)((SqlSelectionExpression)expression).getExpression() : (ColumnReference)expression;
            columnReferences.add(columnReference);
            SqlSelectionImpl sqlSelection = new SqlSelectionImpl(position.getJdbcPosition(), position.getValuesArrayPosition(), (Expression)columnReference, sqlExpressableType.getJdbcValueExtractor());
            position.increase();
            selectClause.addSqlSelection(sqlSelection);
            domainResults.add(new BasicResultImpl(null, sqlSelection, (SqlExpressableType)sqlExpressableType));
        }, Clause.SELECT, null);
        Expression idExpression = columnReferences.size() == 1 ? (Expression)columnReferences.get(0) : new SqlTuple(columnReferences, identifierDescriptor);
        entityDescriptor.visitStateArrayContributors(stateArrayContributor -> stateArrayContributor.visitColumns((sqlExpressableType, column) -> {
            Expression expression = rootTableGroup.qualify((QualifiableSqlExpressable)column);
            ColumnReference columnReference = !ColumnReference.class.isInstance(expression) ? (ColumnReference)((SqlSelectionExpression)expression).getExpression() : (ColumnReference)expression;
            SqlSelectionImpl sqlSelection = new SqlSelectionImpl(position.getJdbcPosition(), position.getValuesArrayPosition(), (Expression)columnReference, sqlExpressableType.getJdbcValueExtractor());
            position.increase();
            selectClause.addSqlSelection(sqlSelection);
            domainResults.add(new BasicResultImpl(null, sqlSelection, (SqlExpressableType)sqlExpressableType));
        }, Clause.SELECT, null));
        this.idParameter = new LoadIdParameter(identifierDescriptor, entityDescriptor.getFactory().getTypeConfiguration());
        rootQuerySpec.addRestriction(new ComparisonPredicate(idExpression, ComparisonOperator.EQUAL, this.idParameter));
        return new SqlAstSelectDescriptorImpl(selectStatement, domainResults, entityDescriptor.getAffectedTableNames());
    }

    public class Position {
        int jdbcPosition = 1;
        int valuesArrayPosition = 0;

        public void increase() {
            ++this.jdbcPosition;
            ++this.valuesArrayPosition;
        }

        public int getJdbcPosition() {
            return this.jdbcPosition;
        }

        public int getValuesArrayPosition() {
            return this.valuesArrayPosition;
        }
    }
}

