/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.EnumMap;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.internal.TemplateParameterBindingContext;
import org.hibernate.loader.spi.SingleUniqueKeyEntityLoader;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEntity;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.SqlAstSelectToJdbcSelectConverter;
import org.hibernate.sql.ast.produce.metamodel.internal.SelectByUniqueKeyBuilder;
import org.hibernate.sql.ast.produce.spi.SqlAstSelectDescriptor;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.exec.internal.StandardJdbcParameterImpl;
import org.hibernate.sql.exec.spi.DomainParameterBindingContext;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class StandardSingleUniqueKeyEntityLoader<T>
implements SingleUniqueKeyEntityLoader<T> {
    private final SingularPersistentAttributeEntity attribute;
    private final Navigable fkTargetAttribute;
    private EnumMap<LockMode, JdbcSelect> selectByLockMode = new EnumMap(LockMode.class);
    private EnumMap<LoadQueryInfluencers.InternalFetchProfileType, JdbcSelect> selectByInternalCascadeProfile;

    public StandardSingleUniqueKeyEntityLoader(Navigable fkTargetAttribute, SingularPersistentAttributeEntity attribute) {
        this.attribute = attribute;
        this.fkTargetAttribute = fkTargetAttribute;
    }

    @Override
    public EntityTypeDescriptor getLoadedNavigable() {
        return this.attribute.getAssociatedEntityDescriptor();
    }

    @Override
    public T load(Object uk, LockOptions lockOptions, SharedSessionContractImplementor session) {
        if (uk == null) {
            return null;
        }
        EntityUniqueKey pcKey = new EntityUniqueKey(this.getLoadedNavigable().getEntityName(), this.fkTargetAttribute.getNavigableName(), uk, (JavaTypeDescriptor)this.getLoadedNavigable().getIdentifierDescriptor().getJavaTypeDescriptor(), (JavaTypeDescriptor)this.fkTargetAttribute.getJavaTypeDescriptor(), this.getLoadedNavigable().getHierarchy().getRepresentation());
        Object existingEntityInstance = session.getPersistenceContext().getEntity(pcKey);
        if (existingEntityInstance != null) {
            return (T)existingEntityInstance;
        }
        return this.loadEntity(uk, lockOptions, session);
    }

    private T loadEntity(Object uk, LockOptions lockOptions, SharedSessionContractImplementor session) {
        JdbcSelect jdbcSelect = this.resolveJdbcSelect(lockOptions, session);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        SingularPersistentAttributeEntity attribute = (SingularPersistentAttributeEntity)this.fkTargetAttribute;
        attribute.dehydrate(uk, (jdbcValue, type, boundColumn) -> jdbcParameterBindings.addBinding(new StandardJdbcParameterImpl(jdbcParameterBindings.getBindings().size(), type, Clause.WHERE, session.getFactory().getTypeConfiguration()), new JdbcParameterBinding(){

            @Override
            public SqlExpressableType getBindType() {
                return type;
            }

            @Override
            public Object getBindValue() {
                return jdbcValue;
            }
        }), Clause.WHERE, session);
        List list = JdbcSelectExecutorStandardImpl.INSTANCE.list(jdbcSelect, jdbcParameterBindings, this.getExecutionContext(session), RowTransformerSingularReturnImpl.instance());
        if (list.isEmpty()) {
            return null;
        }
        return (T)list.get(0);
    }

    private JdbcSelect resolveJdbcSelect(LockOptions lockOptions, SharedSessionContractImplementor session) {
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        if (this.getLoadedNavigable().isAffectedByEnabledFilters(session)) {
            return this.createJdbcSelect(lockOptions, loadQueryInfluencers, (SessionFactoryImplementor)session.getSessionFactory());
        }
        if (loadQueryInfluencers.getEnabledInternalFetchProfileType() != null && LockMode.UPGRADE.greaterThan(lockOptions.getLockMode())) {
            if (this.selectByInternalCascadeProfile == null) {
                this.selectByInternalCascadeProfile = new EnumMap(LoadQueryInfluencers.InternalFetchProfileType.class);
            }
            return this.selectByInternalCascadeProfile.computeIfAbsent(loadQueryInfluencers.getEnabledInternalFetchProfileType(), internalFetchProfileType -> this.createJdbcSelect(lockOptions, loadQueryInfluencers, (SessionFactoryImplementor)session.getSessionFactory()));
        }
        boolean cacheable = this.determineIfCacheable(lockOptions, loadQueryInfluencers);
        if (cacheable) {
            return this.selectByLockMode.computeIfAbsent(lockOptions.getLockMode(), lockMode -> this.createJdbcSelect(lockOptions, loadQueryInfluencers, (SessionFactoryImplementor)session.getSessionFactory()));
        }
        return this.createJdbcSelect(lockOptions, loadQueryInfluencers, (SessionFactoryImplementor)session.getSessionFactory());
    }

    private JdbcSelect createJdbcSelect(LockOptions lockOptions, LoadQueryInfluencers queryInfluencers, SessionFactoryImplementor sessionFactory) {
        SelectByUniqueKeyBuilder selectBuilder = new SelectByUniqueKeyBuilder(sessionFactory, this.getLoadedNavigable(), this.attribute);
        SqlAstSelectDescriptor selectDescriptor = selectBuilder.generateSelectStatement(1, queryInfluencers, lockOptions);
        return SqlAstSelectToJdbcSelectConverter.interpret(selectDescriptor, sessionFactory);
    }

    private boolean determineIfCacheable(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers) {
        if (this.getLoadedNavigable().isAffectedByEntityGraph(loadQueryInfluencers)) {
            return false;
        }
        return lockOptions.getTimeOut() != -1;
    }

    private ExecutionContext getExecutionContext(final SharedSessionContractImplementor session) {
        final TemplateParameterBindingContext parameterBindingContext = new TemplateParameterBindingContext(session.getFactory());
        return new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public DomainParameterBindingContext getDomainParameterBindingContext() {
                return parameterBindingContext;
            }

            @Override
            public Callback getCallback() {
                return null;
            }
        };
    }
}

