/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.Collections;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.exec.spi.DomainParameterBindingContext;

public class TemplateParameterBindingContext
implements DomainParameterBindingContext {
    private static final Object ID_VALUE_TOKEN = new Object();
    private final SessionFactoryImplementor sessionFactory;
    private final List idListPrototype;

    public TemplateParameterBindingContext(SessionFactoryImplementor sessionFactory) {
        this(sessionFactory, -1);
    }

    public TemplateParameterBindingContext(SessionFactoryImplementor sessionFactory, int expectedIdentifierCount) {
        this.sessionFactory = sessionFactory;
        if (expectedIdentifierCount < 1) {
            this.idListPrototype = Collections.emptyList();
        } else {
            this.idListPrototype = CollectionHelper.arrayList(expectedIdentifierCount);
            Collections.fill(this.idListPrototype, ID_VALUE_TOKEN);
        }
    }

    @Override
    public <T> List<T> getLoadIdentifiers() {
        return this.idListPrototype;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return QueryParameterBindings.NO_PARAM_BINDINGS;
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }
}

