/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.JavaTypeMapping;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.collection.internal.StandardArraySemantics;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.List;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.descriptor.java.spi.Primitive;

public class Array
extends List {
    private String elementClassName;
    private final Collection.CollectionJavaTypeMapping javaTypeMapping;

    public Array(MetadataBuildingContext buildingContext, PersistentClass owner) {
        super(buildingContext, owner);
        this.javaTypeMapping = new Collection.CollectionJavaTypeMapping(buildingContext.getBootstrapContext().getTypeConfiguration(), Object[].class);
    }

    public Class getElementClass() throws MappingException {
        if (this.elementClassName == null) {
            return this.isPrimitiveArray() ? ((Primitive)this.getElement().getJavaTypeMapping().getJavaTypeDescriptor()).getPrimitiveClass() : this.getElement().getJavaTypeMapping().getJavaTypeDescriptor().getJavaType();
        }
        try {
            return this.getMetadataBuildingContext().getBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class).classForName(this.elementClassName);
        }
        catch (ClassLoadingException e) {
            throw new MappingException((Throwable)((Object)e));
        }
    }

    @Override
    public boolean isArray() {
        return true;
    }

    public String getElementClassName() {
        return this.elementClassName;
    }

    public void setElementClassName(String elementClassName) {
        this.elementClassName = elementClassName;
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public CollectionSemantics getCollectionSemantics() {
        return StandardArraySemantics.INSTANCE;
    }

    @Override
    public JavaTypeMapping getJavaTypeMapping() {
        return this.javaTypeMapping;
    }
}

