/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.model.domain.BasicValueMapping;
import org.hibernate.boot.model.domain.JavaTypeMapping;
import org.hibernate.boot.model.domain.NotYetResolvedException;
import org.hibernate.boot.model.domain.ResolutionContext;
import org.hibernate.boot.model.domain.internal.NamedBasicTypeResolution;
import org.hibernate.boot.model.domain.internal.NamedConverterResolution;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.metamodel.model.convert.internal.NamedEnumValueConverter;
import org.hibernate.metamodel.model.convert.internal.OrdinalEnumValueConverter;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.internal.EnumJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.hibernate.type.descriptor.java.spi.TemporalJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.internal.InferredBasicValueResolver;
import org.hibernate.type.spi.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class BasicValue
extends SimpleValue
implements BasicValueMapping,
SqlTypeDescriptorIndicators {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(BasicValue.class);
    private final TypeConfiguration typeConfiguration;
    private final int preferredJdbcTypeCodeForBoolean;
    private Function<TypeConfiguration, BasicJavaDescriptor<?>> explicitJavaTypeAccess;
    private Function<TypeConfiguration, SqlTypeDescriptor> explicitSqlTypeAccess;
    private MutabilityPlan explicitMutabilityPlan;
    private boolean isNationalized;
    private boolean isLob;
    private EnumType enumType;
    private TemporalType temporalPrecision;
    private ConverterDescriptor attributeConverterDescriptor;
    private Class resolvedJavaClass;
    private String ownerName;
    private String propertyName;
    private Map explicitLocalTypeParams;
    private BasicValueMapping.Resolution resolution;
    private BasicValue dependentValue;
    private BasicJavaDescriptor javaTypeDescriptor;
    private JavaTypeMapping javaTypeMapping;
    private SqlTypeDescriptor sqlTypeDescriptor;

    public BasicValue(MetadataBuildingContext buildingContext, MappedTable table) {
        this(buildingContext, table, null);
    }

    public BasicValue(MetadataBuildingContext buildingContext, MappedTable table, BasicValue dependentValue) {
        super(buildingContext, table);
        this.typeConfiguration = buildingContext.getBootstrapContext().getTypeConfiguration();
        this.preferredJdbcTypeCodeForBoolean = buildingContext.getPreferredSqlTypeCodeForBoolean();
        this.dependentValue = dependentValue;
        this.javaTypeMapping = new BasicJavaTypeMapping(this);
        buildingContext.getMetadataCollector().registerValueMappingResolver(this::resolve);
    }

    @Override
    public JavaTypeMapping getJavaTypeMapping() {
        return this.javaTypeMapping;
    }

    public BasicValueMapping.Resolution getResolution() throws NotYetResolvedException {
        if (this.resolution == null) {
            throw new NotYetResolvedException("BasicValue[" + this.toString() + "] not yet resolved");
        }
        return this.resolution;
    }

    @Override
    public Boolean resolve(ResolutionContext context) {
        if (this.resolution != null) {
            return true;
        }
        final String name = this.getTypeName();
        if (name != null) {
            this.resolution = BasicValue.interpretExplicitlyNamedType(name, this.explicitJavaTypeAccess, this.explicitSqlTypeAccess, this.attributeConverterDescriptor, this.explicitMutabilityPlan, this.explicitLocalTypeParams, this, this.typeConfiguration, context);
        } else {
            ServiceRegistry serviceRegistry = this.typeConfiguration.getServiceRegistry();
            ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
            this.resolution = BasicValue.implicitlyResolveBasicType(this.explicitJavaTypeAccess, this.explicitSqlTypeAccess, this.attributeConverterDescriptor, this, () -> {
                if (this.resolvedJavaClass != null) {
                    return (BasicJavaDescriptor)context.getBootstrapContext().getTypeConfiguration().getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(this.resolvedJavaClass);
                }
                if (this.ownerName != null && this.propertyName != null) {
                    Class reflectedJavaType = ReflectHelper.reflectedPropertyClass(this.ownerName, this.propertyName, classLoaderService);
                    BasicType basicType = context.getBootstrapContext().getTypeConfiguration().getBasicTypeRegistry().getBasicTypeByName(reflectedJavaType.getName());
                    if (basicType != null) {
                        return basicType.getJavaTypeDescriptor();
                    }
                    return (BasicJavaDescriptor)context.getBootstrapContext().getTypeConfiguration().getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(reflectedJavaType);
                }
                if (this.dependentValue != null) {
                    return this.dependentValue.getResolution().getDomainJavaDescriptor();
                }
                return null;
            }, this.typeConfiguration);
        }
        assert (this.resolution.getValueMapper() != null);
        assert (this.resolution.getValueMapper().getSqlExpressableType() != null);
        assert (this.resolution.getBasicType() != null);
        MappedColumn column = this.getMappedColumn();
        column.setJavaTypeMapping(new JavaTypeMapping(){

            @Override
            public String getTypeName() {
                return name;
            }

            public JavaTypeDescriptor getJavaTypeDescriptor() throws NotYetResolvedException {
                return BasicValue.this.resolution.getRelationalJavaDescriptor();
            }
        });
        column.setSqlTypeDescriptorAccess(this.resolution::getRelationalSqlTypeDescriptor);
        return true;
    }

    private static BasicValueMapping.Resolution interpretExplicitlyNamedType(String name, Function<TypeConfiguration, BasicJavaDescriptor<?>> explicitJtdAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitStdAccess, ConverterDescriptor converterDescriptor, MutabilityPlan explicitMutabilityPlan, Map localTypeParams, SqlTypeDescriptorIndicators stdIndicators, final TypeConfiguration typeConfiguration, ResolutionContext resolutionContext) {
        final ManagedBeanRegistry managedBeanRegistry = resolutionContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        JpaAttributeConverterCreationContext converterCreationContext = new JpaAttributeConverterCreationContext(){

            @Override
            public ManagedBeanRegistry getManagedBeanRegistry() {
                return managedBeanRegistry;
            }

            @Override
            public JavaTypeDescriptorRegistry getJavaTypeDescriptorRegistry() {
                return typeConfiguration.getJavaTypeDescriptorRegistry();
            }
        };
        if (name.startsWith("converted::")) {
            return NamedConverterResolution.from(name, explicitJtdAccess, explicitStdAccess, converterCreationContext, explicitMutabilityPlan, stdIndicators, resolutionContext);
        }
        BasicType basicTypeByName = typeConfiguration.getBasicTypeRegistry().getBasicTypeByName(name);
        if (basicTypeByName != null) {
            BasicJavaDescriptor domainJtd;
            JpaAttributeConverter valueConverter;
            if (converterDescriptor == null) {
                valueConverter = null;
                domainJtd = basicTypeByName.getJavaTypeDescriptor();
            } else {
                valueConverter = converterDescriptor.createJpaAttributeConverter(converterCreationContext);
                domainJtd = valueConverter.getDomainJavaDescriptor();
            }
            return new NamedBasicTypeResolution(domainJtd, basicTypeByName, valueConverter, explicitMutabilityPlan, resolutionContext);
        }
        TypeDefinition typeDefinition = resolutionContext.getMetadataBuildingContext().resolveTypeDefinition(name);
        if (typeDefinition != null) {
            return typeDefinition.resolve(explicitJtdAccess.apply(typeConfiguration), explicitStdAccess.apply(typeConfiguration), localTypeParams, explicitMutabilityPlan, resolutionContext.getMetadataBuildingContext());
        }
        ClassLoaderService cls = typeConfiguration.getServiceRegistry().getService(ClassLoaderService.class);
        try {
            Class typeNamedClass = cls.classForName(name);
            if (CollectionHelper.isEmpty(localTypeParams)) {
                TypeDefinition implicitDefinition = new TypeDefinition(name, typeNamedClass, null, Collections.emptyMap(), typeConfiguration);
                resolutionContext.getMetadataBuildingContext().addTypeDefinition(implicitDefinition);
                return implicitDefinition.resolve(explicitJtdAccess != null ? explicitJtdAccess.apply(typeConfiguration) : null, explicitStdAccess != null ? explicitStdAccess.apply(typeConfiguration) : null, Collections.emptyMap(), explicitMutabilityPlan, resolutionContext.getMetadataBuildingContext());
            }
            return TypeDefinition.createLocalResolution(name, typeNamedClass, explicitJtdAccess.apply(typeConfiguration), explicitStdAccess.apply(typeConfiguration), explicitMutabilityPlan, localTypeParams, resolutionContext);
        }
        catch (ClassLoadingException classLoadingException) {
            throw new NotYetResolvedException("Could not resolve named type : " + name);
        }
    }

    private static BasicValueMapping.Resolution implicitlyResolveBasicType(Function<TypeConfiguration, BasicJavaDescriptor<?>> explicitJtdAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitStdAccess, ConverterDescriptor attributeConverterDescriptor, SqlTypeDescriptorIndicators stdIndicators, Supplier<BasicJavaDescriptor> reflectedJtdResolver, final TypeConfiguration typeConfiguration) {
        InferredBasicValueResolver resolution = new InferredBasicValueResolver(explicitJtdAccess, explicitStdAccess, typeConfiguration);
        if (attributeConverterDescriptor != null) {
            Class converterDomainJavaType = attributeConverterDescriptor.getDomainValueResolvedType().getErasedType();
            JavaTypeDescriptor converterDomainJtd = typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(converterDomainJavaType);
            if (resolution.getDomainJtd() == null) {
                resolution.setDomainJtd((BasicJavaDescriptor)converterDomainJtd);
            } else if (!resolution.getDomainJtd().equals(converterDomainJtd)) {
                throw new HibernateException("JavaTypeDescriptors did not match between BasicTypeParameters#getJavaTypeDescriptor and BasicTypeParameters#getAttributeConverterDefinition#getDomainType");
            }
            Class converterRelationalJavaType = attributeConverterDescriptor.getRelationalValueResolvedType().getErasedType();
            resolution.setRelationalJtd((BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(converterRelationalJavaType));
            SqlTypeDescriptor converterHintedStd = resolution.getRelationalJtd().getJdbcRecommendedSqlType(stdIndicators);
            if (resolution.getRelationalStd() == null) {
                resolution.setRelationalStd(converterHintedStd);
            } else if (!resolution.getRelationalStd().equals(converterHintedStd)) {
                throw new HibernateException("SqlTypeDescriptors did not match between BasicTypeParameters#getSqlTypeDescriptor and BasicTypeParameters#getAttributeConverterDefinition#getJdbcType");
            }
            resolution.setValueConverter(attributeConverterDescriptor.createJpaAttributeConverter(new JpaAttributeConverterCreationContext(){

                @Override
                public ManagedBeanRegistry getManagedBeanRegistry() {
                    return typeConfiguration.getServiceRegistry().getService(ManagedBeanRegistry.class);
                }

                @Override
                public JavaTypeDescriptorRegistry getJavaTypeDescriptorRegistry() {
                    return typeConfiguration.getJavaTypeDescriptorRegistry();
                }
            }));
        } else {
            if (resolution.getDomainJtd() == null) {
                resolution.setDomainJtd(reflectedJtdResolver.get());
            }
            if (resolution.getDomainJtd() instanceof EnumJavaDescriptor) {
                EnumJavaDescriptor enumJavaDescriptor = (EnumJavaDescriptor)resolution.getDomainJtd();
                EnumType enumType = stdIndicators.getEnumeratedType() != null ? stdIndicators.getEnumeratedType() : typeConfiguration.getMetadataBuildingContext().getBuildingOptions().getImplicitEnumType();
                switch (enumType) {
                    case STRING: {
                        resolution.setRelationalJtd((BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(String.class));
                        resolution.setValueConverter(new NamedEnumValueConverter(enumJavaDescriptor, typeConfiguration));
                        break;
                    }
                    case ORDINAL: {
                        resolution.setRelationalJtd((BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(Integer.class));
                        resolution.setValueConverter(new OrdinalEnumValueConverter(enumJavaDescriptor, typeConfiguration));
                        break;
                    }
                    default: {
                        throw new HibernateException("Unknown EnumType : " + enumType);
                    }
                }
            } else if (resolution.getDomainJtd() instanceof TemporalJavaDescriptor && stdIndicators.getTemporalPrecision() != null) {
                resolution.setDomainJtd(((TemporalJavaDescriptor)resolution.getDomainJtd()).resolveTypeForPrecision(stdIndicators.getTemporalPrecision(), typeConfiguration));
            }
        }
        if (resolution.getRelationalStd() == null) {
            if (resolution.getRelationalJtd() == null) {
                if (resolution.getDomainJtd() == null) {
                    throw new IllegalArgumentException("Could not determine JavaTypeDescriptor nor SqlTypeDescriptor to use");
                }
                resolution.setRelationalJtd(resolution.getDomainJtd());
            }
            resolution.setRelationalStd(resolution.getRelationalJtd().getJdbcRecommendedSqlType(stdIndicators));
        } else if (resolution.getRelationalJtd() == null) {
            resolution.setRelationalJtd(resolution.getRelationalStd().getJdbcRecommendedJavaTypeMapping(typeConfiguration));
            if (resolution.getDomainJtd() == null) {
                resolution.setDomainJtd(resolution.getRelationalJtd());
            }
        }
        return resolution.build();
    }

    @Override
    public boolean isNationalized() {
        return this.isNationalized;
    }

    @Override
    public boolean isLob() {
        return this.isLob;
    }

    public EnumType getEnumType() {
        return this.enumType;
    }

    @Override
    public TemporalType getTemporalPrecision() {
        return this.temporalPrecision;
    }

    public SqlTypeDescriptor getExplicitSqlType() {
        return this.sqlTypeDescriptor;
    }

    public BasicJavaDescriptor getExplicitJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    public void setJpaAttributeConverterDescriptor(ConverterDescriptor attributeConverterDescriptor) {
        this.attributeConverterDescriptor = attributeConverterDescriptor;
    }

    public void makeNationalized() {
        this.isNationalized = true;
    }

    public void makeLob() {
        this.isLob = true;
    }

    public void setEnumType(EnumType enumType) {
        this.enumType = enumType;
    }

    public void setTemporalPrecision(TemporalType temporalPrecision) {
        this.temporalPrecision = temporalPrecision;
    }

    public void setExplicitSqlTypeAccess(Function<TypeConfiguration, SqlTypeDescriptor> sqlTypeAccess) {
        this.explicitSqlTypeAccess = sqlTypeAccess;
    }

    public void setExplicitMutabilityPlan(MutabilityPlan explicitMutabilityPlan) {
        this.explicitMutabilityPlan = explicitMutabilityPlan;
    }

    @Override
    public void addColumn(Column column) {
        if (this.getMappedColumns().size() > 0 && !this.getMappedColumn().equals(column)) {
            throw new MappingException("Attempt to add additional MappedColumn to BasicValueMapping " + column.getName());
        }
        super.addColumn(column);
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    public void setJavaClass(Class resolvedJavaClass) {
        this.resolvedJavaClass = resolvedJavaClass;
    }

    @Override
    public void addFormula(Formula formula) {
        if (this.getMappedColumns().size() > 0) {
            throw new MappingException("Attempt to add additional MappedColumn to BasicValueMapping");
        }
        super.addFormula(formula);
    }

    @Override
    public void setExplicitTypeName(String typeName) {
        if (typeName != null && typeName.startsWith("converted::")) {
            String converterClassName = typeName.substring("converted::".length());
            ClassLoaderService cls = this.getMetadataBuildingContext().getMetadataCollector().getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
            try {
                Class converterClass = cls.classForName(converterClassName);
                this.attributeConverterDescriptor = new ClassBasedConverterDescriptor(converterClass, false, this.getMetadataBuildingContext().getBootstrapContext().getClassmateContext());
                return;
            }
            catch (Exception e) {
                log.logBadHbmAttributeConverterType(typeName, e.getMessage());
            }
        }
        super.setExplicitTypeName(typeName);
    }

    @Override
    public boolean isTypeSpecified() {
        return true;
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        this.ownerName = className;
        this.propertyName = propertyName;
    }

    public <T> void setJavaTypeDescriptor(BasicJavaDescriptor<T> javaDescriptor) {
        this.javaTypeDescriptor = javaDescriptor;
    }

    public <T> void setExplicitJavaTypeAccess(Function<TypeConfiguration, BasicJavaDescriptor<T>> access) {
        this.explicitJavaTypeAccess = access;
    }

    @Override
    public EnumType getEnumeratedType() {
        return this.enumType;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.preferredJdbcTypeCodeForBoolean;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public void setExplicitTypeParams(Map explicitLocalTypeParams) {
        this.explicitLocalTypeParams = explicitLocalTypeParams;
    }

    static class BasicJavaTypeMapping
    implements JavaTypeMapping {
        private final BasicValue basicValue;

        BasicJavaTypeMapping(BasicValue basicValue) {
            this.basicValue = basicValue;
        }

        public Class getJavaClass() {
            return this.getJavaTypeDescriptor().getClass();
        }

        @Override
        public String getTypeName() {
            String typeName = this.basicValue.getTypeName();
            if (typeName != null) {
                return typeName;
            }
            return this.getJavaTypeDescriptor().getTypeName();
        }

        public JavaTypeDescriptor getJavaTypeDescriptor() {
            if (this.basicValue.resolution == null) {
                throw new NotYetResolvedException("JavaTypeDescriptor not yet resolved");
            }
            return this.basicValue.resolution.getDomainJavaDescriptor();
        }
    }

    class ValueConverterCollector
    implements Consumer<BasicValueConverter> {
        private BasicValueConverter basicValueConverter;

        ValueConverterCollector() {
        }

        public BasicValueConverter getBasicValueConverter() {
            return this.basicValueConverter;
        }

        public void setBasicValueConverter(BasicValueConverter basicValueConverter) {
            this.basicValueConverter = basicValueConverter;
        }

        @Override
        public void accept(BasicValueConverter valueConverter) {
            this.setBasicValueConverter(valueConverter);
        }
    }
}

