/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.Locale;
import java.util.function.Supplier;
import org.hibernate.boot.model.domain.JavaTypeMapping;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Selectable;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.metamodel.model.relational.spi.PhysicalNamingStrategy;
import org.hibernate.metamodel.model.relational.spi.Size;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.naming.Identifier;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.sql.Template;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class Column
implements Selectable,
Serializable,
Cloneable {
    private Identifier tableName;
    private Identifier name;
    private Supplier<SqlTypeDescriptor> sqlTypeDescriptorAccess;
    private JavaTypeMapping javaTypeMapping;
    private String sqlType;
    private int uniqueInteger;
    private boolean quoted;
    private Long length;
    private Integer precision;
    private Integer scale;
    private boolean nullable = true;
    private boolean unique;
    private String checkConstraint;
    private String comment;
    private String defaultValue;
    private String customWrite;
    private String customRead;
    private boolean isInsertable = true;
    private boolean isUpdatable = true;
    private static final Logger log = Logger.getLogger(Column.class);

    public Column(Identifier tableName, String columnName, boolean isUnique) {
        this(Identifier.toIdentifier(columnName), isUnique);
        this.tableName = tableName;
    }

    public Column(Identifier tableName, Identifier columnName, boolean isUnique) {
        this(columnName, isUnique);
        this.tableName = tableName;
    }

    public Column(Identifier columnName, boolean isUnique) {
        this.setName(columnName);
        this.setUnique(isUnique);
    }

    @Override
    public boolean isInsertable() {
        return this.isInsertable;
    }

    public void setInsertable(boolean insertable) {
        this.isInsertable = insertable;
    }

    @Override
    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public void setUpdatable(boolean updatable) {
        this.isUpdatable = updatable;
    }

    public Identifier getName() {
        return this.name;
    }

    public Identifier getTableName() {
        return this.tableName;
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public void setTableName(Identifier tableName) {
        this.tableName = tableName;
    }

    public void setName(Identifier columnName) {
        this.name = columnName;
        if (columnName != null) {
            this.quoted = columnName.isQuoted();
        }
    }

    public int getUniqueInteger() {
        return this.uniqueInteger;
    }

    public void setUniqueInteger(int uniqueInteger) {
        this.uniqueInteger = uniqueInteger;
    }

    public String getQuotedName() {
        return this.name.render();
    }

    public String getQuotedName(Dialect d) {
        return this.name.render(d);
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int hashCode() {
        return this.tableName.hashCode() + this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Column && this.equals((Column)object);
    }

    public boolean equals(Column column) {
        if (null == column) {
            return false;
        }
        if (this == column) {
            return true;
        }
        return this.tableName.equals(column.tableName) && this.name.equals(column.name);
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    private void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public String toString() {
        return String.format(Locale.ROOT, "Boot-model physical Column : %s.%s", this.getTableName(), this.getName());
    }

    public String getCheckConstraint() {
        return this.checkConstraint;
    }

    public void setCheckConstraint(String checkConstraint) {
        this.checkConstraint = checkConstraint;
    }

    @Override
    public String getTemplate(Dialect dialect, SqmFunctionRegistry functionRegistry) {
        return StringHelper.safeInterning(this.hasCustomRead() ? Template.renderTransformerReadFragment(this.customRead, this.getQuotedName(dialect)) : "$PlaceHolder$." + this.name.render(dialect));
    }

    public boolean hasCustomRead() {
        return this.customRead != null;
    }

    public String getReadExpr(Dialect dialect) {
        return this.hasCustomRead() ? this.customRead : this.name.render(dialect);
    }

    public String getWriteExpr() {
        return this.customWrite != null && this.customWrite.length() > 0 ? this.customWrite : "?";
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public String getText(Dialect dialect) {
        return this.name.render(dialect);
    }

    @Override
    public String getText() {
        return this.name.getText();
    }

    @Override
    public SqlTypeDescriptor getSqlTypeDescriptor() {
        return this.sqlTypeDescriptorAccess.get();
    }

    protected BasicJavaDescriptor getJavaTypeDescriptor() {
        return (BasicJavaDescriptor)this.javaTypeMapping.getJavaTypeDescriptor();
    }

    @Override
    public void setSqlTypeDescriptorAccess(Supplier<SqlTypeDescriptor> sqlTypeDescriptorAccess) {
        this.sqlTypeDescriptorAccess = sqlTypeDescriptorAccess;
    }

    @Override
    public JavaTypeMapping getJavaTypeMapping() {
        return this.javaTypeMapping;
    }

    @Override
    public void setJavaTypeMapping(JavaTypeMapping javaTypeMapping) {
        this.javaTypeMapping = javaTypeMapping;
    }

    @Override
    public PhysicalColumn generateRuntimeColumn(Table runtimeTable, PhysicalNamingStrategy namingStrategy, JdbcEnvironment jdbcEnvironment, TypeConfiguration typeConfiguration) {
        String columnSqlType;
        Identifier physicalName = namingStrategy.toPhysicalColumnName(this.getName(), jdbcEnvironment);
        log.debugf("Creating runtime column `%s.%s`", (Object)runtimeTable.getTableExpression(), (Object)physicalName.getText());
        Dialect dialect = jdbcEnvironment.getDialect();
        Size size = new Size.Builder().setLength(this.getLength()).setPrecision(this.getPrecision()).setScale(this.getScale()).build();
        if (size.getLength() == null && size.getScale() == null && size.getPrecision() == null) {
            size = dialect.getDefaultSizeStrategy().resolveDefaultSize(this.getSqlTypeDescriptor(), this.getJavaTypeDescriptor());
        }
        if ((columnSqlType = this.getSqlType()) == null) {
            columnSqlType = dialect.getTypeName(this.getSqlTypeDescriptor().getJdbcTypeCode(), size);
        }
        SqlTypeDescriptor sqlTypeDescriptor = this.getSqlTypeDescriptor();
        BasicJavaDescriptor javaTypeDescriptor = this.getJavaTypeDescriptor();
        PhysicalColumn column = new PhysicalColumn(runtimeTable, physicalName, () -> sqlTypeDescriptor, () -> javaTypeDescriptor, this.getDefaultValue(), columnSqlType, this.isNullable(), this.isUnique(), this.getComment(), typeConfiguration, this.isInsertable, this.isUpdatable);
        column.setSize(size);
        column.setCheckConstraint(this.getCheckConstraint());
        return column;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer scale) {
        this.precision = scale;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getCustomWrite() {
        return this.customWrite;
    }

    public void setCustomWrite(String customWrite) {
        this.customWrite = StringHelper.safeInterning(customWrite);
    }

    public String getCustomRead() {
        return this.customRead;
    }

    public void setCustomRead(String customRead) {
        this.customRead = StringHelper.safeInterning(StringHelper.nullIfEmpty(customRead));
    }

    public String getCanonicalName() {
        return this.name.getCanonicalName();
    }

    public Column clone() {
        Column copy = new Column(this.name, this.unique);
        copy.setTableName(this.tableName);
        copy.setLength(this.length);
        copy.setScale(this.scale);
        copy.setNullable(this.nullable);
        copy.setPrecision(this.precision);
        copy.setSqlType(this.sqlType);
        copy.setUniqueInteger(this.uniqueInteger);
        copy.setCheckConstraint(this.checkConstraint);
        copy.setComment(this.comment);
        copy.setDefaultValue(this.defaultValue);
        copy.setCustomRead(this.customRead);
        copy.setCustomWrite(this.customWrite);
        copy.setSqlTypeDescriptorAccess(this.sqlTypeDescriptorAccess);
        copy.setJavaTypeMapping(this.javaTypeMapping);
        return copy;
    }
}

