/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.persistence.metamodel.Type;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.EmbeddableJavaTypeMapping;
import org.hibernate.boot.model.domain.JavaTypeMapping;
import org.hibernate.boot.model.domain.ManagedTypeMapping;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.boot.model.domain.internal.EmbeddableJavaTypeMappingImpl;
import org.hibernate.boot.model.domain.spi.EmbeddedValueMappingImplementor;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.CompositeNestedGeneratedValueGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.PropertyContainer;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.hibernate.metamodel.model.domain.spi.EmbeddedContainer;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.type.descriptor.java.internal.EmbeddableJavaDescriptorImpl;
import org.hibernate.type.descriptor.java.spi.EmbeddableJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;

public class Component
extends SimpleValue
implements EmbeddedValueMappingImplementor,
PropertyContainer,
MetaAttributable {
    TreeMap<String, PersistentAttributeMapping> declaredAttributeMappings;
    private String componentClassName;
    private boolean embedded;
    private String parentProperty;
    private PersistentClass owner;
    private boolean dynamic;
    private Map<String, MetaAttribute> metaAttributes;
    private boolean isKey;
    private String roleName;
    private EmbeddableJavaTypeMapping javaTypeMapping;
    private Integer columnSpan;
    private IdentifierGenerator builtIdentifierGenerator;

    public Component(MetadataBuildingContext metadata, PersistentClass owner) throws MappingException {
        this(metadata, owner.getMappedTable(), owner);
    }

    public Component(MetadataBuildingContext metadata, Component component) throws MappingException {
        this(metadata, component.getMappedTable(), component.getOwner());
    }

    public Component(MetadataBuildingContext metadata, Join join) throws MappingException {
        this(metadata, join.getMappedTable(), join.getPersistentClass());
    }

    public Component(MetadataBuildingContext metadata, Collection collection) throws MappingException {
        this(metadata, collection.getMappedTable(), collection.getOwner());
    }

    public Component(MetadataBuildingContext metadata, MappedTable table, PersistentClass owner) throws MappingException {
        super(metadata, table);
        this.owner = owner;
    }

    @Override
    public JavaTypeMapping getJavaTypeMapping() {
        if (this.javaTypeMapping == null) {
            this.javaTypeMapping = new EmbeddableJavaTypeMappingImpl(this.getMetadataBuildingContext(), this.getName(), this.componentClassName, null);
        }
        return this.javaTypeMapping;
    }

    @Override
    public String getName() {
        if (this.roleName != null) {
            return this.roleName;
        }
        return this.componentClassName;
    }

    @Override
    public RepresentationMode getExplicitRepresentationMode() {
        return null;
    }

    @Override
    public void setExplicitRepresentationMode(RepresentationMode mode) {
        throw new UnsupportedOperationException("Support for ManagedType-specific explicit RepresentationMode not yet implemented");
    }

    @Deprecated
    public int getPropertySpan() {
        return this.getDeclaredPersistentAttributes().size();
    }

    @Deprecated
    public Iterator getPropertyIterator() {
        return this.getDeclaredPersistentAttributes().iterator();
    }

    @Deprecated
    public void addProperty(Property p) {
        this.addDeclaredPersistentAttribute(p);
    }

    @Override
    public void addColumn(Column column) {
        throw new UnsupportedOperationException("Cant add a column to a component");
    }

    @Override
    public int getColumnSpan() {
        if (this.columnSpan == null) {
            int i = 0;
            for (PersistentAttributeMapping persistentAttributeMapping : this.getDeclaredPersistentAttributes()) {
                i += persistentAttributeMapping.getValueMapping().getMappedColumns().size();
            }
            this.columnSpan = i;
        }
        return this.columnSpan;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    @Deprecated
    public String getComponentClassName() {
        return this.getEmbeddableClassName();
    }

    @Override
    public String getEmbeddableClassName() {
        return this.componentClassName;
    }

    public Class getComponentClass() throws MappingException {
        ClassLoaderService classLoaderService = this.getMetadataBuildingContext().getBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
        try {
            return classLoaderService.classForName(this.componentClassName);
        }
        catch (ClassLoadingException e) {
            throw new MappingException("component class not found: " + this.componentClassName, (Throwable)((Object)e));
        }
    }

    public PersistentClass getOwner() {
        return this.owner;
    }

    public String getParentProperty() {
        return this.parentProperty;
    }

    public void setComponentClassName(String componentClass) {
        this.componentClassName = componentClass;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setOwner(PersistentClass owner) {
        this.owner = owner;
    }

    public void setParentProperty(String parentProperty) {
        this.parentProperty = parentProperty;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    @Override
    public <X> EmbeddedTypeDescriptor<X> makeRuntimeDescriptor(EmbeddedContainer embeddedContainer, String localName, SingularPersistentAttribute.Disposition disposition, RuntimeModelCreationContext context) {
        return context.getRuntimeModelDescriptorFactory().createEmbeddedTypeDescriptor(this, embeddedContainer, null, localName, disposition, context);
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
    }

    @Override
    public Map<String, MetaAttribute> getMetaAttributes() {
        return this.metaAttributes;
    }

    @Override
    public MetaAttribute getMetaAttribute(String attributeName) {
        return this.metaAttributes == null ? null : this.metaAttributes.get(attributeName);
    }

    @Override
    public void setMetaAttributes(Map<String, MetaAttribute> metas) {
        this.metaAttributes = metas;
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean isSame(SimpleValue other) {
        return other instanceof Component && this.isSame((Component)other);
    }

    public boolean isSame(Component other) {
        return super.isSame(other) && Objects.equals(this.componentClassName, other.componentClassName) && this.embedded == other.embedded && Objects.equals(this.parentProperty, other.parentProperty) && Objects.equals(this.metaAttributes, other.metaAttributes);
    }

    @Override
    public boolean[] getColumnInsertability() {
        boolean[] result = new boolean[this.getColumnSpan()];
        List<PersistentAttributeMapping> declaredPersistentAttributes = this.getDeclaredPersistentAttributes();
        for (int i = 0; i < declaredPersistentAttributes.size(); ++i) {
            PersistentAttributeMapping prop = declaredPersistentAttributes.get(i);
            boolean[] chunk = ((Property)prop).getValue().getColumnInsertability();
            if (prop.isInsertable()) {
                System.arraycopy(chunk, 0, result, i, chunk.length);
            }
            i += chunk.length;
        }
        return result;
    }

    @Override
    public boolean[] getColumnUpdateability() {
        boolean[] result = new boolean[this.getColumnSpan()];
        List<PersistentAttributeMapping> attributes = this.getDeclaredPersistentAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            PersistentAttributeMapping prop = attributes.get(i);
            boolean[] chunk = ((Property)prop).getValue().getColumnUpdateability();
            if (prop.isUpdateable()) {
                System.arraycopy(chunk, 0, result, i, chunk.length);
            }
            i += chunk.length;
        }
        return result;
    }

    @Override
    public List<MappedColumn> getMappedColumns() {
        ArrayList<MappedColumn> columns = new ArrayList<MappedColumn>();
        if (this.declaredAttributeMappings != null) {
            for (PersistentAttributeMapping p : this.declaredAttributeMappings.values()) {
                columns.addAll(p.getValueMapping().getMappedColumns());
            }
        }
        return columns;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean isKey) {
        this.isKey = isKey;
    }

    public boolean hasPojoRepresentation() {
        return this.componentClassName != null;
    }

    @Deprecated
    public Property getProperty(String propertyName) throws MappingException {
        Iterator iter = this.getPropertyIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (!prop.getName().equals(propertyName)) continue;
            return prop;
        }
        throw new MappingException("component property not found: " + propertyName);
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "%s( %s : %s )", this.getClass().getSimpleName(), this.getRoleName(), this.getTypeName());
    }

    @Override
    public IdentifierGenerator createIdentifierGenerator(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, String defaultCatalog, String defaultSchema, RootClass rootClass) throws MappingException {
        if (this.builtIdentifierGenerator == null) {
            this.builtIdentifierGenerator = this.buildIdentifierGenerator(identifierGeneratorFactory, dialect, defaultCatalog, defaultSchema, rootClass);
        }
        return this.builtIdentifierGenerator;
    }

    private IdentifierGenerator buildIdentifierGenerator(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, String defaultCatalog, String defaultSchema, RootClass rootClass) throws MappingException {
        boolean hasCustomGenerator;
        boolean bl = hasCustomGenerator = !"assigned".equals(this.getIdentifierGeneratorStrategy());
        if (hasCustomGenerator) {
            return super.createIdentifierGenerator(identifierGeneratorFactory, dialect, defaultCatalog, defaultSchema, rootClass);
        }
        Class entityClass = rootClass.getMappedClass();
        Class attributeDeclarer = rootClass.getEntityMappingHierarchy().getIdentifierEmbeddedValueMapping() != null ? this.resolveComponentClass() : (rootClass.getIdentifierAttributeMapping() != null ? this.resolveComponentClass() : entityClass);
        StandardGenerationContextLocator locator = new StandardGenerationContextLocator(rootClass.getEntityName());
        CompositeNestedGeneratedValueGenerator generator = new CompositeNestedGeneratedValueGenerator(locator);
        List<PersistentAttributeMapping> declaredPersistentAttributes = this.getDeclaredPersistentAttributes();
        declaredPersistentAttributes.stream().filter(attribute -> SimpleValue.class.isInstance(attribute.getValueMapping())).forEach(attribute -> {
            SimpleValue value = (SimpleValue)attribute.getValueMapping();
            if (!"assigned".equals(value.getIdentifierGeneratorStrategy())) {
                IdentifierGenerator valueGenerator = value.createIdentifierGenerator(identifierGeneratorFactory, dialect, defaultCatalog, defaultSchema, rootClass);
                generator.addGeneratedValuePlan(new ValueGenerationPlan(valueGenerator, this.injector((Property)attribute, attributeDeclarer)));
            }
        });
        return generator;
    }

    private Setter injector(Property property, Class attributeDeclarer) {
        return property.getPropertyAccessStrategy(attributeDeclarer).buildPropertyAccess(attributeDeclarer, property.getName()).getSetter();
    }

    private Class resolveComponentClass() {
        try {
            return this.getComponentClass();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void addDeclaredPersistentAttribute(PersistentAttributeMapping attribute) {
        if (this.declaredAttributeMappings == null) {
            this.declaredAttributeMappings = new TreeMap();
        } else assert (!this.declaredAttributeMappings.containsKey(attribute.getName()));
        this.declaredAttributeMappings.put(attribute.getName(), attribute);
    }

    @Override
    public void setSuperManagedType(ManagedTypeMapping superTypeMapping) {
        throw new UnsupportedOperationException("Inheritance not yet supported for composite/embeddable values");
    }

    @Override
    @Deprecated
    public List<Property> getDeclaredProperties() {
        return this.declaredAttributeMappings == null ? Collections.emptyList() : this.declaredAttributeMappings.values().stream().map(p -> (Property)p).collect(Collectors.toList());
    }

    @Override
    public List<PersistentAttributeMapping> getDeclaredPersistentAttributes() {
        return this.declaredAttributeMappings == null ? Collections.emptyList() : new ArrayList<PersistentAttributeMapping>(this.declaredAttributeMappings.values());
    }

    @Override
    public List<PersistentAttributeMapping> getPersistentAttributes() {
        ArrayList<PersistentAttributeMapping> attributes = new ArrayList<PersistentAttributeMapping>();
        attributes.addAll(this.getDeclaredPersistentAttributes());
        for (ManagedTypeMapping superTypeMapping = this.getSuperManagedTypeMapping(); superTypeMapping != null; superTypeMapping = superTypeMapping.getSuperManagedTypeMapping()) {
            attributes.addAll(superTypeMapping.getPersistentAttributes());
        }
        return attributes;
    }

    @Override
    public PersistentAttributeMapping getDeclaredPersistentAttribute(String attributeName) {
        return this.declaredAttributeMappings.get(attributeName);
    }

    @Override
    @Deprecated
    public PropertyContainer getSuperPropertyContainer() {
        return null;
    }

    @Override
    public ManagedTypeMapping getSuperManagedTypeMapping() {
        return null;
    }

    @Override
    public List<ManagedTypeMapping> getSuperManagedTypeMappings() {
        return null;
    }

    @Override
    public boolean hasPersistentAttribute(String name) {
        return this.hasDeclaredPersistentAttribute(name);
    }

    @Override
    public boolean hasDeclaredPersistentAttribute(String name) {
        for (PersistentAttributeMapping attribute : this.getDeclaredPersistentAttributes()) {
            if (!attribute.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    private static EmbeddableJavaDescriptor resolveJavaTypeDescriptor(MetadataBuildingContext metadata, String componentClassName) {
        JavaTypeDescriptorRegistry javaTypeDescriptorRegistry = metadata.getMetadataCollector().getTypeConfiguration().getJavaTypeDescriptorRegistry();
        EmbeddableJavaDescriptorImpl typeDescriptor = (EmbeddableJavaDescriptorImpl)javaTypeDescriptorRegistry.getDescriptor(componentClassName);
        if (typeDescriptor == null) {
            Class javaType = StringHelper.isEmpty(componentClassName) ? null : metadata.getBootstrapContext().getServiceRegistry().getService(ClassLoaderService.class).classForName(componentClassName);
            typeDescriptor = new EmbeddableJavaDescriptorImpl(componentClassName, javaType, null);
            javaTypeDescriptorRegistry.addDescriptor(typeDescriptor);
        } else if (!typeDescriptor.isInstance(EmbeddableJavaDescriptor.class)) {
            typeDescriptor = new EmbeddableJavaDescriptorImpl(componentClassName, typeDescriptor.getJavaType(), null);
        }
        return typeDescriptor;
    }

    public static class ValueGenerationPlan
    implements CompositeNestedGeneratedValueGenerator.GenerationPlan {
        private final IdentifierGenerator subGenerator;
        private final Setter injector;

        public ValueGenerationPlan(IdentifierGenerator subGenerator, Setter injector) {
            this.subGenerator = subGenerator;
            this.injector = injector;
        }

        @Override
        public void execute(SharedSessionContractImplementor session, Object incomingObject, Object injectionContext) {
            Object generatedValue = this.subGenerator.generate(session, incomingObject);
            this.injector.set(injectionContext, generatedValue, session.getFactory());
        }

        @Override
        public void registerExportables(Database database) {
            if (ExportableProducer.class.isInstance(this.subGenerator)) {
                ((ExportableProducer)((Object)this.subGenerator)).registerExportables(database);
            }
        }
    }

    public static class StandardGenerationContextLocator
    implements CompositeNestedGeneratedValueGenerator.GenerationContextLocator {
        private final String entityName;

        public StandardGenerationContextLocator(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public Object locateGenerationContext(SharedSessionContractImplementor session, Object incomingObject) {
            return session.getEntityDescriptor(this.entityName, incomingObject).getHierarchy().getIdentifierDescriptor().extractIdentifier(incomingObject);
        }
    }
}

