/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedConstraint;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

public abstract class Constraint
implements MappedConstraint,
Serializable {
    private String name;
    private final List<MappedColumn> columns = new ArrayList<MappedColumn>();
    private MappedTable table;
    private boolean creationEnabled = true;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void disableCreation() {
        this.creationEnabled = false;
    }

    @Override
    public boolean isCreationEnabled() {
        return this.creationEnabled;
    }

    public static String generateName(String prefix, MappedTable table, List<MappedColumn> mappedColumns) {
        List<Column> columns = mappedColumns.stream().filter(column -> !column.isFormula()).map(Column.class::cast).collect(Collectors.toList());
        return Constraint.generateNameFromColumns(prefix, table, columns);
    }

    private static String generateNameFromColumns(String prefix, MappedTable table, List<Column> columns) {
        StringBuilder sb = new StringBuilder("table`" + table.getName() + "`");
        ArrayList<Column> alphabeticalColumns = new ArrayList<Column>(columns);
        alphabeticalColumns.sort(ColumnComparator.INSTANCE);
        for (Column column : alphabeticalColumns) {
            String columnName = column == null ? "" : column.getName().getText();
            sb.append("column`").append(columnName).append("`");
        }
        return prefix + Constraint.hashedName(sb.toString());
    }

    public static String hashedName(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(s.getBytes());
            byte[] digest = md.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            return bigInt.toString(35);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HibernateException("Unable to generate a hashed Constraint name!", e);
        }
    }

    @Deprecated
    public void addColumn(Column column) {
        this.addColumn((MappedColumn)column);
    }

    @Override
    public void addColumn(MappedColumn column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
            if (column.isFormula()) {
                this.disableCreation();
            }
        }
    }

    @Deprecated
    public void addColumns(Iterator columnIterator) {
        while (columnIterator.hasNext()) {
            this.addColumn((MappedColumn)columnIterator.next());
        }
    }

    @Override
    public void addColumns(List<? extends MappedColumn> columns) {
        columns.stream().forEach(this::addColumn);
    }

    public boolean containsColumn(Column column) {
        return this.columns.contains(column);
    }

    @Override
    public Column getColumn(int i) {
        return (Column)this.columns.get(i);
    }

    <T> Iterator<T> cast(Iterator itr) {
        return itr;
    }

    @Deprecated
    public Table getTable() {
        return (Table)this.getMappedTable();
    }

    @Deprecated
    public void setTable(MappedTable table) {
        this.setMappedTable(table);
    }

    @Override
    public MappedTable getMappedTable() {
        return this.table;
    }

    @Override
    public void setMappedTable(MappedTable table) {
        this.table = table;
    }

    public boolean isGenerated(Dialect dialect) {
        return true;
    }

    @Override
    public List<MappedColumn> getColumns() {
        return this.cast(this.columns);
    }

    private <T> List<T> cast(List values) {
        return values;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getMappedTable().getName() + this.getColumns() + ") as " + this.name;
    }

    public static class ColumnComparator
    implements Comparator<Column> {
        public static ColumnComparator INSTANCE = new ColumnComparator();

        @Override
        public int compare(Column col1, Column col2) {
            return col1.getName().compareTo(col2.getName());
        }
    }
}

