/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.boot.model.relational.DenormalizedMappedTable;
import org.hibernate.boot.model.relational.MappedForeignKey;
import org.hibernate.boot.model.relational.MappedIndex;
import org.hibernate.boot.model.relational.MappedNamespace;
import org.hibernate.boot.model.relational.MappedPrimaryKey;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.model.relational.MappedUniqueKey;
import org.hibernate.internal.util.JavaTypeHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Table;
import org.hibernate.naming.Identifier;

public class DenormalizedTable
extends Table
implements DenormalizedMappedTable<Column> {
    private final MappedTable<Column> includedTable;

    public DenormalizedTable(MappedNamespace namespace, Identifier tableName, boolean isAbstract, MappedTable includedTable) {
        super(namespace, tableName, isAbstract);
        this.includedTable = includedTable;
        includedTable.setHasDenormalizedTables();
    }

    public DenormalizedTable(MappedNamespace namespace, Identifier tableName, String subselectFragment, boolean isAbstract, MappedTable includedTable) {
        super(namespace, tableName, subselectFragment, isAbstract);
        this.includedTable = includedTable;
        includedTable.setHasDenormalizedTables();
    }

    public DenormalizedTable(MappedNamespace namespace, String subselect, boolean isAbstract, MappedTable includedTable) {
        super(namespace, subselect, isAbstract);
        this.includedTable = includedTable;
        includedTable.setHasDenormalizedTables();
    }

    @Override
    public void createForeignKeys() {
        this.includedTable.createForeignKeys();
        for (MappedForeignKey fk : this.includedTable.getForeignKeys()) {
            this.createForeignKey(Constraint.generateName(fk.generatedConstraintNamePrefix(), this, fk.getColumns()), fk.getColumns(), fk.getReferencedEntityName(), fk.getKeyDefinition(), fk.getReferencedColumns());
        }
    }

    @Override
    public Column getColumn(Column column) {
        Column superColumn = super.getColumn(column);
        if (superColumn != null) {
            return superColumn;
        }
        return this.includedTable.getColumn(column);
    }

    @Override
    public Column getColumn(Identifier name) {
        Column superColumn = super.getColumn(name);
        if (superColumn != null) {
            return superColumn;
        }
        return this.includedTable.getColumn(name);
    }

    @Override
    public Iterator getColumnIterator() {
        return this.getMappedColumns().iterator();
    }

    @Override
    public Set<Column> getMappedColumns() {
        HashSet<Column> mappedColumns = new HashSet<Column>();
        mappedColumns.addAll(this.includedTable.getMappedColumns());
        mappedColumns.addAll(super.getMappedColumns());
        return Collections.unmodifiableSet(mappedColumns);
    }

    @Override
    public boolean containsColumn(Column column) {
        return super.containsColumn(column) || this.includedTable.containsColumn(column);
    }

    @Override
    public MappedPrimaryKey getPrimaryKey() {
        return this.includedTable.getPrimaryKey();
    }

    public Iterator getUniqueKeyIterator() {
        return this.getUniqueKeys().iterator();
    }

    @Override
    public Collection<MappedUniqueKey> getUniqueKeys() {
        this.includedTable.getUniqueKeys().forEach(uniqueKey -> this.createUniqueKey((List)JavaTypeHelper.cast(uniqueKey.getColumns())));
        return super.getUniqueKeys();
    }

    public Iterator getIndexIterator() {
        return this.getIndexes().iterator();
    }

    @Override
    public Collection<MappedIndex> getIndexes() {
        ArrayList<MappedIndex> indexes = new ArrayList<MappedIndex>();
        indexes.addAll(this.includedTable.getIndexes());
        indexes.addAll(super.getIndexes());
        return indexes;
    }

    @Override
    @Deprecated
    public Table getIncludedTable() {
        return (Table)this.getIncludedMappedTable();
    }

    public MappedTable getIncludedMappedTable() {
        return this.includedTable;
    }
}

