/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.JavaTypeMapping;
import org.hibernate.boot.model.domain.ResolutionContext;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;

public class DependantValue
extends SimpleValue {
    private KeyValue wrappedValue;
    private boolean nullable;
    private boolean updateable;
    private boolean isNationalized;

    @Deprecated
    public DependantValue(MetadataBuildingContext metadata, Table table, KeyValue prototype) {
        this(metadata, (MappedTable)table, prototype);
    }

    public DependantValue(MetadataBuildingContext metadata, MappedTable table, KeyValue prototype) {
        super(metadata, table);
        this.registerResolver(metadata);
        this.wrappedValue = prototype;
    }

    private void registerResolver(MetadataBuildingContext metadata) {
        metadata.getMetadataCollector().registerValueMappingResolver(this::resolve);
    }

    @Override
    public JavaTypeMapping getJavaTypeMapping() {
        return this.wrappedValue.getJavaTypeMapping();
    }

    @Override
    public Boolean resolve(ResolutionContext context) {
        Iterator columnsIterator = this.columns.iterator();
        List<MappedColumn> wrappedValueColumns = this.wrappedValue.getMappedColumns();
        for (Column column : wrappedValueColumns) {
            if (column.getJavaTypeMapping() == null) {
                return false;
            }
            Column column2 = (Column)columnsIterator.next();
            column2.setJavaTypeMapping(column.getJavaTypeMapping());
            column2.setSqlTypeDescriptorAccess(column::getSqlTypeDescriptor);
        }
        return true;
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) {
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    public void makeNationalized() {
        this.isNationalized = true;
    }

    public boolean isNationalized() {
        return this.isNationalized;
    }

    @Override
    public boolean isSame(SimpleValue other) {
        return other instanceof DependantValue && this.isSame((DependantValue)other);
    }

    public boolean isSame(DependantValue other) {
        return super.isSame(other) && DependantValue.isSame(this.wrappedValue, other.wrappedValue);
    }

    @Override
    public ForeignKey createForeignKey() throws MappingException {
        return this.wrappedValue.createForeignKey();
    }

    public KeyValue getWrappedValue() {
        return this.wrappedValue;
    }
}

