/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedForeignKey;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.JavaTypeHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;

public class ForeignKey
extends Constraint
implements MappedForeignKey {
    private MappedTable referencedTable;
    private String referencedEntityName;
    private String keyDefinition;
    private boolean cascadeDeleteEnabled;
    private List<MappedColumn> referencedColumns = new ArrayList<MappedColumn>();

    @Override
    public void setName(String name) {
        super.setName(name);
        if ("none".equals(name)) {
            this.disableCreation();
        }
    }

    @Override
    public MappedTable getReferencedTable() {
        return this.referencedTable;
    }

    @Override
    public MappedTable getTargetTable() {
        return this.getMappedTable();
    }

    private void appendColumns(StringBuilder buf, List<Selectable> columns) {
        boolean firstPass = true;
        for (Selectable column : columns) {
            if (firstPass) {
                firstPass = false;
            } else {
                buf.append(',');
            }
            buf.append(column.getText());
        }
    }

    @Override
    public void setReferencedTable(MappedTable referencedTable) throws MappingException {
        this.referencedTable = referencedTable;
    }

    @Override
    public void alignColumns() {
        if (this.isReferenceToPrimaryKey()) {
            this.alignColumns(this.referencedTable);
        }
    }

    private void alignColumns(MappedTable referencedTable) {
        List columns = (List)JavaTypeHelper.cast(this.getColumns());
        List targetColumns = (List)JavaTypeHelper.cast(referencedTable.getPrimaryKey().getColumns());
        int referencedPkColumnSpan = targetColumns.size();
        if (referencedPkColumnSpan != columns.size()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Foreign key (").append(this.getName()).append(":").append(this.getMappedTable().getName()).append(" [");
            this.appendColumns(sb, columns);
            sb.append("])").append(") must have same number of columns as the referenced primary key (").append(referencedTable.getName()).append(" [");
            this.appendColumns(sb, targetColumns);
            sb.append("])");
            throw new MappingException(sb.toString());
        }
        for (int i = 0; i < columns.size(); ++i) {
            if (!(columns.get(i) instanceof Column) || !(targetColumns.get(i) instanceof Column)) continue;
            ((Column)columns.get(i)).setLength(((Column)targetColumns.get(i)).getLength());
        }
    }

    @Override
    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    @Override
    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    @Override
    public String getKeyDefinition() {
        return this.keyDefinition;
    }

    @Override
    public void setKeyDefinition(String keyDefinition) {
        this.keyDefinition = keyDefinition;
    }

    @Override
    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    public void setCascadeDeleteEnabled(boolean cascadeDeleteEnabled) {
        this.cascadeDeleteEnabled = cascadeDeleteEnabled;
    }

    @Override
    public boolean isPhysicalConstraint() {
        return this.isCreationEnabled() && this.referencedTable.isPhysicalTable() && this.getMappedTable().isPhysicalTable() && !this.referencedTable.hasDenormalizedTables();
    }

    @Override
    public List<MappedColumn> getReferencedColumns() {
        return this.referencedColumns;
    }

    @Override
    public List<MappedColumn> getTargetColumns() {
        if (this.referencedColumns != null && !this.referencedColumns.isEmpty()) {
            return this.referencedColumns;
        }
        return this.getReferencedTable().getPrimaryKey().getColumns();
    }

    @Override
    public boolean isReferenceToPrimaryKey() {
        return this.referencedColumns.isEmpty();
    }

    @Deprecated
    public void addReferencedColumns(Iterator referencedColumnsIterator) {
        while (referencedColumnsIterator.hasNext()) {
            Selectable col = (Selectable)referencedColumnsIterator.next();
            if (col.isFormula()) continue;
            this.addReferencedColumn((Column)col);
        }
    }

    @Override
    public void addReferencedColumns(List<? extends MappedColumn> referencedColumns) {
        this.addReferencedColumns(referencedColumns.iterator());
    }

    private void addReferencedColumn(Column column) {
        if (!this.referencedColumns.contains(column)) {
            this.referencedColumns.add(column);
        }
    }

    @Override
    public String generatedConstraintNamePrefix() {
        return "FK_";
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "Boot-model ForeignKey[ (%s) => (%s) ]", this.getColumns(), this.getReferencedColumns());
    }

    @Deprecated
    public String sqlConstraintString(Dialect dialect, String constraintName, String defaultCatalog, String defaultSchema) {
        if (this.isCreationEnabled()) {
            String[] columnNames = new String[this.getColumnSpan()];
            String[] referencedColumnNames = new String[this.getColumnSpan()];
            List<MappedColumn> targetColumns = this.getTargetColumns();
            List<MappedColumn> referencingColumns = this.getColumns();
            for (int i = 0; i < referencingColumns.size(); ++i) {
                columnNames[i] = ((Column)referencingColumns.get(i)).getName().render(dialect);
                referencedColumnNames[i] = ((Column)targetColumns.get(i)).getName().render(dialect);
            }
            String result = this.keyDefinition != null ? dialect.getAddForeignKeyConstraintString(constraintName, this.keyDefinition) : dialect.getAddForeignKeyConstraintString(constraintName, columnNames, ((Table)this.referencedTable).getQualifiedName(dialect, defaultCatalog, defaultSchema), referencedColumnNames, this.isReferenceToPrimaryKey());
            return this.cascadeDeleteEnabled && dialect.supportsCascadeDelete() ? result + " on delete cascade" : result;
        }
        throw new MappingException("A Sql constrain string cannot be created, the fk creation is disabled");
    }

    @Deprecated
    public String sqlDropString(Dialect dialect, String defaultCatalog, String defaultSchema) {
        StringBuilder buf = new StringBuilder("alter table ");
        buf.append(this.getTable().getQualifiedName(dialect, defaultCatalog, defaultSchema));
        buf.append(dialect.getDropForeignKeyString());
        if (dialect.supportsIfExistsBeforeConstraintName()) {
            buf.append("if exists ");
        }
        buf.append(dialect.quote(this.getName()));
        if (dialect.supportsIfExistsAfterConstraintName()) {
            buf.append(" if exists");
        }
        return buf.toString();
    }
}

