/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;
import org.hibernate.boot.model.domain.JavaTypeMapping;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Selectable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.DerivedColumn;
import org.hibernate.metamodel.model.relational.spi.PhysicalNamingStrategy;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.sql.Template;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class Formula
implements Selectable,
Serializable {
    private String formula;
    private Supplier<SqlTypeDescriptor> sqlTypeDescriptorAccess;
    private JavaTypeMapping javaTypeMapping;

    public Formula(String formula) {
        this.formula = formula;
    }

    @Override
    public String getTemplate(Dialect dialect, SqmFunctionRegistry functionRegistry) {
        String template = Template.renderWhereStringTemplate(this.formula, dialect, functionRegistry);
        return StringHelper.safeInterning(StringHelper.replace(template, "{alias}", "$PlaceHolder$"));
    }

    @Override
    public String getText(Dialect dialect) {
        return this.getFormula();
    }

    @Override
    public String getText() {
        return this.getFormula();
    }

    @Override
    public void setSqlTypeDescriptorAccess(Supplier<SqlTypeDescriptor> sqlTypeDescriptorAccess) {
        this.sqlTypeDescriptorAccess = sqlTypeDescriptorAccess;
    }

    @Override
    public SqlTypeDescriptor getSqlTypeDescriptor() {
        return this.sqlTypeDescriptorAccess.get();
    }

    @Override
    public JavaTypeMapping getJavaTypeMapping() {
        return this.javaTypeMapping;
    }

    @Override
    public void setJavaTypeMapping(JavaTypeMapping javaTypeMapping) {
        this.javaTypeMapping = javaTypeMapping;
    }

    @Override
    public Column generateRuntimeColumn(Table runtimeTable, PhysicalNamingStrategy namingStrategy, JdbcEnvironment jdbcEnvironment, TypeConfiguration typeConfiguration) {
        return new DerivedColumn(runtimeTable, this.formula, this.getSqlTypeDescriptor(), typeConfiguration, (BasicJavaDescriptor)this.getJavaTypeMapping().getJavaTypeDescriptor(), false, false);
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String string) {
        this.formula = string;
    }

    @Override
    public boolean isFormula() {
        return true;
    }

    @Override
    public boolean isInsertable() {
        return false;
    }

    @Override
    public boolean isUpdatable() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Formula formula1 = (Formula)o;
        return Objects.equals(this.formula, formula1.formula);
    }

    public int hashCode() {
        return Objects.hash(this.formula);
    }

    public String toString() {
        return this.getClass().getName() + "( " + this.formula + " )";
    }
}

