/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedIndex;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.metamodel.model.relational.spi.PhysicalNamingStrategy;
import org.hibernate.naming.Identifier;
import org.hibernate.type.spi.TypeConfiguration;

public class Index
implements MappedIndex,
Serializable {
    private Table table;
    private List<Column> columns = new ArrayList<Column>();
    private Map<Column, String> columnOrderMap = new HashMap<Column, String>();
    private Identifier name;

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void setTable(MappedTable table) {
        this.table = (Table)table;
    }

    @Override
    public int getColumnSpan() {
        return this.columns.size();
    }

    @Deprecated
    public Iterator<Column> getColumnIterator() {
        return this.columns.iterator();
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    public Map<Column, String> getColumnOrderMap() {
        return Collections.unmodifiableMap(this.columnOrderMap);
    }

    @Override
    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }

    @Override
    public void addColumn(Column column, String order) {
        this.addColumn(column);
        if (StringHelper.isNotEmpty(order)) {
            this.columnOrderMap.put(column, order);
        }
    }

    @Deprecated
    public void addColumns(Iterator extraColumns) {
        while (extraColumns.hasNext()) {
            this.addColumn((Column)extraColumns.next());
        }
    }

    @Override
    public void addColumns(List<? extends MappedColumn> columns) {
        for (MappedColumn mappedColumn : columns) {
            this.addColumn((Column)mappedColumn);
        }
    }

    public boolean containsColumn(Column column) {
        return this.columns.contains(column);
    }

    @Override
    public String getName() {
        return this.name == null ? null : this.name.getText();
    }

    @Override
    public void setName(String name) {
        this.name = Identifier.toIdentifier(name);
    }

    public String getQuotedName(Dialect dialect) {
        return this.name == null ? null : this.name.render(dialect);
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getName() + ")";
    }

    public org.hibernate.metamodel.model.relational.spi.Index generateRuntimeIndex(ExportableTable runtimeTable, PhysicalNamingStrategy namingStrategy, JdbcEnvironment jdbcEnvironment, TypeConfiguration typeConfiguration) {
        org.hibernate.metamodel.model.relational.spi.Index index = new org.hibernate.metamodel.model.relational.spi.Index(this.name, runtimeTable);
        for (Column column : this.columns) {
            PhysicalColumn runtimeColumn = column.generateRuntimeColumn(runtimeTable, namingStrategy, jdbcEnvironment, typeConfiguration);
            index.addColumn(runtimeColumn);
            if (!this.columnOrderMap.containsKey(column)) continue;
            index.addColumnOrder(runtimeColumn, this.columnOrderMap.get(column));
        }
        return index;
    }
}

