/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Value;

public abstract class IndexedCollection
extends Collection {
    public static final String DEFAULT_INDEX_COLUMN_NAME = "idx";
    private Value index;

    public IndexedCollection(MetadataBuildingContext buildingContext, PersistentClass owner) {
        super(buildingContext, owner);
    }

    public Value getIndex() {
        return this.index;
    }

    public void setIndex(Value index) {
        this.index = index;
    }

    @Override
    public final boolean isIndexed() {
        return true;
    }

    @Override
    public boolean isSame(Collection other) {
        return other instanceof IndexedCollection && this.isSame((IndexedCollection)other);
    }

    public boolean isSame(IndexedCollection other) {
        return super.isSame(other) && IndexedCollection.isSame(this.index, other.index);
    }

    @Override
    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey pk = new PrimaryKey(this.getMappedTable());
            pk.addColumns(this.getKey().getMappedColumns());
            boolean isFormula = false;
            for (MappedColumn selectable : this.getIndex().getMappedColumns()) {
                if (!selectable.isFormula()) continue;
                isFormula = true;
            }
            if (isFormula) {
                pk.addColumns(this.getElement().getMappedColumns());
            } else {
                pk.addColumns(this.getIndex().getMappedColumns());
            }
            this.getMappedTable().setPrimaryKey(pk);
        }
    }

    public boolean isList() {
        return false;
    }
}

